/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.util.request;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.LinkedList;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.request.Request;
import org.eclipse.kura.web.client.util.request.RequestContext;
import org.eclipse.kura.web.client.util.request.SuccessCallback;

public class RequestQueue {
    private static final RequestQueue instance = new RequestQueue();
    private final LinkedList<PendingRequest> requests = new LinkedList();
    private PendingRequest pending;

    public static void submit(Request request) {
        instance.submitInternal(request, true);
    }

    public static void submit(Request request, boolean enableWaitModal) {
        instance.submitInternal(request, enableWaitModal);
    }

    private void submitInternal(Request request, boolean enableWaitModal) {
        this.requests.push(new PendingRequest(request, new RequestContextImpl(enableWaitModal)));
        this.runNext();
    }

    private void runNext() {
        if (this.pending != null) {
            return;
        }
        if (this.requests.isEmpty()) {
            return;
        }
        this.pending = this.requests.pop();
        try {
            this.pending.request.run(this.pending.context);
        }
        catch (Exception e) {
            FailureHandler.handle(e);
            EntryClassUi.hideWaitModal();
            this.pending = null;
        }
    }

    private class PendingRequest {
        final Request request;
        final RequestContext context;

        public PendingRequest(Request request, RequestContext context) {
            this.request = request;
            this.context = context;
        }
    }

    private class RequestContextImpl
    implements RequestContext {
        private int requests = 0;
        private final boolean enableWaitModal;

        public RequestContextImpl(boolean enableWaitModal) {
            this.enableWaitModal = enableWaitModal;
        }

        private void completed() {
            if (this.enableWaitModal) {
                EntryClassUi.hideWaitModal();
            }
            RequestQueue.this.pending = null;
            RequestQueue.this.runNext();
        }

        private void newRequest() {
            ++this.requests;
            if (this.enableWaitModal) {
                EntryClassUi.showWaitModal();
            }
        }

        private void requestCompleted() {
            --this.requests;
            if (this.requests == 0) {
                this.completed();
            }
        }

        @Override
        public <T> AsyncCallback<T> callback(final SuccessCallback<T> callback) {
            return this.callback(new AsyncCallback<T>(){

                public void onFailure(Throwable caught) {
                    FailureHandler.handle(caught);
                }

                public void onSuccess(T result) {
                    callback.onSuccess(result);
                }
            });
        }

        @Override
        public <T> AsyncCallback<T> callback(final AsyncCallback<T> callback) {
            this.newRequest();
            return new AsyncCallback<T>(){

                public void onFailure(Throwable caught) {
                    try {
                        callback.onFailure(caught);
                    }
                    finally {
                        RequestContextImpl.this.requestCompleted();
                    }
                }

                public void onSuccess(T result) {
                    try {
                        callback.onSuccess(result);
                        RequestContextImpl.this.requestCompleted();
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }
            };
        }

        @Override
        public <T> AsyncCallback<T> callback() {
            return this.callback((T result) -> {});
        }

        @Override
        public void defer(int delayMs, final Runnable action) {
            this.newRequest();
            Timer timer = new Timer(){

                public void run() {
                    try {
                        try {
                            action.run();
                        }
                        catch (Exception e) {
                            FailureHandler.handle(e);
                            RequestContextImpl.this.requestCompleted();
                        }
                    }
                    finally {
                        RequestContextImpl.this.requestCompleted();
                    }
                }
            };
            timer.schedule(delayMs);
        }
    }
}

