/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.device;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import org.eclipse.kura.web.client.messages.ValidationMessages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.eclipse.kura.web.shared.service.GwtDeviceServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class ProfileTabUi
extends Composite
implements Tab {
    private static final String DEV_INFO = "devInfo";
    private static ProfileTabUiUiBinder uiBinder = (ProfileTabUiUiBinder)GWT.create(ProfileTabUiUiBinder.class);
    private static final ValidationMessages msgs = (ValidationMessages)GWT.create(ValidationMessages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtDeviceServiceAsync gwtDeviceService = (GwtDeviceServiceAsync)GWT.create(GwtDeviceService.class);
    @UiField
    CellTable<GwtGroupedNVPair> profileGrid = new CellTable();
    private final ListDataProvider<GwtGroupedNVPair> profileDataProvider = new ListDataProvider();

    public ProfileTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.profileGrid.setRowStyles((RowStyles)new RowStyles<GwtGroupedNVPair>(){

            public String getStyleNames(GwtGroupedNVPair row, int rowIndex) {
                return row.getValue().contains("  ") ? "rowHeader" : " ";
            }
        });
        this.loadProfileTable(this.profileGrid, this.profileDataProvider);
    }

    private void loadProfileTable(CellTable<GwtGroupedNVPair> profileGrid2, ListDataProvider<GwtGroupedNVPair> dataProvider) {
        TextColumn<GwtGroupedNVPair> col1 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return msgs.getString(object.getName());
            }
        };
        col1.setCellStyleNames("status-table-row");
        profileGrid2.addColumn((Column)col1);
        TextColumn<GwtGroupedNVPair> col2 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return String.valueOf(object.getValue());
            }
        };
        col2.setCellStyleNames("status-table-row");
        profileGrid2.addColumn((Column)col2);
        dataProvider.addDataDisplay(profileGrid2);
    }

    @Override
    public void setDirty(boolean flag) {
    }

    @Override
    public boolean isDirty() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void refresh() {
        this.profileDataProvider.getList().clear();
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                ProfileTabUi.this.gwtDeviceService.findDeviceConfiguration(token, new AsyncCallback<ArrayList<GwtGroupedNVPair>>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        ProfileTabUi.this.profileDataProvider.getList().clear();
                        FailureHandler.handle(caught);
                        ProfileTabUi.this.profileDataProvider.flush();
                    }

                    public void onSuccess(ArrayList<GwtGroupedNVPair> result) {
                        String oldGroup = ProfileTabUi.DEV_INFO;
                        ProfileTabUi.this.profileDataProvider.getList().add(new GwtGroupedNVPair(ProfileTabUi.DEV_INFO, ProfileTabUi.DEV_INFO, "  "));
                        for (GwtGroupedNVPair resultPair : result) {
                            if (!oldGroup.equals(resultPair.getGroup())) {
                                ProfileTabUi.this.profileDataProvider.getList().add(new GwtGroupedNVPair(resultPair.getGroup(), resultPair.getGroup(), "  "));
                                oldGroup = resultPair.getGroup();
                            }
                            ProfileTabUi.this.profileDataProvider.getList().add(resultPair);
                        }
                        int size = ProfileTabUi.this.profileDataProvider.getList().size();
                        (this).ProfileTabUi.this.profileGrid.setVisibleRange(0, size);
                        ProfileTabUi.this.profileDataProvider.flush();
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    static interface ProfileTabUiUiBinder
    extends UiBinder<Widget, ProfileTabUi> {
    }
}

