/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.modem;

import java.util.Arrays;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ModemConfig
implements NetConfig {
    private boolean enabled = false;
    private String dialString = "";
    private int pppNumber = 0;
    private int profileID = 0;
    private PdpType pdpType = PdpType.IP;
    private AuthType authType = AuthType.NONE;
    private String apn = "";
    private String username = "";
    private Password password = new Password("");
    private boolean persist = false;
    private int maxFail = 0;
    private int idle = 0;
    private String activeFilter = "";
    private int lcpEchoInterval = 0;
    private int lcpEchoFailure = 0;
    private IPAddress ipAddress = null;
    private int dataCompression = 0;
    private int headerCompression = 0;
    private boolean gpsEnabled = false;
    private int resetTimeout = 0;

    public ModemConfig() {
    }

    public ModemConfig(int profileID, PdpType pdpType, String apn, IPAddress ipAddress, int dataCompression, int headerCompresion) {
        this.profileID = profileID;
        this.pdpType = pdpType;
        this.apn = apn;
        this.ipAddress = ipAddress;
        this.dataCompression = dataCompression;
        this.headerCompression = headerCompresion;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDialString() {
        return this.dialString;
    }

    public void setDialString(String dialString) {
        this.dialString = dialString;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password.toString();
    }

    public Password getPasswordAsPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = new Password(password);
    }

    public void setPassword(Password password) {
        this.password = password;
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public int getMaxFail() {
        return this.maxFail;
    }

    public void setMaxFail(int maxFail) {
        this.maxFail = maxFail;
    }

    public int getIdle() {
        return this.idle;
    }

    public void setIdle(int idle) {
        this.idle = idle;
    }

    public String getActiveFilter() {
        return this.activeFilter;
    }

    public void setActiveFilter(String activeFilter) {
        this.activeFilter = activeFilter;
    }

    public int getLcpEchoInterval() {
        return this.lcpEchoInterval;
    }

    public void setLcpEchoInterval(int lcpEchoInterval) {
        this.lcpEchoInterval = lcpEchoInterval;
    }

    public int getLcpEchoFailure() {
        return this.lcpEchoFailure;
    }

    public void setLcpEchoFailure(int lcpEchoFailure) {
        this.lcpEchoFailure = lcpEchoFailure;
    }

    public int getPppNumber() {
        return this.pppNumber;
    }

    public void setPppNumber(int pppNumber) {
        this.pppNumber = pppNumber;
    }

    public int getProfileID() {
        return this.profileID;
    }

    public void setProfileID(int id) {
        this.profileID = id;
    }

    public PdpType getPdpType() {
        return this.pdpType;
    }

    public void setPdpType(PdpType pdpType) {
        this.pdpType = pdpType;
    }

    public String getApn() {
        return this.apn;
    }

    public void setApn(String apn) {
        this.apn = apn;
    }

    public IPAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(IPAddress address) {
        this.ipAddress = address;
    }

    public int getDataCompression() {
        return this.dataCompression;
    }

    public void setDataCompression(int dataCompression) {
        this.dataCompression = dataCompression;
    }

    public int getHeaderCompression() {
        return this.headerCompression;
    }

    public void setHeaderCompression(int headerCompression) {
        this.headerCompression = headerCompression;
    }

    public boolean isDataCompression() {
        return this.dataCompression != 0;
    }

    public boolean isHeaderCompression() {
        return this.headerCompression != 0;
    }

    public boolean isGpsEnabled() {
        return this.gpsEnabled;
    }

    public int getResetTimeout() {
        return this.resetTimeout;
    }

    public void setResetTimeout(int tout) {
        this.resetTimeout = tout;
    }

    public void setGpsEnabled(boolean gpsEnabled) {
        this.gpsEnabled = gpsEnabled;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 59 * result + this.profileID;
        result = 59 * result + (this.pdpType == null ? 0 : this.pdpType.hashCode());
        result = 59 * result + (this.authType == null ? 0 : this.authType.hashCode());
        result = 59 * result + (this.apn == null ? 0 : this.apn.hashCode());
        result = 59 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 59 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 59 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 59 * result + this.pppNumber;
        result = 59 * result + this.maxFail;
        result = 59 * result + this.resetTimeout;
        result = 59 * result + this.idle;
        result = 59 * result + (this.activeFilter == null ? 0 : this.activeFilter.hashCode());
        result = 59 * result + this.lcpEchoFailure;
        result = 59 * result + this.lcpEchoInterval;
        result = 59 * result + this.dataCompression;
        result = 59 * result + this.headerCompression;
        result = 59 * result + (this.persist ? 1 : 0);
        result = 59 * result + (this.gpsEnabled ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        Password otherConfigPassword;
        if (!(obj instanceof ModemConfig)) {
            return false;
        }
        ModemConfig otherConfig = (ModemConfig)obj;
        if (this.enabled != otherConfig.isEnabled()) {
            return false;
        }
        if (this.pppNumber != otherConfig.getPppNumber()) {
            return false;
        }
        if (this.persist != otherConfig.isPersist()) {
            return false;
        }
        if (this.maxFail != otherConfig.getMaxFail()) {
            return false;
        }
        if (this.resetTimeout != otherConfig.getResetTimeout()) {
            return false;
        }
        if (this.idle != otherConfig.getIdle()) {
            return false;
        }
        if (this.lcpEchoInterval != otherConfig.getLcpEchoInterval()) {
            return false;
        }
        if (this.lcpEchoFailure != otherConfig.getLcpEchoFailure()) {
            return false;
        }
        if (this.profileID != otherConfig.getProfileID()) {
            return false;
        }
        if (this.pdpType != otherConfig.getPdpType()) {
            return false;
        }
        if (this.authType != otherConfig.getAuthType()) {
            return false;
        }
        if (this.dataCompression != otherConfig.getDataCompression()) {
            return false;
        }
        if (this.headerCompression != otherConfig.getHeaderCompression()) {
            return false;
        }
        if (this.gpsEnabled != otherConfig.isGpsEnabled()) {
            return false;
        }
        if (this.dialString != null ? !this.dialString.equals(otherConfig.getDialString()) : otherConfig.getDialString() != null) {
            return false;
        }
        if (this.apn != null ? !this.apn.equals(otherConfig.getApn()) : otherConfig.getApn() != null) {
            return false;
        }
        if (this.username != null && this.username.length() > 0 ? !this.username.equals(otherConfig.getUsername()) : otherConfig.getUsername() != null && otherConfig.getUsername().length() > 0) {
            return false;
        }
        if (this.password != null && this.password.getPassword().length > 0 ? !Arrays.equals(this.password.getPassword(), otherConfig.getPasswordAsPassword().getPassword()) : (otherConfigPassword = otherConfig.getPasswordAsPassword()) != null && otherConfigPassword.getPassword().length > 0) {
            return false;
        }
        if (this.activeFilter != null && this.activeFilter.length() > 0 ? !this.activeFilter.equals(otherConfig.getActiveFilter()) : otherConfig.getActiveFilter() != null && otherConfig.getActiveFilter().length() > 0) {
            return false;
        }
        return !(this.ipAddress != null ? !this.ipAddress.equals(otherConfig.ipAddress) : otherConfig.getIpAddress() != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("ModemConfig - ");
        sb.append("Enabled: ").append(this.enabled);
        sb.append(" - PPP Number: ").append(this.pppNumber);
        sb.append(" - Dial String: ").append(this.dialString);
        sb.append(" - Profile ID: ").append(this.profileID);
        sb.append(" - PDP Type: ").append((Object)this.pdpType);
        sb.append(" - Auth Type: ").append((Object)this.authType);
        sb.append(" - APN: ").append(this.apn);
        sb.append(" - Username: ").append(this.username);
        sb.append(" - Password: ").append(this.password);
        sb.append(" - IP Address: ").append(this.ipAddress == null ? "null" : this.ipAddress.getHostAddress());
        sb.append(" - Data Compression: ").append(this.dataCompression);
        sb.append(" - Header Compression: ").append(this.headerCompression);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.pppNumber >= 0;
    }

    public static enum AuthType {
        NONE,
        AUTO,
        PAP,
        CHAP;

    }

    public static enum PdpType {
        IP,
        PPP,
        IPv6,
        UNKNOWN;

    }
}

