/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.LogViewerTools;
import com.sun.javatest.logging.FilteredLogModel;
import com.sun.javatest.logging.LogModel;
import com.sun.javatest.logging.LoggerFactory;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

class LogViewer
extends ToolDialog {
    private UIFactory uif;
    private final Level[] levels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE};
    private final String[] levelNames = new String[]{LoggerFactory.getLocalizedLevelName(Level.SEVERE), LoggerFactory.getLocalizedLevelName(Level.WARNING), LoggerFactory.getLocalizedLevelName(Level.INFO), LoggerFactory.getLocalizedLevelName(Level.FINE)};
    private DefaultMutableTreeNode treeRoot;
    private JComboBox filterCombo;
    private JTree filterTree;
    private boolean noWindow = false;
    private JLabel lblPageCounter;
    private JButton btnFirst;
    private JButton btnLast;
    private JButton btnNext;
    private JButton btnPrev;
    private JCheckBox autoScrollCheckBox;
    private JLabel counter;
    private JLabel currPage;
    private JButton btnSave;
    private JButton btnClear;
    private JPanel naviPanel;
    private JScrollPane scrollPane;
    private LogPane thePane;
    private JLabel loggerCounter;
    private JLabel pageCounter;
    private JLabel processLabel;
    private WorkDirectory workDir;
    private Thread editorThread;
    private StyledDocument doc;
    private Style styleMsg;
    private Style styleInfo;
    private Style styleWarning;
    private Style styleSevere;
    private Style styleOther;
    private Style styleWait;
    private Style selected;
    private FilteredLogModel model;
    private Logger log;
    private final int debug = 0;
    private final int debugPages = 0;
    private boolean autoScroll = true;
    private FilterComboBoxListener filterComboBoxListener;
    private JScrollPane filterTreeScroll;
    private boolean wordWrap = false;
    private Preferences prefs = Preferences.access();
    private static final String AUTOSCROLL_PREF = "logviewer.autoScroll";
    private static final String WORDWRAP_PREF = "logviewer.wordWrap";
    private int windowCounter = 0;
    private static HashSet<Integer> windowList = new HashSet();
    private String working1;
    private String working2;

    public LogViewer(WorkDirectory workDir, UIFactory uif, Component parent) {
        super(parent, uif, "logviewer");
        String fileName = workDir.getLogFileName();
        this.uif = uif;
        this.workDir = workDir;
        this.makeLogger(workDir);
        this.model = new FilteredLogModel(workDir.getTestSuite().getObservedFile(fileName), fileName);
        this.model.setLogger(this.log);
        this.initGUI();
        this.model.addNewLoggerListener(new LogModel.LoggerListener(){

            @Override
            public void onNewLogger(String logName) {
            }

            @Override
            public void onRemoveAllLoggers() {
            }
        });
        this.model.addNewPageListener(new LogModel.NewPageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewPage(int from, int to, int page) {
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    if (((LogViewer)LogViewer.this).thePane.page == 0 && LogViewer.this.model.isStableState()) {
                        LogViewer.this.setPage(page);
                    } else if (((LogViewer)LogViewer.this).thePane.page == page && LogViewer.this.model.isStableState()) {
                        LogViewer.this.updatePage(from, to);
                    } else if (LogViewer.this.model.isStableState()) {
                        LogViewer.this.updateNavBtns();
                    }
                }
            }
        });
        this.model.addFilterChangedListener(new FilteredLogModel.FilterChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFilterChanged() {
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    ((LogViewer)LogViewer.this).thePane.page = 0;
                    ((LogViewer)LogViewer.this).thePane.fromRec = 0;
                }
            }
        });
        this.model.init();
        this.updateNavBtns();
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        LV_Scroller autoScroller = new LV_Scroller();
        autoScroller.start();
    }

    @Override
    protected void windowClosingAction(AWTEvent e) {
        this.onClose(null);
    }

    private void makeLogger(WorkDirectory workDir) {
        this.log = Logger.getLogger("LogViewer");
        try {
            this.log = workDir.getTestSuite().createLog(workDir, null, "LogViewer");
        }
        catch (TestSuite.DuplicateLogNameFault ex) {
            try {
                this.log = workDir.getTestSuite().getLog(workDir, "LogViewer");
            }
            catch (TestSuite.NoSuchLogFault exe) {
                exe.printStackTrace();
            }
        }
    }

    @Override
    protected void initGUI() {
        this.working1 = this.uif.getI18NString("logviewer.working1");
        this.working2 = this.uif.getI18NString("logviewer.working2");
        JPanel body = new JPanel();
        this.addWindowToList();
        this.setI18NTitle("logviewer.title", this.windowCounter);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        Object[] items = new Object[]{this.uif.getI18NString("logviewer.combobox.actions"), new JSeparator(), new FilterComboboxItem(this.uif.getI18NString("logviewer.combobox.selectall"), true), new FilterComboboxItem(this.uif.getI18NString("logviewer.combobox.clearall"), false), new JSeparator(), new FilterComboboxItem(this.uif.getI18NString("logviewer.combobox.select") + this.levelNames[0], this.levels[0]), new FilterComboboxItem(this.uif.getI18NString("logviewer.combobox.select") + this.levelNames[1], this.levels[1]), new FilterComboboxItem(this.uif.getI18NString("logviewer.combobox.select") + this.levelNames[2], this.levels[2]), new FilterComboboxItem(this.uif.getI18NString("logviewer.combobox.select") + this.levelNames[3], this.levels[3])};
        this.filterCombo = this.uif.createLiteralChoice("logviewer.combobox", items);
        this.uif.setAccessibleName(this.filterCombo, this.filterCombo.getName());
        this.filterCombo.setRenderer(new CustomRenderer());
        this.filterTreeScroll = new JScrollPane();
        this.createFilterTree(this.filterTreeScroll);
        JLabel filterSubstringLbl = this.uif.createLabel("logviewer.label.find");
        final JTextField filterSubstring = this.uif.createInputField("logviewer.fitertext");
        this.uif.setAccessibleInfo(filterSubstring, filterSubstring.getName());
        filterSubstring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogViewer.this.model.getFilter().setSubstring(filterSubstring.getText());
            }
        });
        this.autoScrollCheckBox = this.uif.createCheckBox("logviewer.autoscroll");
        this.autoScroll = Boolean.parseBoolean(this.prefs.getPreference(AUTOSCROLL_PREF, Boolean.toString(true)));
        this.autoScrollCheckBox.setSelected(this.autoScroll);
        this.autoScrollCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogViewer.this.autoScroll = e.getStateChange() == 1;
                LogViewer.this.prefs.setPreference(LogViewer.AUTOSCROLL_PREF, Boolean.toString(LogViewer.this.autoScroll));
            }
        });
        JCheckBox wordWrapCheckBox = this.uif.createCheckBox("logviewer.wordwarp");
        this.wordWrap = Boolean.parseBoolean(this.prefs.getPreference(WORDWRAP_PREF, Boolean.toString(false)));
        wordWrapCheckBox.setSelected(this.wordWrap);
        wordWrapCheckBox.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                LogViewer.this.wordWrap = e.getStateChange() == 1;
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    Point vp = LogViewer.this.scrollPane.getViewport().getViewPosition();
                    Dimension vs = LogViewer.this.scrollPane.getViewport().getViewSize();
                    final double magic = vp.getY() / vs.getHeight();
                    int p = ((LogViewer)LogViewer.this).thePane.page;
                    LogViewer.this.clearPane(0);
                    LogViewer.this.setPage(p);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            double newMagic = (double)LogViewer.this.thePane.getDocument().getLength() * magic;
                            LogViewer.this.thePane.setCaretPosition((int)newMagic);
                        }
                    });
                }
                LogViewer.this.prefs.setPreference(LogViewer.WORDWRAP_PREF, Boolean.toString(LogViewer.this.wordWrap));
            }
        });
        this.scrollPane = new JScrollPane();
        this.thePane = new LogPane();
        this.thePane.setEditorKit(new LogEditorKit());
        JButton btnClose = this.uif.createButton("logviewer.button.close");
        JButton btnNew = this.uif.createButton("logviewer.button.open");
        this.btnSave = this.uif.createButton("logviewer.button.save");
        this.btnClear = this.uif.createButton("logviewer.button.clear");
        this.naviPanel = new JPanel();
        this.processLabel = new JLabel();
        Font old = this.processLabel.getFont();
        this.processLabel.setFont(old.deriveFont(old.getSize() - 1));
        JPanel naviBtnPanel = new JPanel();
        this.lblPageCounter = new JLabel();
        this.lblPageCounter.setVerticalAlignment(1);
        this.btnFirst = this.uif.createButton("logviewer.firstpage");
        this.btnNext = this.uif.createButton("logviewer.nextpage");
        this.btnPrev = this.uif.createButton("logviewer.previouspage");
        this.btnLast = this.uif.createButton("logviewer.lastspage");
        body.setLayout(new GridBagLayout());
        this.thePane.setEditable(false);
        this.thePane.setPreferredSize(new Dimension(600, 400));
        this.scrollPane.setViewportView(this.thePane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        filterPanel.add((Component)this.filterCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        filterPanel.add((Component)this.filterTreeScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        filterPanel.add((Component)filterSubstringLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        filterPanel.add((Component)filterSubstring, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 5, 5);
        body.add((Component)filterPanel, gridBagConstraints);
        this.initPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 5, 11);
        body.add((Component)this.scrollPane, gridBagConstraints);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.onClose(evt);
            }
        });
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.onNew(evt);
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.onSave(evt);
            }
        });
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.onClear(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        body.add((Component)this.autoScrollCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        body.add((Component)wordWrapCheckBox, gridBagConstraints);
        naviBtnPanel.setLayout(new GridLayout(1, 4, 10, 10));
        this.btnFirst.setEnabled(false);
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.goFirst(evt);
            }
        });
        naviBtnPanel.add(this.btnFirst);
        this.btnPrev.setEnabled(false);
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.goPrev(evt);
            }
        });
        naviBtnPanel.add(this.btnPrev);
        this.btnNext.setEnabled(false);
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.goNext(evt);
            }
        });
        naviBtnPanel.add(this.btnNext);
        this.btnLast.setEnabled(false);
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.goLast(evt);
            }
        });
        naviBtnPanel.add(this.btnLast);
        this.naviPanel.setLayout(new BorderLayout());
        this.naviPanel.add((Component)this.lblPageCounter, "West");
        this.naviPanel.add((Component)naviBtnPanel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        body.add((Component)this.processLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 11);
        body.add((Component)this.naviPanel, gridBagConstraints);
        this.setButtons(new JButton[]{this.btnClear, this.btnSave, btnNew, btnClose}, btnClose);
        this.setBody(body);
    }

    private void createFilterTree(JScrollPane filterTreeScroll) {
        this.treeRoot = new DefaultMutableTreeNode(new JCheckBox("Root"));
        this.filterTree = new JTree();
        LoggersTreeModel ltm = new LoggersTreeModel();
        this.filterTree.setModel(ltm);
        this.filterTree.setCellRenderer(new CheckBoxRenderer());
        this.filterTree.setCellEditor(new CheckBoxEditor(this.filterTree));
        this.filterTree.setRootVisible(false);
        this.filterTree.setEditable(true);
        filterTreeScroll.setViewportView(this.filterTree);
        if (this.filterComboBoxListener != null) {
            this.filterCombo.removeActionListener(this.filterComboBoxListener);
        }
        this.filterComboBoxListener = new FilterComboBoxListener(ltm);
        this.filterCombo.addActionListener(this.filterComboBoxListener);
        this.filterTree.setName("logviewer.logtree");
        this.uif.setAccessibleInfo(this.filterTree, this.filterTree.getName());
    }

    private Logger getLogger() {
        Random r = new Random();
        String lName = "log_" + r.nextInt(10);
        Logger ret = null;
        try {
            ret = this.workDir.getTestSuite().createLog(this.workDir, null, lName);
        }
        catch (TestSuite.DuplicateLogNameFault ex) {
            try {
                ret = this.workDir.getTestSuite().getLog(this.workDir, lName);
            }
            catch (TestSuite.NoSuchLogFault exe) {
                exe.printStackTrace();
            }
        }
        return ret;
    }

    private void setRecords(int from, int to, int pagenum) {
        if (this.editorThread != null && this.editorThread.isAlive()) {
            this.editorThread.interrupt();
            try {
                this.editorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.editorThread = new EditorFiller(from, to, pagenum);
        this.editorThread.setPriority(1);
        this.editorThread.start();
    }

    private void clearPane(final int from) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LogViewer.this.doc != null) {
                    try {
                        LogViewer.this.doc.remove(0, LogViewer.this.doc.getEndPosition().getOffset() - 1);
                        LogPane logPane = LogViewer.this.thePane;
                        synchronized (logPane) {
                            ((LogViewer)LogViewer.this).thePane.fromRec = from - 1;
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private Style getStyle(int level) {
        if (level < Level.INFO.intValue()) {
            return this.styleOther;
        }
        if (level < Level.WARNING.intValue()) {
            return this.styleInfo;
        }
        if (level < Level.SEVERE.intValue()) {
            return this.styleWarning;
        }
        return this.styleSevere;
    }

    private void goLast(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    LogViewer.this.setPage(LogViewer.this.model.pagesRead());
                }
            }
        });
    }

    private void goPrev(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    LogViewer.this.autoScrollCheckBox.setSelected(false);
                    LogViewer.this.autoScroll = false;
                    LogViewer.this.setPage(((LogViewer)LogViewer.this).thePane.page - 1);
                }
            }
        });
    }

    private void goNext(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    LogViewer.this.setPage(((LogViewer)LogViewer.this).thePane.page + 1);
                }
            }
        });
    }

    private void goFirst(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    LogViewer.this.autoScrollCheckBox.setSelected(false);
                    LogViewer.this.autoScroll = false;
                    LogViewer.this.setPage(1);
                }
            }
        });
    }

    private void onClose(ActionEvent evt) {
        this.dispose();
    }

    private void onNew(ActionEvent evt) {
        LogViewer lv = new LogViewer(this.workDir, this.uif, this.parent);
        Point newL = this.getLocation();
        newL.translate(20, 20);
        lv.setLocation(newL);
    }

    private void onSave(ActionEvent evt) {
        FileChooser fileChooser = new FileChooser(true);
        fileChooser.addChoosableExtension(".xml", this.uif.getI18NString("logviewer.save.ext.xml"));
        fileChooser.setDialogTitle(this.uif.getI18NString("logviewer.save.title"));
        if (fileChooser.showDialog(this.parent, this.uif.getI18NString("ce.save.btn")) != 0) {
            return;
        }
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            if (!f.getName().toLowerCase().endsWith(".xml")) {
                f = new File(f.getPath() + ".xml");
            }
            LogViewerTools rm = new LogViewerTools(this.model, f, this.log, this.parent, this.uif);
            rm.go();
        }
    }

    private void onClear(ActionEvent evt) {
        if (this.uif.showYesNoDialog("logviewer.clearconfirm") == 0) {
            try {
                this.workDir.getTestSuite().eraseLog(this.workDir);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void updatePage(int from, int to) {
        this.setRecords(from, to, this.thePane.page);
        this.updateNavBtns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPage(int pageNum) {
        int from = (pageNum - 1) * this.model.getPageSize();
        int to = pageNum * this.model.getPageSize() - 1;
        LogPane logPane = this.thePane;
        synchronized (logPane) {
            this.thePane.page = pageNum;
        }
        this.clearPane(from);
        this.setRecords(from, to, pageNum);
        this.updateNavBtns();
    }

    private void updateNavBtns() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LogViewer.this.noWindow) {
                    return;
                }
                LogPane logPane = LogViewer.this.thePane;
                synchronized (logPane) {
                    if (LogViewer.this.model != null && LogViewer.this.btnFirst != null && LogViewer.this.btnLast != null && LogViewer.this.btnPrev != null && LogViewer.this.btnNext != null && LogViewer.this.lblPageCounter != null && LogViewer.this.naviPanel != null && LogViewer.this.btnSave != null) {
                        LogViewer.this.btnFirst.setEnabled(((LogViewer)LogViewer.this).thePane.page > 1);
                        LogViewer.this.btnLast.setEnabled(((LogViewer)LogViewer.this).thePane.page < LogViewer.this.model.pagesRead() && LogViewer.this.model.pagesRead() > 1);
                        LogViewer.this.btnPrev.setEnabled(((LogViewer)LogViewer.this).thePane.page > 1);
                        LogViewer.this.btnNext.setEnabled(((LogViewer)LogViewer.this).thePane.page < LogViewer.this.model.pagesRead() && LogViewer.this.model.pagesRead() > 1);
                        String pop = LogViewer.this.uif.getI18NString("logviewer.pageofpage", new Object[]{((LogViewer)LogViewer.this).thePane.page, LogViewer.this.model.pagesRead()});
                        LogViewer.this.lblPageCounter.setText(pop);
                        LogViewer.this.naviPanel.setVisible(LogViewer.this.btnFirst.isEnabled() || LogViewer.this.btnFirst.isEnabled() || LogViewer.this.btnLast.isEnabled() || LogViewer.this.btnNext.isEnabled());
                        LogViewer.this.btnSave.setEnabled(LogViewer.this.model.isStableState() && LogViewer.this.model.recordsRead() > 0);
                        LogViewer.this.btnClear.setEnabled(LogViewer.this.model.pagesRead() > 0);
                    }
                }
            }
        });
    }

    private void initPane() {
        this.doc = this.thePane.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        this.styleMsg = this.doc.addStyle("msg_text", def);
        StyleConstants.setFontFamily(this.styleMsg, "Monospaced");
        this.styleWait = this.doc.addStyle("blink", this.styleMsg);
        StyleConstants.setBold(this.styleWait, true);
        this.styleInfo = this.doc.addStyle("info_text", this.styleMsg);
        Color darkGreen = new Color(0, 180, 0);
        StyleConstants.setForeground(this.styleInfo, darkGreen);
        this.styleWarning = this.doc.addStyle("warning_text", this.styleMsg);
        StyleConstants.setForeground(this.styleWarning, new Color(200, 150, 0));
        this.styleSevere = this.doc.addStyle("severe_text", this.styleMsg);
        StyleConstants.setForeground(this.styleSevere, Color.RED);
        this.styleOther = this.doc.addStyle("other_text", this.styleMsg);
        StyleConstants.setForeground(this.styleOther, Color.BLUE);
        this.selected = this.doc.addStyle("selected", null);
        StyleConstants.setBackground(this.selected, Color.YELLOW);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this.removeWindowFromList();
        if (this.noWindow) {
            return;
        }
        this.noWindow = true;
        this.model.dispose();
        super.dispose();
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        this.thePane = null;
        this.doc = null;
        this.model = null;
        this.workDir = null;
        this.scrollPane = null;
        this.log = null;
    }

    private void removeWindowFromList() {
        windowList.remove(this.windowCounter);
    }

    private void addWindowToList() {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (windowList.contains(i)) continue;
            this.windowCounter = i;
            windowList.add(i);
            return;
        }
        this.windowCounter = 0;
    }

    private class LV_Scroller
    extends Thread {
        public LV_Scroller() {
            super("LV_scroller");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (LogViewer.this.noWindow) {
                        return;
                    }
                    boolean reset = false;
                    if (LogViewer.this.model.isStableState()) {
                        if (LogViewer.this.autoScroll) {
                            reset = ((LogViewer)LogViewer.this).thePane.page != LogViewer.this.model.pagesRead();
                        } else {
                            boolean bl = reset = ((LogViewer)LogViewer.this).thePane.page > LogViewer.this.model.pagesRead() || ((LogViewer)LogViewer.this).thePane.page == 0;
                        }
                    }
                    if (reset) {
                        LogViewer.this.setPage(LogViewer.this.model.pagesRead());
                        this.setBusy(!LogViewer.this.model.isStableState());
                        LV_Scroller.sleep(500L);
                        continue;
                    }
                    if (LogViewer.this.model.isStableState()) {
                        this.setBusy(false);
                        if (LogViewer.this.autoScroll) {
                            LogPane logPane = LogViewer.this.thePane;
                            synchronized (logPane) {
                                final JScrollBar sb = LogViewer.this.scrollPane.getVerticalScrollBar();
                                if (sb != null) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            sb.setValue(sb.getMaximum());
                                        }
                                    });
                                }
                            }
                        } else if (LogViewer.this.thePane.getCaret() == null) {
                            LogViewer.this.thePane.setCaretPosition(0);
                        }
                    } else {
                        this.setBusy(true);
                    }
                    LV_Scroller.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private void setBusy(boolean b) {
            if (!b) {
                LogViewer.this.processLabel.setText("");
            } else {
                String oldText = LogViewer.this.processLabel.getText();
                if ("".equals(oldText) || LogViewer.this.working1.equals(oldText)) {
                    LogViewer.this.processLabel.setText(LogViewer.this.working2);
                } else {
                    LogViewer.this.processLabel.setText(LogViewer.this.working1);
                }
            }
        }
    }

    private class FilterComboBoxListener
    implements ActionListener {
        private LoggersTreeModel model;

        public FilterComboBoxListener(LoggersTreeModel m) {
            this.model = m;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Object o = cb.getSelectedItem();
            if (o instanceof FilterComboboxItem) {
                FilterComboboxItem fc = (FilterComboboxItem)o;
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.model.getRoot();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DefaultMutableTreeNode fstLevelCh = (DefaultMutableTreeNode)root.getChildAt(i);
                    PropagatedCheckBox chLog = (PropagatedCheckBox)fstLevelCh.getUserObject();
                    if (fc.kind) {
                        boolean needToFire = chLog.isSelected() == fc.select;
                        chLog.setSelected(fc.select);
                        if (!needToFire) continue;
                        chLog.fireEvent();
                        continue;
                    }
                    boolean allSelected = true;
                    for (int j = 0; j < fstLevelCh.getChildCount(); ++j) {
                        DefaultMutableTreeNode secondLevelCh = (DefaultMutableTreeNode)fstLevelCh.getChildAt(j);
                        FilterTreeItem chLev = (FilterTreeItem)secondLevelCh.getUserObject();
                        if (chLev.level == fc.level && !chLev.isSelected()) {
                            chLev.setSelected(true);
                            LogViewer.this.filterTree.repaint();
                            continue;
                        }
                        allSelected = allSelected && chLev.isSelected();
                    }
                    if (!allSelected || chLog.isSelected()) continue;
                    chLog.setSelected(true);
                    LogViewer.this.filterTree.repaint();
                }
                cb.setSelectedIndex(0);
            }
        }
    }

    private class FilterComboboxItem {
        boolean kind;
        private String label;
        int level;
        boolean select;

        public FilterComboboxItem(String txt, Level l) {
            this.label = txt;
            this.level = l.intValue();
            this.kind = false;
        }

        public FilterComboboxItem(String txt, boolean s) {
            this.label = txt;
            this.select = s;
            this.kind = true;
        }

        public String toString() {
            return this.label;
        }
    }

    private class FilterTreeItem
    extends JCheckBox {
        String logName;
        int level;

        public FilterTreeItem(String logName, int level, String levelName) {
            super(levelName);
            this.logName = logName;
            this.level = level;
        }
    }

    private class PropagatedCheckBox
    extends JCheckBox {
        private ArrayList<JCheckBox> children;

        PropagatedCheckBox(String name) {
            super(name);
            this.children = new ArrayList();
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    for (JCheckBox aChildren : PropagatedCheckBox.this.children) {
                        boolean s = PropagatedCheckBox.this.isSelected();
                        if (aChildren.isSelected() == s) continue;
                        aChildren.setSelected(s);
                    }
                    LogViewer.this.filterTree.repaint();
                }
            });
        }

        public void fireEvent() {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        public void addChild(JCheckBox ch) {
            this.children.add(ch);
        }
    }

    private class LoggersTreeModel
    extends DefaultTreeModel {
        LoggersTreeModel() {
            super(LogViewer.this.treeRoot);
            LogViewer.this.model.removeNewLoggerListeners();
            LogViewer.this.model.addNewLoggerListener(new LogModel.LoggerListener(){

                @Override
                public void onNewLogger(final String name) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PropagatedCheckBox ch = new PropagatedCheckBox(name);
                            ch.setSelected(true);
                            DefaultMutableTreeNode newLogger = new DefaultMutableTreeNode(ch, true);
                            for (int i = 0; i < LogViewer.this.levels.length; ++i) {
                                final FilterTreeItem chh = new FilterTreeItem(name, LogViewer.this.levels[i].intValue(), LogViewer.this.levelNames[i]);
                                chh.setSelected(true);
                                final int level = LogViewer.this.levels[i].intValue();
                                chh.addItemListener(new ItemListener(){
                                    JCheckBox box;
                                    int l;
                                    String logName;
                                    {
                                        this.box = chh;
                                        this.l = level;
                                        this.logName = name;
                                    }

                                    @Override
                                    public void itemStateChanged(ItemEvent e) {
                                        LogViewer.this.model.getFilter().enableLogger(this.logName, this.l, this.box.isSelected());
                                    }
                                });
                                ch.addChild(chh);
                                DefaultMutableTreeNode node = new DefaultMutableTreeNode(chh);
                                newLogger.add(node);
                            }
                            LogViewer.this.treeRoot.add(newLogger);
                            LoggersTreeModel.this.nodesWereInserted(LogViewer.this.treeRoot, new int[]{LogViewer.this.treeRoot.getIndex(newLogger)});
                            LogViewer.this.filterTree.expandPath(new TreePath(newLogger.getPath()));
                        }
                    });
                }

                @Override
                public void onRemoveAllLoggers() {
                    LogViewer.this.createFilterTree(LogViewer.this.filterTreeScroll);
                }
            });
        }
    }

    private class CustomRenderer
    extends JComponent
    implements ListCellRenderer {
        private CustomRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof JSeparator) && !(value instanceof JCheckBox)) {
                DefaultListCellRenderer defRend = new DefaultListCellRenderer();
                return defRend.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            if (value instanceof JSeparator) {
                return (JSeparator)value;
            }
            if (value instanceof JCheckBox) {
                if (isSelected) {
                    ((JCheckBox)value).setBackground(list.getSelectionBackground());
                    ((JCheckBox)value).setForeground(list.getSelectionForeground());
                } else {
                    ((JCheckBox)value).setBackground(list.getBackground());
                    ((JCheckBox)value).setForeground(list.getForeground());
                }
                return (JCheckBox)value;
            }
            return this;
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TreeCellRenderer {
        DefaultTreeCellRenderer defRend = new DefaultTreeCellRenderer();

        public CheckBoxRenderer() {
            this.setBackground(LogViewer.this.filterTree.getBackground());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object o;
            if (value instanceof DefaultMutableTreeNode && (o = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)o;
                this.setText(cb.getText());
                this.setSelected(cb.isSelected());
                return this;
            }
            return this.defRend.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        }
    }

    private class CheckBoxEditor
    extends DefaultTreeCellEditor {
        CheckBoxEditor(JTree tree) {
            super(tree, new DefaultTreeCellRenderer());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            DefaultMutableTreeNode node;
            Object o;
            if (value instanceof DefaultMutableTreeNode && (o = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)o;
                cb.setBackground(tree.getBackground());
                return cb;
            }
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            return true;
        }
    }

    private class LogPane
    extends JTextPane {
        int page;
        int fromRec;

        public LogPane() {
            this.setName("logviewer.viewerpane");
            LogViewer.this.uif.setAccessibleName(this, this.getName());
        }
    }

    private class LogEditorKit
    extends StyledEditorKit {
        ViewFactory fact;

        private LogEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            if (this.fact == null) {
                this.fact = new LogViewFactory();
            }
            return this.fact;
        }

        private class LogViewFactory
        implements ViewFactory {
            private LogViewFactory() {
            }

            @Override
            public View create(Element elem) {
                String kind = elem.getName();
                if (kind != null) {
                    if (kind.equals("content")) {
                        if (!LogViewer.this.wordWrap) {
                            return new NoWrapLabelView(elem);
                        }
                        return new LabelView(elem);
                    }
                    if (kind.equals("paragraph")) {
                        return new ParagraphView(elem);
                    }
                    if (kind.equals("section")) {
                        return new BoxView(elem, 1);
                    }
                    if (kind.equals("component")) {
                        return new ComponentView(elem);
                    }
                    if (kind.equals("icon")) {
                        return new IconView(elem);
                    }
                }
                return new LabelView(elem);
            }
        }

        class NoWrapLabelView
        extends LabelView {
            public NoWrapLabelView(Element elem) {
                super(elem);
            }

            @Override
            public int getBreakWeight(int axis, float pos, float len) {
                return 0;
            }
        }
    }

    private class EditorFiller
    extends Thread {
        private int pagenum;
        private int to;
        private int from;

        EditorFiller(int from, int to, int pagenum) {
            super("editorFiller");
            this.from = from;
            this.to = to;
            this.pagenum = pagenum;
        }

        @Override
        public void run() {
            if (LogViewer.this.noWindow) {
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<LogModel.LiteLogRecord> records = LogViewer.this.model.getRecords();
            for (int i = this.from; i <= this.to && i < records.size() && i >= 0; ++i) {
                String hd;
                if (LogViewer.this.noWindow) {
                    return;
                }
                LogModel.LiteLogRecord rec = records.get(i);
                if (rec == null) continue;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                final String msg = LogViewer.this.model.getRecordMessage(rec);
                final int level = rec.severety;
                final String header = hd = rec.getHeader(LogViewer.this.model.getLogname(rec.loggerID));
                final String substr = LogViewer.this.model.getFilter().getSubstring();
                final int iter = i;
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (LogViewer.this.noWindow) {
                            return;
                        }
                        LogPane logPane = LogViewer.this.thePane;
                        synchronized (logPane) {
                            if (iter <= ((LogViewer)LogViewer.this).thePane.fromRec) {
                                return;
                            }
                            ((LogViewer)LogViewer.this).thePane.page = EditorFiller.this.pagenum;
                            ((LogViewer)LogViewer.this).thePane.fromRec = iter;
                        }
                        try {
                            int ss;
                            int s;
                            String up;
                            int pos = LogViewer.this.doc.getEndPosition().getOffset() - 1;
                            if (LogViewer.this.thePane.getCaret() == null) {
                                LogViewer.this.thePane.setCaretPosition(0);
                            }
                            int oldPos = LogViewer.this.thePane.getCaretPosition();
                            LogViewer.this.doc.insertString(pos, header, LogViewer.this.getStyle(level));
                            LogViewer.this.doc.insertString(LogViewer.this.doc.getEndPosition().getOffset() - 1, "\n", LogViewer.this.getStyle(level));
                            if (!"".equals(substr)) {
                                up = header.toUpperCase();
                                s = 0;
                                while ((ss = up.indexOf(substr, s)) >= 0) {
                                    LogViewer.this.doc.setCharacterAttributes(pos + ss, substr.length(), LogViewer.this.selected, false);
                                    s += substr.length();
                                }
                            }
                            pos = LogViewer.this.doc.getEndPosition().getOffset() - 1;
                            LogViewer.this.doc.insertString(pos, msg, LogViewer.this.styleMsg);
                            LogViewer.this.doc.insertString(LogViewer.this.doc.getEndPosition().getOffset() - 1, "\n", LogViewer.this.getStyle(level));
                            if (!"".equals(substr)) {
                                up = msg.toUpperCase();
                                s = 0;
                                while ((ss = up.indexOf(substr, s)) >= 0) {
                                    LogViewer.this.doc.setCharacterAttributes(pos + ss, substr.length(), LogViewer.this.selected, false);
                                    s += substr.length();
                                }
                            }
                            LogViewer.this.thePane.setCaretPosition(oldPos);
                            if (LogViewer.this.noWindow) {
                                return;
                            }
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
    }
}

