/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.svgviz;

import java.util.Set;
import org.apache.batik.bridge.BridgeContext;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.output.DebugOutputType;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.SvgUtils;
import org.w3c.dom.Document;

public abstract class RuntimeCifSvgDecls {
    final int svgNr;
    protected Document document;
    protected BridgeContext bridgeContext;
    public boolean debug;
    public AppStream dbg;

    public abstract String getSvgRelPath();

    public abstract String getSvgAbsPath();

    public RuntimeCifSvgDecls(int svgNr) {
        this.svgNr = svgNr;
    }

    public void init(Document document, BridgeContext bridgeContext, CifSimulatorContext ctxt) {
        this.document = document;
        this.bridgeContext = bridgeContext;
        this.debug = ctxt.debug.contains((Object)DebugOutputType.SVG);
        this.dbg = ctxt.appEnvData.getStreams().out;
        this.applyCopies();
        this.applyMoves();
        this.initCaches();
    }

    protected void applyCopies() {
        boolean progress;
        int count = this.getCopyCount();
        if (count == 0) {
            return;
        }
        boolean[] applied = new boolean[count];
        do {
            progress = false;
            int i = 0;
            while (i < count) {
                boolean success;
                if (!applied[i] && (success = this.applyCopy(i))) {
                    applied[i] = true;
                    progress = true;
                }
                ++i;
            }
        } while (progress);
        Assert.check((!ArrayUtils.contains((boolean[])applied, (boolean)false) ? 1 : 0) != 0);
        if (this.debug) {
            this.dbg.println();
        }
    }

    protected abstract void applyMoves();

    protected abstract int getCopyCount();

    protected abstract boolean applyCopy(int var1);

    protected boolean applyCopy(String id, String pre, String post) {
        boolean bl;
        block4: {
            String preTxt;
            boolean doDebug = true;
            try {
                boolean copied = SvgUtils.copy((Document)this.document, (String)id, (String)pre, (String)post, (String)this.getSvgRelPath(), (boolean)false);
                if (!copied) {
                    doDebug = false;
                }
                bl = copied;
                if (!this.debug || !doDebug) break block4;
                preTxt = pre.isEmpty() ? "" : Strings.fmt((String)" pre \"%s\"", (Object[])new Object[]{pre});
            }
            catch (Throwable throwable) {
                if (this.debug && doDebug) {
                    String preTxt2 = pre.isEmpty() ? "" : Strings.fmt((String)" pre \"%s\"", (Object[])new Object[]{pre});
                    String postTxt = post.isEmpty() ? "" : Strings.fmt((String)" post \"%s\"", (Object[])new Object[]{post});
                    this.dbg.println(Strings.fmt((String)"SVG copy (\"%s\") id \"%s\"%s%s.", (Object[])new Object[]{this.getSvgRelPath(), id, preTxt2, postTxt}));
                }
                throw throwable;
            }
            String postTxt = post.isEmpty() ? "" : Strings.fmt((String)" post \"%s\"", (Object[])new Object[]{post});
            this.dbg.println(Strings.fmt((String)"SVG copy (\"%s\") id \"%s\"%s%s.", (Object[])new Object[]{this.getSvgRelPath(), id, preTxt, postTxt}));
        }
        return bl;
    }

    protected void applyMove(String id, double x, double y) {
        if (this.debug) {
            this.dbg.println(Strings.fmt((String)"SVG move (\"%s\") id \"%s\" to %s, %s.", (Object[])new Object[]{this.getSvgRelPath(), id, CifSimulatorMath.realToStr(x), CifSimulatorMath.realToStr(y)}));
        }
        SvgUtils.move((Document)this.document, (BridgeContext)this.bridgeContext, (String)id, (double)x, (double)y, (String)this.getSvgRelPath());
    }

    protected abstract void initCaches();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyOutput(RuntimeState state) {
        Document document = this.document;
        synchronized (document) {
            this.applyOutputInternal(state);
        }
    }

    protected abstract void applyOutputInternal(RuntimeState var1);

    public abstract Set<String> getInteractiveIds();

    public abstract boolean[] getInteractiveEvents();

    public abstract int applyInput(String var1, RuntimeState var2);
}

