/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.java.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.java.JavaDataValue;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;

public class JavaTupleTypeInfo
extends TupleTypeInfo {
    public JavaTupleTypeInfo(CifType cifType, TypeInfo[] fieldTIs) {
        super(cifType, fieldTIs);
    }

    @Override
    public String getTargetType() {
        return "CifTuple_" + this.getTypeName();
    }

    @Override
    public int getSize() {
        return this.childInfos.length;
    }

    @Override
    public void generateCode(CodeContext ctxt) {
        String className = this.getTargetType();
        String cifTypeText = CifTextUtils.typeToStr((CifType)this.cifType);
        MemoryCodeBox code = ctxt.makeCodeBox(1);
        code.add();
        code.add("/** Tuple class for CIF tuple type representative \"%s\". */", new Object[]{cifTypeText});
        code.add("public static class %s extends CifTupleBase<%s> {", new Object[]{className, className});
        code.indent();
        CharSequence[] names = new String[this.childInfos.length];
        CharSequence[] paramTxts = new String[this.childInfos.length];
        int i = 0;
        while (i < names.length) {
            names[i] = Strings.fmt((String)"_field%d", (Object[])new Object[]{i});
            paramTxts[i] = Strings.fmt((String)"%s %s", (Object[])new Object[]{this.childInfos[i].getTargetType(), names[i]});
            ++i;
        }
        i = 0;
        while (i < names.length) {
            code.add("/** The %s field. */", new Object[]{Numbers.toOrdinal((int)(i + 1))});
            code.add("public %s %s;", new Object[]{this.childInfos[i].getTargetType(), names[i]});
            code.add();
            ++i;
        }
        code.add("/**");
        code.add(" * Constructor for the {@link %s} class.", new Object[]{className});
        code.add(" *");
        i = 0;
        while (i < names.length) {
            code.add(" * @param %s The %s field.", new Object[]{names[i], Numbers.toOrdinal((int)(i + 1))});
            ++i;
        }
        code.add(" */");
        code.add("public %s(%s) {", new Object[]{className, String.join((CharSequence)", ", paramTxts)});
        code.indent();
        CharSequence[] charSequenceArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = charSequenceArray[n2];
            code.add("this.%s = %s;", new Object[]{name, name});
            ++n2;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("public %s copy() {", new Object[]{className});
        code.indent();
        code.add("return new %s(%s);", new Object[]{className, String.join((CharSequence)", ", names)});
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("public int hashCode() {");
        code.indent();
        code.add("return hashObjs(%s);", new Object[]{String.join((CharSequence)", ", names)});
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("public boolean equals(Object obj) {");
        code.indent();
        code.add("if (this == obj) return true;");
        code.add("%s other = (%s)obj;", new Object[]{className, className});
        i = 0;
        while (i < names.length) {
            code.add("%s equalObjs(this.%s, other.%s)%s", new Object[]{i == 0 ? "return" : "      ", names[i], names[i], i == names.length - 1 ? ";" : " &&"});
            ++i;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("@Override");
        code.add("public String toString() {");
        code.indent();
        code.add("StringBuilder rslt = new StringBuilder();");
        code.add("rslt.append(\"(\");");
        i = 0;
        while (i < names.length) {
            if (i > 0) {
                code.add("rslt.append(\", \");");
            }
            code.add("rslt.append(valueToStr(%s));", new Object[]{names[i]});
            ++i;
        }
        code.add("rslt.append(\")\");");
        code.add("return rslt.toString();");
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        String newTupleCode = code.toString();
        ctxt.appendReplacement("java-tuples-code", "\n" + newTupleCode);
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "equalObjs(${left-value}, ${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "!equalObjs(${left-value}, ${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public ExprCode getProjectedValue(ExprCode childCode, int index, Destination dest, CodeContext ctxt) {
        Assert.check((index >= 0 ? 1 : 0) != 0);
        ExprCode result = new ExprCode();
        result.add(childCode);
        String resultText = this.appendProjection(childCode.getData(), false, index);
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(resultText));
        return result;
    }

    @Override
    public String appendProjection(String value, boolean safe, int index) {
        Assert.check((index >= 0 ? 1 : 0) != 0);
        return safe ? Strings.fmt((String)"%s._field%d", (Object[])new Object[]{value, index}) : Strings.fmt((String)"(%s)._field%d", (Object[])new Object[]{value, index});
    }

    @Override
    public CodeBox modifyContainer(VariableInformation containerInfo, ExprCode partCode, int index, CodeContext ctxt) {
        MemoryCodeBox code = ctxt.makeCodeBox();
        code.add((Box)partCode.getCode());
        code.add("%s = %s;", new Object[]{this.appendProjection(containerInfo.targetRef, true, index), partCode.getData()});
        return code;
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        TupleType lhsTuple = (TupleType)lhsType;
        TupleType rhsTuple = (TupleType)rhsType;
        int last = errorTexts.size();
        errorTexts.add(null);
        int i = 0;
        while (i < this.childInfos.length) {
            errorTexts.set(last, new RangeCheckErrorLevelText(false, ((Field)lhsTuple.getFields().get(i)).getName()));
            this.childInfos[i].checkRange(((Field)lhsTuple.getFields().get(i)).getType(), ((Field)rhsTuple.getFields().get(i)).getType(), new JavaDataValue(this.appendProjection(rhsValue.getData(), false, i)), varType, varName, errorTexts, level, code, ctxt);
            ++i;
        }
        errorTexts.remove(last);
        Assert.check((last == errorTexts.size() ? 1 : 0) != 0);
    }

    @Override
    public ExprCode convertLiteral(TupleExpression expr, Destination dest, CodeContext ctxt) {
        String className = this.getTargetType();
        ExprCode result = new ExprCode();
        StringBuilder constructorCall = new StringBuilder();
        constructorCall.append("new ");
        constructorCall.append(className);
        constructorCall.append('(');
        boolean first = true;
        for (Expression arg : expr.getFields()) {
            if (!first) {
                constructorCall.append(", ");
            }
            first = false;
            ExprCode fieldValue = ctxt.exprToTarget(arg, null);
            result.add(fieldValue);
            constructorCall.append(fieldValue.getData());
        }
        constructorCall.append(')');
        result.setDestination(dest);
        result.setDataValue(new JavaDataValue(constructorCall.toString()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaTupleTypeInfo)) {
            return false;
        }
        JavaTupleTypeInfo otherTuple = (JavaTupleTypeInfo)other;
        if (this.childInfos.length != otherTuple.childInfos.length) {
            return false;
        }
        int i = 0;
        while (i < this.childInfos.length) {
            if (!this.childInfos[i].equals(otherTuple.childInfos[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = JavaTupleTypeInfo.class.hashCode() + this.childInfos.length;
        int i = 0;
        while (i < this.childInfos.length) {
            h += this.childInfos[i].hashCode();
            ++i;
        }
        return h;
    }
}

