/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.builders;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.CombinedEdges;
import org.eclipse.escet.cif.eventbased.builders.State;

public class StateEdges
implements Iterable<State> {
    public Event event;
    public State srcState;
    public CombinedEdges combinedEdges;

    public boolean edgePossible() {
        return this.combinedEdges.disabledIndex() < 0;
    }

    public int disabledIndex() {
        return this.combinedEdges.disabledIndex();
    }

    @Override
    public Iterator<State> iterator() {
        return new StateIterator();
    }

    private class StateIterator
    implements Iterator<State> {
        int[] indices;

        public StateIterator() {
            this.indices = new int[StateEdges.this.combinedEdges.sourceEdges.size()];
            int first = -1;
            int sizeFirst = 0;
            int i = 0;
            while (i < this.indices.length) {
                List<Edge> autEdge = StateEdges.this.combinedEdges.sourceEdges.get(i);
                if (autEdge != null) {
                    if (first == -1) {
                        first = i;
                        sizeFirst = autEdge.size();
                    }
                    if (autEdge.isEmpty()) {
                        this.indices[first] = sizeFirst;
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            int i = 0;
            while (i < this.indices.length) {
                List<Edge> autEdge = StateEdges.this.combinedEdges.sourceEdges.get(i);
                if (autEdge != null) {
                    return this.indices[i] < autEdge.size();
                }
                ++i;
            }
            return false;
        }

        @Override
        public State next() {
            Location[] locs = new Location[this.indices.length];
            int i = 0;
            while (i < this.indices.length) {
                List<Edge> autEdge = StateEdges.this.combinedEdges.sourceEdges.get(i);
                if (autEdge == null) {
                    locs[i] = StateEdges.this.srcState.locs[i];
                } else {
                    if (this.indices[i] == autEdge.size()) {
                        throw new NoSuchElementException();
                    }
                    locs[i] = autEdge.get((int)this.indices[i]).dstLoc;
                }
                ++i;
            }
            State s = new State(locs);
            int i2 = this.indices.length - 1;
            while (i2 >= 0) {
                List<Edge> autEdge = StateEdges.this.combinedEdges.sourceEdges.get(i2);
                if (autEdge == null) {
                    --i2;
                    continue;
                }
                int n = i2;
                this.indices[n] = this.indices[n] + 1;
                if (this.indices[i2] == autEdge.size()) {
                    --i2;
                    continue;
                }
                ++i2;
                while (i2 < this.indices.length) {
                    this.indices[i2] = 0;
                    ++i2;
                }
                break block1;
            }
            return s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

