/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CompNoInitPredsCheck
extends CifCheck {
    private final boolean ignoreTriviallyTrueInitPreds;

    public CompNoInitPredsCheck() {
        this(false);
    }

    public CompNoInitPredsCheck(boolean ignoreTriviallyTrueInitPreds) {
        this.ignoreTriviallyTrueInitPreds = ignoreTriviallyTrueInitPreds;
    }

    protected void preprocessComplexComponent(ComplexComponent comp, CifCheckViolations violations) {
        for (Expression initial : comp.getInitials()) {
            if (this.ignoreTriviallyTrueInitPreds && CifValueUtils.isTriviallyTrue((Expression)initial, (boolean)true, (boolean)true)) continue;
            violations.add((PositionObject)initial, "Component has an initialization predicate", new Object[0]);
        }
    }
}

