/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTuple;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.explorer.options.AddStateAnnosOption;
import org.eclipse.escet.cif.explorer.options.AutomatonNameOption;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.EventUsage;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.ExplorerTransition;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifAutomatonBuilder {
    private Map<Event, Event> evtMap = null;

    public Specification createAutomaton(Explorer expl, Specification oldSpec) {
        this.evtMap = Maps.map();
        Specification newSpec = CifConstructors.newSpecification();
        newSpec.setName("specification");
        this.makeEventGroups((Group)oldSpec, (Group)newSpec);
        this.addAutomaton(expl, newSpec);
        this.evtMap = null;
        return newSpec;
    }

    private boolean makeEventGroups(Group oldGrp, Group newGrp) {
        boolean nonEmpty = false;
        for (Component comp : oldGrp.getComponents()) {
            Group subGrp;
            if (comp instanceof Group) {
                Group oldComp = (Group)comp;
                subGrp = CifConstructors.newGroup();
                subGrp.setName(oldComp.getName());
                if (this.makeEventGroups(oldComp, subGrp)) {
                    newGrp.getComponents().add((Object)subGrp);
                    nonEmpty = true;
                }
            }
            if (!(comp instanceof Automaton)) continue;
            Automaton oldAut = (Automaton)comp;
            subGrp = CifConstructors.newGroup();
            subGrp.setName(oldAut.getName());
            if (!this.addEvents(subGrp, (List<Declaration>)oldAut.getDeclarations())) continue;
            newGrp.getComponents().add((Object)subGrp);
            nonEmpty = true;
        }
        return nonEmpty |= this.addEvents(newGrp, (List<Declaration>)oldGrp.getDeclarations());
    }

    private boolean addEvents(Group grp, List<Declaration> decls) {
        boolean nonEmpty = false;
        for (Declaration decl : decls) {
            if (!(decl instanceof Event)) continue;
            Event oldEvent = (Event)decl;
            Boolean ctl = oldEvent.getControllable();
            Event newEvent = CifConstructors.newEvent(null, (Boolean)ctl, (String)oldEvent.getName(), null, null);
            grp.getDeclarations().add((Object)newEvent);
            this.evtMap.put(oldEvent, newEvent);
            nonEmpty = true;
        }
        return nonEmpty;
    }

    private static Automaton createResultAutomaton(String sugName, Specification spec) {
        Automaton aut = CifConstructors.newAutomaton();
        String name = sugName;
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        if (names.contains(name)) {
            name = CifScopeUtils.getUniqueName((String)name, (Set)names, Collections.emptySet());
            OutputProvider.warn((String)"Resulting statespace automaton is named \"%s\" instead of \"%s\" to avoid a naming conflict.", (Object[])new Object[]{name, sugName});
        }
        aut.setName(name);
        spec.getComponents().add((Object)aut);
        return aut;
    }

    private void addAutomaton(Explorer expl, Specification newSpec) {
        String name = AutomatonNameOption.getAutomatonName("statespace");
        Automaton aut = CifAutomatonBuilder.createResultAutomaton(name, newSpec);
        Alphabet alphabet = CifConstructors.newAlphabet();
        aut.setAlphabet(alphabet);
        for (EventUsage evtUse : expl.eventUsages) {
            Event evt = this.evtMap.get(evtUse.event);
            EventExpression ee = CifConstructors.newEventExpression((Event)evt, null, (CifType)CifConstructors.newBoolType());
            alphabet.getEvents().add((Object)ee);
        }
        if (expl.states == null || expl.states.isEmpty()) {
            Location loc = CifConstructors.newLocation();
            aut.getLocations().add((Object)loc);
            return;
        }
        boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
        int idx = 0;
        for (BaseState state : expl.states.values()) {
            Assert.check((state.stateNumber == idx + 1 ? 1 : 0) != 0);
            Location loc = CifConstructors.newLocation();
            loc.setName(Strings.fmt((String)"loc%d", (Object[])new Object[]{idx + 1}));
            if (state.isInitial()) {
                loc.getInitials().add((Object)CifValueUtils.makeTrue());
            }
            if (state.isMarked()) {
                loc.getMarkeds().add((Object)CifValueUtils.makeTrue());
            }
            aut.getLocations().add((Object)loc);
            ++idx;
            if (!doAddStateAnnos) continue;
            CifAutomatonBuilder.addStateAnno(expl, loc, state);
        }
        idx = 0;
        for (BaseState state : expl.states.values()) {
            Location srcLoc = (Location)aut.getLocations().get(idx++);
            for (ExplorerTransition transition : state.getOutgoingTransitions()) {
                Location dstLoc = (Location)aut.getLocations().get(transition.next.stateNumber - 1);
                Edge edge = CifConstructors.newEdge();
                if (srcLoc != dstLoc) {
                    edge.setTarget(dstLoc);
                }
                srcLoc.getEdges().add((Object)edge);
                if (transition.event == null) continue;
                Event newEvent = this.evtMap.get(transition.event);
                EventExpression e = CifConstructors.newEventExpression((Event)newEvent, null, (CifType)CifConstructors.newBoolType());
                EdgeEvent ee = CifConstructors.newEdgeEvent();
                ee.setEvent((Expression)e);
                edge.getEvents().add((Object)ee);
            }
        }
    }

    private static void addStateAnno(Explorer explorer, Location loc, BaseState state) {
        Annotation anno = CifConstructors.newAnnotation();
        anno.setName("state");
        loc.getAnnotations().add((Object)anno);
        List args = Lists.listc((int)(explorer.automata.length + explorer.variables.length));
        int i = 0;
        while (i < explorer.automata.length) {
            args.add(CifAutomatonBuilder.createStateAnnoArg((PositionObject)explorer.automata[i], state.locations[i]));
            ++i;
        }
        i = 0;
        while (i < explorer.variables.length) {
            args.add(CifAutomatonBuilder.createStateAnnoArg(explorer.variables[i], state.values[i]));
            ++i;
        }
        Collections.sort(args, (a1, a2) -> Strings.SORTER.compare(a1.getName(), a2.getName()));
        anno.getArguments().addAll((Collection)args);
    }

    private static AnnotationArgument createStateAnnoArg(PositionObject object, Object value) {
        AnnotationArgument arg = CifConstructors.newAnnotationArgument();
        arg.setName(CifTextUtils.getAbsName((PositionObject)object, (boolean)false));
        if (object instanceof Automaton) {
            Location loc = (Location)value;
            arg.setValue((Expression)CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)(loc.getName() == null ? "*" : loc.getName())));
        } else {
            CifType varType = CifAutomatonBuilder.getVarType(object);
            arg.setValue(CifAutomatonBuilder.valueToExpr(value, varType));
        }
        return arg;
    }

    private static CifType getVarType(PositionObject var) {
        if (var instanceof ContVariable) {
            return CifConstructors.newRealType();
        }
        if (var instanceof DiscVariable) {
            DiscVariable dvar = (DiscVariable)var;
            return dvar.getType();
        }
        throw new AssertionError((Object)("Unexpected variable: " + String.valueOf(var)));
    }

    private static List<Expression> valuesToExpr(Collection<?> values, CifType type) {
        return values.stream().map(v -> CifAutomatonBuilder.valueToExpr(v, type)).toList();
    }

    private static Expression valueToExpr(Object value, CifType type) {
        if (value instanceof Boolean) {
            Boolean bvalue = (Boolean)value;
            return CifConstructors.newBoolExpression(null, (CifType)CifConstructors.newBoolType(), (Boolean)bvalue);
        }
        if (value instanceof Integer) {
            Integer ivalue = (Integer)value;
            return CifValueUtils.makeInt((int)ivalue);
        }
        if (value instanceof Double) {
            Double dvalue = (Double)value;
            return CifValueUtils.makeReal((double)dvalue);
        }
        if (value instanceof String) {
            String svalue = (String)value;
            return CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)svalue);
        }
        if (value instanceof CifEnumLiteral) {
            CifEnumLiteral lvalue = (CifEnumLiteral)value;
            return CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)lvalue.literal.getName());
        }
        if (value instanceof CifTuple) {
            CifTuple tvalue = (CifTuple)value;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof TupleType));
            List<String> fieldNames = ((TupleType)type).getFields().stream().map(f -> f.getName()).toList();
            List<CifType> fieldTypes = ((TupleType)type).getFields().stream().map(f -> f.getType()).toList();
            List fields = Lists.listc((int)tvalue.size());
            TupleType newTupleType = CifConstructors.newTupleType();
            int i = 0;
            while (i < tvalue.size()) {
                Expression field = CifAutomatonBuilder.valueToExpr(tvalue.get(i), fieldTypes.get(i));
                fields.add(field);
                newTupleType.getFields().add((Object)CifConstructors.newField((String)fieldNames.get(i), null, (CifType)((CifType)EMFHelper.deepclone((EObject)field.getType()))));
                ++i;
            }
            return CifConstructors.newTupleExpression((List)fields, null, (CifType)newTupleType);
        }
        if (value instanceof List) {
            List lvalue = (List)value;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof ListType));
            CifType elemType = ((ListType)type).getElementType();
            List<Expression> elems = CifAutomatonBuilder.valuesToExpr(lvalue, elemType);
            CifType newElemType = elems.stream().map(Expression::getType).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(elemType);
            ListType newListType = CifConstructors.newListType((CifType)CifAutomatonBuilder.makeAnnoArgType(newElemType), (Integer)lvalue.size(), null, (Integer)lvalue.size());
            return CifConstructors.newListExpression(elems, null, (CifType)newListType);
        }
        if (value instanceof Set) {
            Set svalue = (Set)value;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof SetType));
            CifType elemType = ((SetType)type).getElementType();
            List<Expression> elems = CifAutomatonBuilder.valuesToExpr(svalue, elemType);
            CifType newElemType = elems.stream().map(Expression::getType).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(elemType);
            SetType newSetType = CifConstructors.newSetType((CifType)CifAutomatonBuilder.makeAnnoArgType(newElemType), null);
            return CifConstructors.newSetExpression(elems, null, (CifType)newSetType);
        }
        if (value instanceof Map) {
            Map mvalue = (Map)value;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof DictType));
            CifType keyType = ((DictType)type).getKeyType();
            CifType valueType = ((DictType)type).getValueType();
            List<DictPair> pairs = mvalue.entrySet().stream().map(e -> CifConstructors.newDictPair((Expression)CifAutomatonBuilder.valueToExpr(e.getKey(), keyType), null, (Expression)CifAutomatonBuilder.valueToExpr(e.getValue(), valueType))).toList();
            CifType newKeyType = pairs.stream().map(p -> p.getKey().getType()).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(keyType);
            CifType newValueType = pairs.stream().map(p -> p.getValue().getType()).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(valueType);
            DictType newDictType = CifConstructors.newDictType((CifType)CifAutomatonBuilder.makeAnnoArgType(newKeyType), null, (CifType)CifAutomatonBuilder.makeAnnoArgType(newValueType));
            return CifConstructors.newDictExpression(pairs, null, (CifType)newDictType);
        }
        if (value instanceof Function) {
            Function fvalue = (Function)value;
            return CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)CifTextUtils.getAbsName((PositionObject)fvalue, (boolean)false));
        }
        throw new AssertionError((Object)("Unexpected value: " + String.valueOf(value)));
    }

    private static CifType makeAnnoArgType(CifType type) {
        if ((type = CifTypeUtils.normalizeType((CifType)type)) instanceof BoolType) {
            return CifConstructors.newBoolType();
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            return CifConstructors.newIntType((Integer)itype.getLower(), null, (Integer)itype.getUpper());
        }
        if (type instanceof RealType) {
            return CifConstructors.newRealType();
        }
        if (type instanceof StringType) {
            return CifConstructors.newStringType();
        }
        if (type instanceof EnumType) {
            return CifConstructors.newStringType();
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            List<Field> fields = ttype.getFields().stream().map(f -> CifConstructors.newField((String)f.getName(), null, (CifType)CifAutomatonBuilder.makeAnnoArgType(f.getType()))).toList();
            return CifConstructors.newTupleType(fields, null);
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            return CifConstructors.newListType((CifType)CifAutomatonBuilder.makeAnnoArgType(ltype.getElementType()), (Integer)ltype.getLower(), null, (Integer)ltype.getUpper());
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            return CifConstructors.newSetType((CifType)CifAutomatonBuilder.makeAnnoArgType(stype.getElementType()), null);
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return CifConstructors.newDictType((CifType)CifAutomatonBuilder.makeAnnoArgType(dtype.getKeyType()), null, (CifType)CifAutomatonBuilder.makeAnnoArgType(dtype.getValueType()));
        }
        if (type instanceof FuncType) {
            return CifConstructors.newStringType();
        }
        throw new AssertionError((Object)("Unexpected type: " + String.valueOf(type)));
    }
}

