/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.operations;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.util.StateflowUtil;
import org.eclipse.epsilon.emc.simulink.util.collection.StateflowBlockCollection;
import org.eclipse.epsilon.emc.simulink.util.manager.StateflowBlockManager;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.BooleanLiteral;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.ExpressionInBrackets;
import org.eclipse.epsilon.eol.dom.IntegerLiteral;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NotEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.OperationCallExpression;
import org.eclipse.epsilon.eol.dom.OrOperatorExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.RealLiteral;
import org.eclipse.epsilon.eol.dom.StringLiteral;
import org.eclipse.epsilon.eol.dom.XorOperatorExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;

public class StateflowSelectOperation
extends SelectOperation {
    protected MatlabEngine engine;

    public StateflowSelectOperation(MatlabEngine engine) {
        this.engine = engine;
    }

    public Collection<?> execute(boolean returnOnMatch, Object target, NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context) throws EolRuntimeException {
        if (target instanceof StateflowBlockCollection) {
            try {
                String exp = this.expression(expression);
                StateflowBlockCollection targetList = (StateflowBlockCollection)((Object)target);
                List handles = targetList.getPrimitive();
                String cellArray = handles.stream().map(e -> String.valueOf(((Double)e).intValue())).collect(Collectors.joining(";", "{", "}"));
                SimulinkModel model = ((StateflowBlockManager)targetList.getManager()).getModel();
                try {
                    StateflowUtil.modelHandleAsM(model);
                    String setup = "handles=cell2mat(arrayfun(@(a) m.find('Id',a),cell2mat(?), 'UniformOutput', false));";
                    this.engine.eval(setup, new Object[]{cellArray});
                    String cmd = String.format("get(handles.find(%s'-depth',0),'Id');", exp);
                    Object result = this.engine.evalWithResult(cmd);
                    if (result instanceof Collection) {
                        result = this.engine.evalWithResult("cell2mat(result);");
                    }
                    return new StateflowBlockCollection(result, model);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        return super.execute(returnOnMatch, target, operationNameExpression, iterators, expression, context);
    }

    protected String expression(Expression exp) throws Exception {
        block27: {
            if (exp instanceof AndOperatorExpression) {
                return String.valueOf(this.expression(((AndOperatorExpression)exp).getFirstOperand())) + "'-and'," + this.expression(((AndOperatorExpression)exp).getSecondOperand());
            }
            if (exp instanceof OrOperatorExpression) {
                return String.valueOf(this.expression(((OrOperatorExpression)exp).getFirstOperand())) + "'-or'," + this.expression(((OrOperatorExpression)exp).getSecondOperand());
            }
            if (exp instanceof XorOperatorExpression) {
                return String.valueOf(this.expression(((XorOperatorExpression)exp).getFirstOperand())) + "'-xor'," + this.expression(((XorOperatorExpression)exp).getSecondOperand());
            }
            if (exp instanceof ExpressionInBrackets) {
                return this.expression(((ExpressionInBrackets)exp).getExpression());
            }
            if (exp instanceof EqualsOperatorExpression) {
                Expression firstOperand = ((EqualsOperatorExpression)exp).getFirstOperand();
                Expression secondOperand = ((EqualsOperatorExpression)exp).getSecondOperand();
                return this.propertyEqualsOperation(firstOperand, secondOperand);
            }
            if (exp instanceof NotEqualsOperatorExpression) {
                Expression firstOperand = ((NotEqualsOperatorExpression)exp).getFirstOperand();
                Expression secondOperand = ((NotEqualsOperatorExpression)exp).getSecondOperand();
                return "'-not'," + this.propertyEqualsOperation(firstOperand, secondOperand);
            }
            if (exp instanceof NotOperatorExpression) {
                Expression operand = ((NotOperatorExpression)exp).getFirstOperand();
                if (operand instanceof ExpressionInBrackets) {
                    Expression brakets = ((ExpressionInBrackets)operand).getExpression();
                    if (brakets instanceof EqualsOperatorExpression) {
                        return this.expression(operand);
                    }
                } else {
                    if (operand instanceof EqualsOperatorExpression) {
                        return "'-not'," + this.expression(operand);
                    }
                    if (operand instanceof NotEqualsOperatorExpression) {
                        return this.expression(operand);
                    }
                }
                throw new Exception("Unsupported type");
            }
            if (!(exp instanceof OperationCallExpression)) break block27;
            String prepend = "";
            String append = "";
            switch (((OperationCallExpression)exp).getName()) {
                case "startsWith": {
                    prepend = "^";
                    break;
                }
                case "endsWith": {
                    append = "$";
                    break;
                }
                default: {
                    throw new Exception("(Unsupported operation)");
                }
                case "matches": 
            }
            Expression target = ((OperationCallExpression)exp).getTargetExpression();
            List parameterExpressions = ((OperationCallExpression)exp).getParameterExpressions();
            if (!(target instanceof PropertyCallExpression)) {
                throw new Exception("Unsupported format");
            }
            String property = ((PropertyCallExpression)target).getNameExpression().getName();
            if (parameterExpressions.size() != 1) {
                throw new Exception("Unsupported format");
            }
            String value = this.processValue((Expression)parameterExpressions.get(0), prepend, append);
            return String.format("'-regexp','%s',%s,", property, value);
        }
        throw new Exception("Unsupported selection format");
    }

    private String propertyEqualsOperation(Expression firstOperand, Expression secondOperand) throws Exception {
        String value;
        String property;
        if (firstOperand instanceof PropertyCallExpression) {
            property = ((PropertyCallExpression)firstOperand).getNameExpression().getName();
            value = this.processValue(secondOperand);
        } else if (secondOperand instanceof PropertyCallExpression) {
            property = ((PropertyCallExpression)firstOperand).getNameExpression().getName();
            value = this.processValue(firstOperand);
        } else {
            throw new Exception("Unsupported format");
        }
        return String.format("'%s',%s,", property, value);
    }

    protected String processValue(Expression operand) throws Exception {
        return this.processValue(operand, "", "");
    }

    protected String processValue(Expression operand, String prepend, String append) throws Exception {
        String value;
        if (operand instanceof StringLiteral) {
            value = String.format("'%s%s%s'", prepend, ((StringLiteral)operand).getValue(), append);
        } else if (operand instanceof IntegerLiteral) {
            value = String.format("%d", ((IntegerLiteral)operand).getValue());
        } else if (operand instanceof RealLiteral) {
            value = String.format("%f", ((RealLiteral)operand).getValue());
        } else if (operand instanceof BooleanLiteral) {
            value = String.format("%d", (Boolean)((BooleanLiteral)operand).getValue() != false ? 1 : 0);
        } else {
            throw new Exception("Unsupported type");
        }
        return value;
    }

    protected String expression(Expression exp1, Expression exp2) throws Exception {
        return String.valueOf(this.expression(exp1)) + this.expression(exp2);
    }
}

