/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.filters;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.embedcdt.core.liqp.LValue;
import org.eclipse.embedcdt.core.liqp.TemplateContext;
import org.eclipse.embedcdt.core.liqp.filters.Append;
import org.eclipse.embedcdt.core.liqp.filters.Capitalize;
import org.eclipse.embedcdt.core.liqp.filters.Date;
import org.eclipse.embedcdt.core.liqp.filters.Divided_By;
import org.eclipse.embedcdt.core.liqp.filters.Downcase;
import org.eclipse.embedcdt.core.liqp.filters.Escape;
import org.eclipse.embedcdt.core.liqp.filters.Escape_Once;
import org.eclipse.embedcdt.core.liqp.filters.First;
import org.eclipse.embedcdt.core.liqp.filters.H;
import org.eclipse.embedcdt.core.liqp.filters.Join;
import org.eclipse.embedcdt.core.liqp.filters.Last;
import org.eclipse.embedcdt.core.liqp.filters.Map;
import org.eclipse.embedcdt.core.liqp.filters.Minus;
import org.eclipse.embedcdt.core.liqp.filters.Modulo;
import org.eclipse.embedcdt.core.liqp.filters.Newline_To_Br;
import org.eclipse.embedcdt.core.liqp.filters.Plus;
import org.eclipse.embedcdt.core.liqp.filters.Prepend;
import org.eclipse.embedcdt.core.liqp.filters.Remove;
import org.eclipse.embedcdt.core.liqp.filters.Remove_First;
import org.eclipse.embedcdt.core.liqp.filters.Replace;
import org.eclipse.embedcdt.core.liqp.filters.Replace_First;
import org.eclipse.embedcdt.core.liqp.filters.Size;
import org.eclipse.embedcdt.core.liqp.filters.Sort;
import org.eclipse.embedcdt.core.liqp.filters.Split;
import org.eclipse.embedcdt.core.liqp.filters.Strip_HTML;
import org.eclipse.embedcdt.core.liqp.filters.Strip_Newlines;
import org.eclipse.embedcdt.core.liqp.filters.Times;
import org.eclipse.embedcdt.core.liqp.filters.Truncate;
import org.eclipse.embedcdt.core.liqp.filters.Truncatewords;
import org.eclipse.embedcdt.core.liqp.filters.Upcase;

public abstract class Filter
extends LValue {
    private static final java.util.Map<String, Filter> FILTERS = new HashMap<String, Filter>();
    public final String name;

    static {
        Filter.registerFilter(new Append());
        Filter.registerFilter(new Capitalize());
        Filter.registerFilter(new Date());
        Filter.registerFilter(new Divided_By());
        Filter.registerFilter(new Downcase());
        Filter.registerFilter(new Escape());
        Filter.registerFilter(new Escape_Once());
        Filter.registerFilter(new First());
        Filter.registerFilter(new H());
        Filter.registerFilter(new Join());
        Filter.registerFilter(new Last());
        Filter.registerFilter(new Map());
        Filter.registerFilter(new Minus());
        Filter.registerFilter(new Modulo());
        Filter.registerFilter(new Newline_To_Br());
        Filter.registerFilter(new Plus());
        Filter.registerFilter(new Prepend());
        Filter.registerFilter(new Remove());
        Filter.registerFilter(new Remove_First());
        Filter.registerFilter(new Replace());
        Filter.registerFilter(new Replace_First());
        Filter.registerFilter(new Size());
        Filter.registerFilter(new Sort());
        Filter.registerFilter(new Split());
        Filter.registerFilter(new Strip_HTML());
        Filter.registerFilter(new Strip_Newlines());
        Filter.registerFilter(new Times());
        Filter.registerFilter(new Truncate());
        Filter.registerFilter(new Truncatewords());
        Filter.registerFilter(new Upcase());
    }

    protected Filter() {
        this.name = this.getClass().getSimpleName().toLowerCase();
    }

    public Filter(String name) {
        this.name = name;
    }

    public Object apply(Object value, Object ... params) {
        return value;
    }

    public Object apply(Object value, TemplateContext context, Object ... params) {
        return this.apply(value, params);
    }

    public final void checkParams(Object[] params, int expected) {
        if (params == null || params.length != expected) {
            throw new RuntimeException("Liquid error: wrong number of arguments (" + (params.length + 1) + " for " + (expected + 1) + ")");
        }
    }

    protected Object get(int index, Object ... params) {
        if (index >= params.length) {
            throw new RuntimeException("error in filter '" + this.name + "': cannot get param index: " + index + " from: " + Arrays.toString(params));
        }
        return params[index];
    }

    public static Filter getFilter(String name) {
        Filter filter = FILTERS.get(name);
        if (filter == null) {
            throw new RuntimeException("unknown filter: " + name);
        }
        return filter;
    }

    public static java.util.Map<String, Filter> getFilters() {
        return new HashMap<String, Filter>(FILTERS);
    }

    public static void registerFilter(Filter filter) {
        FILTERS.put(filter.name, filter);
    }
}

