/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.ui.doubleclicking;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.css.cssDsl.CssDslPackage;
import org.eclipse.fx.ide.css.cssDsl.URLType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.doubleClicking.LexerTokenAndCharacterPairAwareStrategy;
import org.eclipse.xtext.ui.editor.model.PartitionTokenScanner;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CssGrammarAwareStrategy
extends LexerTokenAndCharacterPairAwareStrategy {
    @Inject
    PartitionTokenScanner scanner;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    protected Pair<EObject, IRegion> getXtextElementAt(XtextResource resource, int offset) {
        EObject crossLinkedEObject = this.eObjectAtOffsetHelper.resolveCrossReferencedElementAt(resource, offset);
        if (crossLinkedEObject != null) {
            IParseResult parseResult;
            if (!crossLinkedEObject.eIsProxy() && (parseResult = resource.getParseResult()) != null) {
                ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset);
                if (leafNode != null && leafNode.isHidden() && leafNode.getOffset() == offset) {
                    leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)(offset - 1));
                }
                if (leafNode != null) {
                    return Tuples.create((Object)crossLinkedEObject, (Object)new Region(leafNode.getOffset(), leafNode.getLength()));
                }
            }
        } else {
            ITextRegion region;
            Region region2;
            URLType urlType;
            EObject o = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
            if (o instanceof URLType && (urlType = (URLType)o).getUrl() != null) {
                ITextRegion r1 = this.locationInFileProvider.getFullTextRegion(o, (EStructuralFeature)CssDslPackage.Literals.URL_TYPE__URL, 0);
                int mod = 0;
                if (urlType.getUrl().startsWith("\"") || urlType.getUrl().startsWith("'")) {
                    mod = 1;
                }
                Region r = new Region(r1.getOffset() + mod, r1.getLength() - 2 * mod);
                return Tuples.create((Object)o, (Object)r);
            }
            if (o != null && TextUtilities.overlaps((IRegion)(region2 = new Region((region = this.locationInFileProvider.getSignificantTextRegion(o)).getOffset(), region.getLength())), (IRegion)new Region(offset, 0))) {
                return Tuples.create((Object)o, (Object)region2);
            }
        }
        return null;
    }

    protected IRegion findWord(IDocument document, final int offset) {
        XtextDocument xdoc = (XtextDocument)document;
        IRegion result = (IRegion)xdoc.readOnly((IUnitOfWork)new IUnitOfWork<IRegion, XtextResource>(){

            public IRegion exec(XtextResource state) throws Exception {
                if (state == null) {
                    return null;
                }
                Pair<EObject, IRegion> element = CssGrammarAwareStrategy.this.getXtextElementAt(state, offset);
                if (element != null) {
                    return (IRegion)element.getSecond();
                }
                return null;
            }
        });
        return result;
    }
}

