/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.datasource.singleton;

import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.ComponentBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.DataSourceIF;
import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.DataSourceTest;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.annotation.sql.DataSourceDefinitions;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.UserTransaction;
import javax.sql.DataSource;

@Singleton
@TransactionManagement(value=TransactionManagementType.BEAN)
@Local(value={DataSourceIF.class})
@DataSourceDefinitions(value={@DataSourceDefinition(name="defaultds", className="org.apache.derby.jdbc.ClientDataSource", portNumber=1527, serverName="localhost", databaseName="derbyDB", user="cts1", transactional=false, password="cts1", properties={}), @DataSourceDefinition(name="defaultds2", className="org.apache.derby.jdbc.ClientDataSource", portNumber=1527, serverName="localhost", databaseName="derbyDB", user="cts1", transactional=false, password="cts1", properties={})})
public class DataSourceBean
extends ComponentBase {
    @Resource(lookup="java:comp/env/compds")
    private DataSource compds;
    @Resource(lookup="java:comp/env/compds2")
    private DataSource compds2;
    @Resource(lookup="java:comp/env/defaultds")
    private DataSource defaultds;
    @Resource(lookup="java:comp/env/defaultds2")
    private DataSource defaultds2;
    @Resource
    private UserTransaction ut;

    @PostConstruct
    private void postConstruct() {
        boolean c = true;
        this.getPostConstructRecords().append(String.format("In postConstruct of %s%n", this));
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, "java:comp/env/defaultds", "java:comp/env/defaultds2", "java:comp/env/compds", "java:comp/env/compds2");
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, this.defaultds, this.defaultds2, this.compds, this.compds2);
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, this.defaultds, this.defaultds2);
    }

    @Override
    public StringBuilder getConnection() {
        int j = 2;
        StringBuilder sb = new StringBuilder();
        try {
            this.ut.begin();
            for (int i = 0; i < j; ++i) {
                DataSourceTest.verifyDataSource(this.getPostConstructRecords(), true, this.defaultds);
                DataSourceTest.verifyDataSource(this.getPostConstructRecords(), true, this.defaultds2);
            }
            this.ut.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb;
    }
}

