/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaDelete;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends Util {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createProductData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new Fault("setup failed:", (Throwable)e);
        }
    }

    public void fromClassTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            this.logTrace("Obtained Non-null root");
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                this.logTrace("Received expected number deleted:" + actual);
                this.clearCache();
                this.logMsg("Make sure items were deleted by looking up the Products id");
                for (Product p : this.productRef) {
                    pass1 = true;
                    if (this.getEntityManager().find(Product.class, (Object)p.getId()) == null) continue;
                    this.logErr("Expected product:" + p.getId() + " to have been deleted");
                    pass2 = false;
                }
            } else {
                this.logErr("Expected:" + this.productRef.length + ", actual:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("fromClassTest failed");
        }
    }

    public void fromEntityTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Metamodel mm = this.getEntityManager().getMetamodel();
        EntityType Product_ = mm.entity(Product.class);
        Root root = cd.from(Product_);
        if (root != null) {
            this.logTrace("Obtained Non-null root");
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == this.productRef.length + this.softwareRef.length + this.hardwareRef.length) {
                this.logTrace("Received expected number deleted:" + actual);
                this.clearCache();
                this.logMsg("Make sure items were deleted by looking up the Products id");
                for (Product p : this.productRef) {
                    pass1 = true;
                    if (this.getEntityManager().find(Product.class, (Object)p.getId()) == null) continue;
                    this.logErr("Expected product:" + p.getId() + " to have been deleted");
                    pass2 = false;
                }
            } else {
                this.logErr("Expected:" + this.productRef.length + ", actual:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("fromEntityTypeTest failed");
        }
    }

    public void getRootTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            this.logTrace("Obtained Non-null root");
            if (root.getModel().getName().equals(cd.getRoot().getModel().getName())) {
                this.logTrace("Obtained expected root");
                pass = true;
            } else {
                this.logErr("Failed to get expected root");
                this.logErr("Expected:" + String.valueOf(cd.getRoot()) + ", actual:" + String.valueOf(root));
            }
        } else {
            this.logErr("Failed to get Non-null root");
        }
        if (!pass) {
            throw new Exception("getRootTest failed");
        }
    }

    public void whereExpressionTest() throws Exception {
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = true;
        boolean pass5 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            this.logTrace("Obtained Non-null root");
            Path exp = root.get("id");
            ArrayList<String> col = new ArrayList<String>();
            col.add("1");
            col.add("2");
            col.add("3");
            cd.where((Expression)exp.in(col));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == col.size()) {
                Product pp;
                this.logTrace("Received expected number deleted:" + actual);
                this.clearCache();
                pass2 = true;
                for (Product product : this.productRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (product.getId().equals("1") || product.getId().equals("2") || product.getId().equals("3")) {
                        if (pp != null) {
                            this.logErr("Expected product:" + product.getId() + " to have been deleted");
                            pass3 = false;
                            continue;
                        }
                        this.logTrace("Product:" + product.getId() + " was successfully deleted");
                        continue;
                    }
                    if (pp == null) {
                        this.logErr("Product:" + product.getId() + " was incorrectly deleted");
                        pass3 = false;
                        continue;
                    }
                    this.logTrace("Found Product:" + pp.getId());
                }
                for (Product product : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp == null) {
                        this.logErr("Software Product:" + product.getId() + " was incorrectly deleted");
                        pass4 = false;
                        continue;
                    }
                    this.logTrace("Found Software Product:" + pp.getId());
                }
                for (Product product : this.hardwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                    if (pp == null) {
                        this.logErr("Harware Product:" + product.getId() + " was incorrectly deleted");
                        pass5 = false;
                        continue;
                    }
                    this.logTrace("Found Harware Product:" + pp.getId());
                }
            } else {
                this.logErr("Expected:" + col.size() + ", actual:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("whereExpressionTest failed");
        }
    }

    public void wherePredicateArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = true;
        boolean pass4 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        Root root = cd.from(Product.class);
        if (root != null) {
            Product pp;
            this.logTrace("Obtained Non-null root");
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)root.get("id"), (Object)"2")};
            cd.where(predArray);
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == predArray.length) {
                this.logTrace("Received expected number deleted:" + actual);
                pass1 = true;
            } else {
                this.logErr("Expected deleted:" + predArray.length + ", actual:" + actual);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            for (Product product : this.productRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (product.getId().equals("2")) {
                    if (pp != null) {
                        this.logErr("Expected product:" + product.getId() + " to have been deleted");
                        pass2 = false;
                        continue;
                    }
                    this.logTrace("Product:" + product.getId() + " was successfully deleted");
                    continue;
                }
                if (pp == null) {
                    this.logErr("Product:" + product.getId() + " was incorrectly deleted");
                    pass2 = false;
                    continue;
                }
                this.logTrace("Found Product:" + pp.getId());
            }
            for (Product product : this.softwareRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (pp != null) continue;
                this.logErr("Software product:" + product.getId() + " should not have been deleted");
                pass3 = false;
            }
            for (Product product : this.hardwareRef) {
                pp = (Product)this.getEntityManager().find(Product.class, (Object)product.getId());
                if (pp != null) continue;
                this.logErr("Hardware product:" + product.getId() + " should not have been deleted");
                pass4 = false;
            }
        } else {
            this.logErr("Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("wherePredicateArrayTest failed");
        }
    }

    public void subquery() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(19);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cd = cbuilder.createCriteriaDelete(Product.class);
        if (cd != null) {
            this.logTrace("Obtained Non-null Criteria Query");
            Root product = cd.from(Product.class);
            EntityType Product_ = product.getModel();
            Subquery sq = cd.subquery(Product.class);
            Root hardProd = sq.from(Product.class);
            sq.where((Expression)cbuilder.equal((Expression)product.get(Product_.getSingularAttribute("id", String.class)), (Object)"1")).select((Expression)hardProd);
            cd.where((Expression)cbuilder.exists(sq));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 1) {
                this.logTrace("Received expected number deleted:" + actual);
                this.clearCache();
                for (Product p : this.productRef) {
                    pass1 = true;
                    Product pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    if (p.getId().equals("1")) {
                        if (pp != null) {
                            this.logErr("Expected product:" + p.getId() + " to have been deleted:" + p.toString());
                            pass2 = false;
                            continue;
                        }
                        this.logTrace("Product:" + p.getId() + " was successfully deleted");
                        continue;
                    }
                    if (pp == null) {
                        this.logErr("Product:" + p.getId() + " was incorrectly deleted");
                        pass2 = false;
                        continue;
                    }
                    this.logTrace("Found product:" + pp.getId());
                }
            } else {
                this.logErr("Expected:1, actual:" + actual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("exists test failed");
        }
    }

    public void modifiedQueryTest() throws Exception {
        int passDeletedCount1 = 0;
        int passUnDeletedCount1 = 0;
        int passDeletedCount2 = 0;
        int passUnDeletedCount2 = 0;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        this.logMsg("Testing initial query");
        CriteriaDelete cd = cbuilder.createCriteriaDelete(SoftwareProduct.class);
        Root softwareproduct = cd.from(SoftwareProduct.class);
        if (softwareproduct != null) {
            Product pp;
            EntityType softwareproduct_ = softwareproduct.getModel();
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)35));
            Query q = this.getEntityManager().createQuery(cd);
            this.logMsg("Modify CriteriaDelete object");
            cd.where((Expression)cbuilder.lt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)500));
            int actual = q.executeUpdate();
            if (actual == 4) {
                this.logTrace("Received expected number of deletes:" + actual);
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp != null) {
                            this.logErr("Expected product:" + p.getId() + " to have been deleted");
                            continue;
                        }
                        this.logTrace("id:" + p.getId() + " was successfully deleted");
                        ++passDeletedCount1;
                        continue;
                    }
                    if (pp == null) {
                        this.logErr("id:" + p.getId() + " was incorrectly deleted");
                        continue;
                    }
                    this.logTrace("Found product:" + pp.getId());
                    ++passUnDeletedCount1;
                }
            } else {
                this.logErr("Expected: 4 deletes [30,31,36,37], actual:" + actual);
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    if (pp != null) {
                        this.logErr("id:" + p.getId() + ", quantity:" + pp.getQuantity() + " exists");
                        continue;
                    }
                    this.logErr("id:" + p.getId() + " was deleted");
                }
            }
            this.logMsg("Testing modified CriteriaQuery");
            cd.where((Expression)cbuilder.gt((Expression)softwareproduct.get(softwareproduct_.getSingularAttribute("quantity", Integer.class)), (Number)100));
            actual = this.getEntityManager().createQuery(cd).executeUpdate();
            if (actual == 3) {
                this.logTrace("Received expected number of deletes:" + actual);
                this.clearCache();
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(SoftwareProduct.class, (Object)p.getId());
                    if (p.getId().equals("29") || p.getId().equals("34") || p.getId().equals("38") || p.getId().equals("30") || p.getId().equals("31") || p.getId().equals("36") || p.getId().equals("37")) {
                        if (pp != null) {
                            this.logErr("Expected product:" + p.getId() + " to have been deleted");
                            continue;
                        }
                        this.logTrace("id:" + p.getId() + " was successfully deleted");
                        ++passDeletedCount2;
                        continue;
                    }
                    if (pp == null) {
                        this.logErr("id:" + p.getId() + " was incorrectly deleted");
                        continue;
                    }
                    this.logTrace("Found id:" + pp.getId());
                    ++passUnDeletedCount2;
                }
            } else {
                this.logErr("Expected: 3 additional deletes [29,34,38] total deletes [29,30,31,34,36,37,38], actual:" + actual);
                for (SoftwareProduct p : this.softwareRef) {
                    pp = (Product)this.getEntityManager().find(Product.class, (Object)p.getId());
                    this.logErr("id:" + p.getId() + ", quantity:" + pp.getQuantity());
                }
            }
        } else {
            this.logErr("Failed to get Non-null root");
        }
        this.getEntityTransaction().commit();
        if (passDeletedCount1 != 4 || passUnDeletedCount1 != 6 || passDeletedCount2 != 7 || passUnDeletedCount2 != 3) {
            throw new Exception("modifiedQueryTest failed");
        }
    }

    public void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

