/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.env;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.env.Greeting;
import org.jboss.cdi.tck.tests.implementation.simple.resource.env.GreetingBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class EnvInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnvInjectionTest.class)).withBeansXml("beans.xml")).withWebXml("web.xml")).build();
    }

    @Test
    @SpecAssertion(section="declaring_resource", id="bb")
    public void testInjectionOfEnv() {
        Bean greetingBean = (Bean)this.getBeans(GreetingBean.class, new Annotation[0]).iterator().next();
        CreationalContext greetingBeanCc = this.getCurrentManager().createCreationalContext((Contextual)greetingBean);
        GreetingBean instance = (GreetingBean)greetingBean.create(greetingBeanCc);
        assert (instance.greet() != null);
        assert (instance.greet().equals("Hello there my friend"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="la"), @SpecAssertion(section="resource_lifecycle", id="ma"), @SpecAssertion(section="resource_lifecycle", id="o")})
    public void testProduceEnvProxy() {
        Bean greetingEnvBean = (Bean)this.getBeans(String.class, new Annotation[]{new Greeting.Literal()}).iterator().next();
        CreationalContext greetingEnvCc = this.getCurrentManager().createCreationalContext((Contextual)greetingEnvBean);
        String greeting = (String)greetingEnvBean.create(greetingEnvCc);
        assert (greeting != null);
        assert (greeting.equals("Hello there my friend"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_types", id="aa")})
    public void testResourceBeanTypes() {
        Bean check = (Bean)this.getBeans(Boolean.class, new Annotation[]{new Greeting.Literal()}).iterator().next();
        ArrayList<Class<Boolean>> classes = new ArrayList<Class<Boolean>>();
        classes.addAll(Arrays.asList(Boolean.class.getInterfaces()));
        classes.addAll(Arrays.asList(Boolean.class.getSuperclass()));
        classes.add(Boolean.class);
        Class[] expectedClasses = new Class[classes.size()];
        classes.toArray(expectedClasses);
        assert (check.getTypes().size() == expectedClasses.length) : "Bean<Boolean> has " + expectedClasses.length + " types: " + check.getTypes();
        assert (this.rawTypeSetMatches(check.getTypes(), expectedClasses)) : "Expected classes are: " + classes;
    }
}

