/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Message;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.FacesMessageUtils;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;

public final class MessageRenderer
extends AbstractRenderer {
    private static final String MESSAGE_START_ELEMENT = "div";

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Iterator msgIt;
        Message message = (Message)component;
        String forComponentId = message.getFor();
        if (Beans.isDesignTime()) {
            if (forComponentId == null || forComponentId.length() == 0) {
                String summary = MessageUtil.getMessage(context, "com.sun.webui.jsf.renderkit.html.Bundle", "Message.default.summary");
                this.renderMessage(context, component, writer, new FacesMessage(summary));
            } else {
                String summary = MessageUtil.getMessage(context, "com.sun.webui.jsf.renderkit.html.Bundle", "Message.for.summary", (Object[])new String[]{forComponentId});
                String detail = MessageUtil.getMessage(context, "com.sun.webui.jsf.renderkit.html.Bundle", "Message.for.detail", (Object[])new String[]{forComponentId});
                this.renderMessage(context, component, writer, new FacesMessage(summary, detail));
            }
        } else if (forComponentId != null && (msgIt = FacesMessageUtils.getMessageIterator(context, forComponentId, (UIComponent)message)).hasNext()) {
            FacesMessage msg = (FacesMessage)msgIt.next();
            this.renderMessage(context, component, writer, msg);
        }
    }

    public void renderMessage(FacesContext context, UIComponent component, ResponseWriter writer, FacesMessage fMsg) throws IOException {
        String styleClass;
        Message message = (Message)component;
        String summary = null;
        Object detail = null;
        if (message.isShowSummary() && (summary = fMsg.getSummary()) != null && summary.length() <= 0) {
            summary = null;
        }
        if (message.isShowDetail() && (detail = fMsg.getDetail()) != null && ((String)detail).length() <= 0) {
            detail = null;
        }
        if (summary == null && detail == null) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        boolean haveSummaryAndDetail = summary != null && detail != null;
        boolean wroteStartElement = this.renderMessageStart(context, message, null, haveSummaryAndDetail, writer);
        String severityStyleClass = this.getSeverityStyleClass(fMsg, theme);
        if (summary != null) {
            styleClass = severityStyleClass != null ? severityStyleClass : theme.getStyleClass("MESSAGE_FIELD_SUMMARY_TEXT");
            this.renderMessageText(context, message, writer, summary, styleClass, wroteStartElement);
        }
        if (detail != null) {
            styleClass = severityStyleClass != null ? severityStyleClass : theme.getStyleClass("MESSAGE_FIELD_TEXT");
            if (summary != null) {
                detail = " " + (String)detail;
            }
            this.renderMessageText(context, message, writer, (String)detail, styleClass, wroteStartElement);
        }
        if (wroteStartElement) {
            this.renderMessageEnd(context, message, wroteStartElement, writer);
        }
    }

    private void renderMessageText(FacesContext context, Message message, ResponseWriter writer, String msgText, String textStyle, boolean wroteStartElement) throws IOException {
        if (!wroteStartElement) {
            this.renderMessageIdElement(context, message, textStyle, "span", writer);
        } else {
            writer.startElement("span", (UIComponent)message);
            writer.writeAttribute("class", (Object)textStyle, "class");
        }
        writer.writeText((Object)msgText, null);
        writer.endElement("span");
    }

    protected boolean renderMessageStart(FacesContext context, Message message, String styleClass, boolean haveSummaryAndDetail, ResponseWriter writer) throws IOException {
        this.renderMessageIdElement(context, message, styleClass, MESSAGE_START_ELEMENT, writer);
        return true;
    }

    protected void renderMessageEnd(FacesContext context, Message message, boolean wroteStartElement, ResponseWriter writer) throws IOException {
        writer.endElement(MESSAGE_START_ELEMENT);
    }

    protected void renderMessageIdElement(FacesContext context, Message message, String styleClass, String startElement, ResponseWriter writer) throws IOException {
        String id = message.getClientId(context);
        writer.startElement(startElement, (UIComponent)message);
        writer.writeAttribute("id", (Object)id, "id");
        String style = message.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)message, styleClass);
    }

    protected String getSeverityStyleClass(FacesMessage facesMessage, Theme theme) {
        String severityStyleClass = null;
        FacesMessage.Severity severity = facesMessage.getSeverity();
        if (severity == FacesMessage.SEVERITY_INFO) {
            severityStyleClass = theme.getStyleClass("MESSAGE_INFO");
        } else if (severity == FacesMessage.SEVERITY_WARN) {
            severityStyleClass = theme.getStyleClass("MESSAGE_WARN");
        } else if (severity == FacesMessage.SEVERITY_ERROR) {
            severityStyleClass = theme.getStyleClass("MESSAGE_ERROR");
        } else if (severity == FacesMessage.SEVERITY_FATAL) {
            severityStyleClass = theme.getStyleClass("MESSAGE_FATAL");
        }
        if (severityStyleClass == null || severityStyleClass.length() == 0) {
            return null;
        }
        return severityStyleClass;
    }
}

