/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket;

import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.ByteBufferOutput;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocketServiceApp;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class JMSWebSocket
extends MQWebSocket {
    private Object packetLock = new Object();
    private Packet packetPending = null;

    public JMSWebSocket(MQWebSocketServiceApp app, ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
        super(app, protocolHandler, request, listeners);
    }

    @Override
    protected void writePacket(Packet pkt) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("JMSWebSocket@" + ((Object)((Object)this)).hashCode() + " is not connected");
        }
        if (DEBUG) {
            this.logger.log(8, String.valueOf(Thread.currentThread()) + "JMSWebSocket@" + ((Object)((Object)this)).hashCode() + ": WRITE PACKET=" + String.valueOf(pkt));
        }
        pkt.writePacket(new ByteBufferOutput(){

            public void writeByteBuffer(ByteBuffer data) throws IOException {
                throw new IOException("Unexpected call", new UnsupportedOperationException("writeByteBuffer(ByteBuffer)"));
            }

            public void writeBytes(byte[] data) throws IOException {
                if (MQWebSocket.DEBUG) {
                    Logger cfr_ignored_0 = JMSWebSocket.this.logger;
                    JMSWebSocket.this.logger.log(8, String.valueOf(Thread.currentThread()) + "JMSWebSocket@" + this.hashCode() + ": writeBytes(data.len=" + data.length + ")");
                }
                JMSWebSocket.this.send(data);
            }
        }, false);
        if (DEBUG) {
            this.logger.log(8, String.valueOf(Thread.currentThread()) + "JMSWebSocket@" + ((Object)((Object)this)).hashCode() + ": SENT PACKET=" + String.valueOf(pkt));
        }
    }

    @Override
    protected void processData(String text) throws Exception {
        throw new IOException("JMSWebSocket.processData(String): unexpected call");
    }

    @Override
    protected void processData(byte[] data) throws Exception {
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.processData(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData(ByteBuffer buf) throws IOException {
        if (DEBUG) {
            this.logger.log(8, String.valueOf(Thread.currentThread()) + " processData:buf.remaining=" + buf.remaining());
        }
        ArrayList<Packet> packetList = null;
        while (buf.hasRemaining()) {
            WebSocketMQIPConnection conn;
            Object object = this.packetLock;
            synchronized (object) {
                if (this.packetPending != null) {
                    try {
                        if (this.packetPending.readPacket(buf)) {
                            if (!this.packetPending.hasBigPacketException()) {
                                if (packetList == null) {
                                    packetList = new ArrayList();
                                }
                                packetList.add(this.packetPending);
                                if (DEBUG) {
                                    this.logger.log(8, String.valueOf(Thread.currentThread()) + "JMSWebSocket@" + ((Object)((Object)this)).hashCode() + " processData(): READ pending PACKET=" + String.valueOf(this.packetPending) + ", buf.remaining=" + buf.remaining());
                                }
                            }
                            this.packetPending = null;
                        }
                    }
                    catch (BigPacketException e) {
                        this.logger.log(32, String.valueOf(Thread.currentThread()) + "readPacket: " + e.getMessage(), (Throwable)e);
                        conn = this.websocketApp.getMQIPConnection(this);
                        conn.handleBigPacketException(this.packetPending, e);
                    }
                    catch (IllegalArgumentException e) {
                        conn = this.websocketApp.getMQIPConnection(this);
                        conn.handleIllegalArgumentExceptionPacket(this.packetPending, e);
                    }
                    catch (OutOfMemoryError err) {
                        Globals.handleGlobalError(err, Globals.getBrokerResources().getKString("B0018") + ": " + this.packetPending.headerToString());
                    }
                    continue;
                }
            }
            if (packetList == null) {
                packetList = new ArrayList<Packet>();
            }
            Packet packet = new Packet(false);
            packet.generateSequenceNumber(false);
            packet.generateTimestamp(false);
            try {
                if (packet.readPacket(buf)) {
                    if (packet.hasBigPacketException()) continue;
                    packetList.add(packet);
                    if (!DEBUG) continue;
                    this.logger.log(8, String.valueOf(Thread.currentThread()) + "JMSWebSocket@" + ((Object)((Object)this)).hashCode() + " processData(): READ a PACKET=" + String.valueOf(packet));
                    continue;
                }
                Object err = this.packetLock;
                synchronized (err) {
                    this.packetPending = packet;
                }
            }
            catch (BigPacketException e) {
                this.logger.log(32, "readPacket: " + e.getMessage(), (Throwable)e);
                conn = this.websocketApp.getMQIPConnection(this);
                conn.handleBigPacketException(packet, e);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(32, "readPacket: " + e.getMessage(), (Throwable)e);
                conn = this.websocketApp.getMQIPConnection(this);
                conn.handleIllegalArgumentExceptionPacket(packet, e);
            }
            catch (OutOfMemoryError err) {
                Globals.handleGlobalError(err, Globals.getBrokerResources().getKString("B0018") + ": " + packet.headerToString());
            }
        }
        if (packetList == null || packetList.isEmpty()) {
            packetList = null;
            return;
        }
        if (DEBUG) {
            this.logger.log(8, "[JMSWebSocket@" + ((Object)((Object)this)).hashCode() + "]processData() after processed buf: remaining=" + buf.remaining());
        }
        WebSocketMQIPConnection conn = this.websocketApp.getMQIPConnection(this);
        for (int i = 0; i < packetList.size(); ++i) {
            try {
                Packet packet = (Packet)packetList.get(i);
                conn.receivedPacket(packet);
                conn.readData();
                continue;
            }
            catch (BrokerException e) {
                Globals.getLogger().logStack(32, "Failed to process packet from connection " + String.valueOf((Object)this), (Throwable)e);
            }
        }
        packetList.clear();
        packetList = null;
    }
}

