/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.InterruptedResolutionException;
import org.apache.felix.bundlerepository.LocalResource;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.FileUtil;
import org.apache.felix.bundlerepository.impl.ReasonImpl;
import org.apache.felix.bundlerepository.impl.ResourceCapability;
import org.apache.felix.bundlerepository.impl.ResourceCapabilityImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
implements Resolver {
    private final BundleContext m_context;
    private final Logger m_logger;
    private final Repository[] m_repositories;
    private final Set<Resource> m_addedSet = new HashSet<Resource>();
    private final Set<Requirement> m_addedRequirementSet = new HashSet<Requirement>();
    private final Set<Capability> m_globalCapabilities = new HashSet<Capability>();
    private final Set<Resource> m_failedSet = new HashSet<Resource>();
    private final Set<Resource> m_resolveSet = new HashSet<Resource>();
    private final Set<Resource> m_requiredSet = new HashSet<Resource>();
    private final Set<Resource> m_optionalSet = new HashSet<Resource>();
    private final Map<Resource, List<Reason>> m_reasonMap = new HashMap<Resource, List<Reason>>();
    private final Set<Reason> m_unsatisfiedSet = new HashSet<Reason>();
    private boolean m_resolved = false;
    private long m_resolveTimeStamp;
    private int m_resolutionFlags;

    public ResolverImpl(BundleContext context, Repository[] repositories, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.m_repositories = repositories;
    }

    @Override
    public synchronized void add(Resource resource) {
        this.m_resolved = false;
        this.m_addedSet.add(resource);
    }

    @Override
    public synchronized Resource[] getAddedResources() {
        return this.m_addedSet.toArray(new Resource[this.m_addedSet.size()]);
    }

    @Override
    public synchronized void add(Requirement requirement) {
        this.m_resolved = false;
        this.m_addedRequirementSet.add(requirement);
    }

    @Override
    public synchronized Requirement[] getAddedRequirements() {
        return this.m_addedRequirementSet.toArray(new Requirement[this.m_addedRequirementSet.size()]);
    }

    @Override
    public void addGlobalCapability(Capability capability) {
        this.m_globalCapabilities.add(capability);
    }

    @Override
    public Capability[] getGlobalCapabilities() {
        return this.m_globalCapabilities.toArray(new Capability[this.m_globalCapabilities.size()]);
    }

    @Override
    public synchronized Resource[] getRequiredResources() {
        if (this.m_resolved) {
            return this.m_requiredSet.toArray(new Resource[this.m_requiredSet.size()]);
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    @Override
    public synchronized Resource[] getOptionalResources() {
        if (this.m_resolved) {
            return this.m_optionalSet.toArray(new Resource[this.m_optionalSet.size()]);
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    @Override
    public synchronized Reason[] getReason(Resource resource) {
        if (this.m_resolved) {
            List<Reason> l = this.m_reasonMap.get(resource);
            return l != null ? l.toArray(new Reason[l.size()]) : null;
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    @Override
    public synchronized Reason[] getUnsatisfiedRequirements() {
        if (this.m_resolved) {
            return this.m_unsatisfiedSet.toArray(new Reason[this.m_unsatisfiedSet.size()]);
        }
        throw new IllegalStateException("The resources have not been resolved.");
    }

    protected LocalResource[] getLocalResources() {
        ArrayList<LocalResource> resources = new ArrayList<LocalResource>();
        for (Resource resource : this.getResources()) {
            if (resource == null || !resource.isLocal()) continue;
            resources.add((LocalResource)resource);
        }
        return resources.toArray(new LocalResource[resources.size()]);
    }

    private Resource[] getRemoteResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : this.getResources()) {
            if (resource == null || resource.isLocal()) continue;
            resources.add(resource);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    private Resource[] getResources() {
        ArrayList resources = new ArrayList();
        for (int repoIdx = 0; this.m_repositories != null && repoIdx < this.m_repositories.length; ++repoIdx) {
            boolean isLocal = this.m_repositories[repoIdx].getURI().equals("local");
            boolean isSystem = this.m_repositories[repoIdx].getURI().equals("system");
            if (isLocal && (this.m_resolutionFlags & 2) != 0 || isSystem && (this.m_resolutionFlags & 4) != 0) continue;
            Collections.addAll(resources, this.m_repositories[repoIdx].getResources());
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public synchronized boolean resolve() {
        return this.resolve(0);
    }

    @Override
    public synchronized boolean resolve(int flags) {
        Resource[] locals = this.getLocalResources();
        Resource[] remotes = this.getRemoteResources();
        this.m_resolveTimeStamp = 0L;
        for (int repoIdx = 0; this.m_repositories != null && repoIdx < this.m_repositories.length; ++repoIdx) {
            this.m_resolveTimeStamp = Math.max(this.m_resolveTimeStamp, this.m_repositories[repoIdx].getLastModified());
        }
        this.m_failedSet.clear();
        this.m_resolveSet.clear();
        this.m_requiredSet.clear();
        this.m_optionalSet.clear();
        this.m_reasonMap.clear();
        this.m_unsatisfiedSet.clear();
        this.m_resolved = true;
        this.m_resolutionFlags = flags;
        boolean result = true;
        if (!this.m_addedRequirementSet.isEmpty() || !this.m_globalCapabilities.isEmpty()) {
            ResourceImpl fake = new ResourceImpl();
            for (Capability cap : this.m_globalCapabilities) {
                fake.addCapability(cap);
            }
            for (Requirement req : this.m_addedRequirementSet) {
                fake.addRequire(req);
            }
            if (!this.resolve(fake, locals, remotes, false)) {
                result = false;
            }
        }
        for (Resource aM_addedSet : this.m_addedSet) {
            if (this.resolve(aM_addedSet, locals, remotes, false)) continue;
            result = false;
        }
        this.m_requiredSet.removeAll(this.m_addedSet);
        if ((flags & 2) == 0) {
            this.m_requiredSet.removeAll(Arrays.asList(locals));
        }
        this.m_optionalSet.removeAll(this.m_addedSet);
        this.m_optionalSet.removeAll(this.m_requiredSet);
        if ((flags & 2) == 0) {
            this.m_optionalSet.removeAll(Arrays.asList(locals));
        }
        return result;
    }

    private boolean resolve(Resource resource, Resource[] locals, Resource[] remotes, boolean optional) {
        boolean result = true;
        if (this.m_resolveSet.contains(resource) || this.m_requiredSet.contains(resource) || this.m_optionalSet.contains(resource)) {
            return true;
        }
        if (this.m_failedSet.contains(resource)) {
            return false;
        }
        this.m_resolveSet.add(resource);
        Requirement[] reqs = resource.getRequirements();
        if (reqs != null) {
            for (Requirement req : reqs) {
                if ((this.m_resolutionFlags & 1) != 0 && req.isOptional()) continue;
                Resource candidate = this.searchResources(req, this.m_addedSet);
                if (candidate == null) {
                    candidate = this.searchResources(req, this.m_requiredSet);
                }
                if (candidate == null) {
                    candidate = this.searchResources(req, this.m_optionalSet);
                }
                if (candidate == null) {
                    candidate = this.searchResources(req, this.m_resolveSet);
                }
                if (candidate == null) {
                    List<ResourceCapability> candidateCapabilities = this.searchResources(req, locals);
                    candidateCapabilities.addAll(this.searchResources(req, remotes));
                    while (candidate == null && !candidateCapabilities.isEmpty()) {
                        ResourceCapability bestCapability = this.getBestCandidate(candidateCapabilities);
                        if (this.resolve(bestCapability.getResource(), locals, remotes, optional || req.isOptional())) {
                            candidate = bestCapability.getResource();
                            continue;
                        }
                        candidateCapabilities.remove(bestCapability);
                    }
                }
                if (candidate == null && !req.isOptional()) {
                    result = false;
                    this.m_unsatisfiedSet.add(new ReasonImpl(resource, req));
                    continue;
                }
                if (candidate == null) continue;
                if (this.resolve(candidate, locals, remotes, optional || req.isOptional())) {
                    if (optional || req.isOptional()) {
                        this.m_optionalSet.add(candidate);
                        this.m_resolveSet.remove(candidate);
                    } else {
                        this.m_requiredSet.add(candidate);
                        this.m_optionalSet.remove(candidate);
                        this.m_resolveSet.remove(candidate);
                    }
                    List<Reason> reasons = this.m_reasonMap.get(candidate);
                    if (reasons == null) {
                        reasons = new ArrayList<Reason>();
                        this.m_reasonMap.put(candidate, reasons);
                    }
                    reasons.add(new ReasonImpl(resource, req));
                    continue;
                }
                result = false;
            }
        }
        if (!result) {
            this.m_resolveSet.remove(resource);
            this.m_failedSet.add(resource);
        }
        return result;
    }

    private Resource searchResources(Requirement req, Set<Resource> resourceSet) {
        for (Resource aResourceSet : resourceSet) {
            this.checkInterrupt();
            Capability[] caps = aResourceSet.getCapabilities();
            if (caps == null) continue;
            for (Capability cap : caps) {
                if (!req.isSatisfied(cap)) continue;
                return aResourceSet;
            }
        }
        return null;
    }

    private List<ResourceCapability> searchResources(Requirement req, Resource[] resources) {
        ArrayList<ResourceCapability> matchingCapabilities = new ArrayList<ResourceCapability>();
        if (resources != null) {
            for (Resource resource : resources) {
                Capability[] caps;
                this.checkInterrupt();
                if (this.m_failedSet.contains(resource) || (caps = resource.getCapabilities()) == null) continue;
                for (Capability cap : caps) {
                    if (!req.isSatisfied(cap)) continue;
                    matchingCapabilities.add(new ResourceCapabilityImpl(resource, cap));
                }
            }
        }
        return matchingCapabilities;
    }

    private ResourceCapability getBestCandidate(List<ResourceCapability> caps) {
        Version bestVersion = null;
        ResourceCapability best = null;
        boolean bestLocal = false;
        for (ResourceCapability cap : caps) {
            Object v;
            boolean isCurrentLocal = cap.getResource().isLocal();
            if (best == null) {
                best = cap;
                bestLocal = isCurrentLocal;
                v = cap.getCapability().getPropertiesAsMap().get("version");
                if (v == null || !(v instanceof Version)) continue;
                bestVersion = (Version)v;
                continue;
            }
            if ((this.m_resolutionFlags & 8) == 0 && bestLocal && !isCurrentLocal) continue;
            v = cap.getCapability().getPropertiesAsMap().get("version");
            if (v == null && bestVersion == null && best.getResource().getCapabilities().length < cap.getResource().getCapabilities().length) {
                best = cap;
                bestLocal = isCurrentLocal;
                bestVersion = null;
                continue;
            }
            if (v == null || !(v instanceof Version)) continue;
            if (bestVersion == null || bestVersion.compareTo((Version)v) < 0) {
                best = cap;
                bestLocal = isCurrentLocal;
                bestVersion = (Version)v;
                continue;
            }
            if (bestVersion.compareTo((Version)v) != 0) continue;
            if (best.getResource().getSymbolicName() != null && best.getResource().getSymbolicName().equals(cap.getResource().getSymbolicName())) {
                if (best.getResource().getVersion().compareTo(cap.getResource().getVersion()) >= 0) continue;
                best = cap;
                bestLocal = isCurrentLocal;
                bestVersion = (Version)v;
                continue;
            }
            if (best.getResource().getCapabilities().length >= cap.getResource().getCapabilities().length) continue;
            best = cap;
            bestLocal = isCurrentLocal;
            bestVersion = (Version)v;
        }
        return best == null ? null : best;
    }

    private void checkInterrupt() {
        if (Thread.interrupted()) {
            throw new InterruptedResolutionException();
        }
    }

    @Override
    public synchronized void deploy(int flags) {
        int i;
        if (!this.m_resolved && !this.resolve(flags)) {
            this.m_logger.log(1, "Resolver: Cannot resolve target resources.");
            return;
        }
        for (int repoIdx = 0; this.m_repositories != null && repoIdx < this.m_repositories.length; ++repoIdx) {
            if (this.m_repositories[repoIdx].getLastModified() <= this.m_resolveTimeStamp) continue;
            throw new IllegalStateException("Framework state has changed, must resolve again.");
        }
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        Resource[] resources = this.getAddedResources();
        for (i = 0; resources != null && i < resources.length; ++i) {
            resourceSet.add(resources[i]);
        }
        resources = this.getRequiredResources();
        for (i = 0; resources != null && i < resources.length; ++i) {
            resourceSet.add(resources[i]);
        }
        if ((flags & 1) == 0) {
            resources = this.getOptionalResources();
            for (i = 0; resources != null && i < resources.length; ++i) {
                resourceSet.add(resources[i]);
            }
        }
        Resource[] deployResources = resourceSet.toArray(new Resource[resourceSet.size()]);
        ArrayList<Bundle> startList = new ArrayList<Bundle>();
        for (Resource deployResource : deployResources) {
            Bundle bundle;
            LocalResource localResource = this.findUpdatableLocalResource(deployResource);
            if (localResource != null && this.isResourceUpdatable(localResource, deployResource, deployResources)) {
                if (localResource.equals(deployResource)) continue;
                try {
                    boolean doStartBundle;
                    boolean bl = doStartBundle = (flags & 0x10) != 0;
                    if (localResource.getBundle().getState() == 32) {
                        doStartBundle = true;
                        localResource.getBundle().stop();
                    }
                    localResource.getBundle().update(FileUtil.openURL(new URL(deployResource.getURI())));
                    if (!doStartBundle || this.isFragmentBundle(bundle = localResource.getBundle())) continue;
                    startList.add(bundle);
                    continue;
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Resolver: Update error - " + ResolverImpl.getBundleName(localResource.getBundle()), ex);
                    return;
                }
            }
            try {
                URL url = new URL(deployResource.getURI());
                bundle = this.m_context.installBundle("obr://" + deployResource.getSymbolicName() + "/-" + System.currentTimeMillis(), FileUtil.openURL(url));
                if ((flags & 0x10) == 0 || this.isFragmentBundle(bundle)) continue;
                startList.add(bundle);
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Resolver: Install error - " + deployResource.getSymbolicName(), ex);
                return;
            }
        }
        for (Bundle aStartList : startList) {
            try {
                aStartList.start();
            }
            catch (BundleException ex) {
                this.m_logger.log(1, "Resolver: Start error - " + aStartList.getSymbolicName(), ex);
            }
        }
    }

    private boolean isFragmentBundle(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    private LocalResource findUpdatableLocalResource(Resource resource) {
        Resource[] localResources;
        for (LocalResource localResource : localResources = this.findLocalResources(resource.getSymbolicName())) {
            if (!this.isResourceUpdatable(localResource, resource, localResources)) continue;
            return localResource;
        }
        return null;
    }

    private LocalResource[] findLocalResources(String symName) {
        LocalResource[] localResources = this.getLocalResources();
        ArrayList<LocalResource> matchList = new ArrayList<LocalResource>();
        for (LocalResource localResource : localResources) {
            String localSymName = localResource.getSymbolicName();
            if (localSymName == null || !localSymName.equals(symName)) continue;
            matchList.add(localResource);
        }
        return matchList.toArray(new LocalResource[matchList.size()]);
    }

    private boolean isResourceUpdatable(Resource oldVersion, Resource newVersion, Resource[] resources) {
        Requirement[] reqs = this.getResolvableRequirements(oldVersion, resources);
        if (reqs == null) {
            return true;
        }
        Capability[] caps = newVersion.getCapabilities();
        if (caps == null) {
            return false;
        }
        for (Requirement req : reqs) {
            boolean satisfied = false;
            for (int capIdx = 0; !satisfied && capIdx < caps.length; ++capIdx) {
                if (!req.isSatisfied(caps[capIdx])) continue;
                satisfied = true;
            }
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    private Requirement[] getResolvableRequirements(Resource resource, Resource[] resources) {
        Capability[] caps = resource.getCapabilities();
        if (caps != null && caps.length > 0) {
            ArrayList<Requirement> reqList = new ArrayList<Requirement>();
            block0: for (Capability cap : caps) {
                boolean added = false;
                for (Resource aResource : resources) {
                    Requirement[] reqs = aResource.getRequirements();
                    if (reqs != null) {
                        for (Requirement req : reqs) {
                            if (!req.isSatisfied(cap)) continue;
                            added = true;
                            reqList.add(req);
                        }
                    }
                    if (added) continue block0;
                }
            }
            return reqList.toArray(new Requirement[reqList.size()]);
        }
        return null;
    }

    public static String getBundleName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name;
    }
}

