/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.KeyNotFoundException;
import com.sun.messaging.jmq.io.PacketReadEOFException;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.api.util.MQObjectInputStream;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.RetrySQLRecoverableException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.MQSQLException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class Util
implements DBConstants {
    static boolean OracleBLOB_initialized = false;
    static Method OracleBLOB_empty_lob_method = null;
    static Method OracleBLOB_getBinaryOutputStream_method = null;
    static Method OraclePreparedStatement_setBLOB_method = null;

    public static void setString(PreparedStatement pstmt, int pos, String value) throws SQLException {
        Util.setString(pstmt, pos, value, true);
    }

    static void setString(PreparedStatement pstmt, int pos, String value, boolean emptyStringToNull) throws SQLException {
        if (value != null && value.length() > 0) {
            pstmt.setString(pos, value);
        } else {
            if (value != null && value.length() == 0 && !emptyStringToNull) {
                throw new SQLException("Empty string for [" + pos + "] is not allowed");
            }
            pstmt.setNull(pos, 12);
        }
    }

    static void setInt(PreparedStatement pstmt, int pos, int value) throws SQLException {
        if (value >= 0) {
            pstmt.setInt(pos, value);
        } else {
            pstmt.setNull(pos, 4);
        }
    }

    static void setLong(PreparedStatement pstmt, int pos, long value) throws SQLException {
        if (value >= 0L) {
            pstmt.setLong(pos, value);
        } else {
            pstmt.setNull(pos, -5);
        }
    }

    static void setObject(PreparedStatement pstmt, int pos, Object obj) throws IOException, SQLException {
        if (obj == null) {
            pstmt.setNull(pos, -4);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream bos = new ObjectOutputStream(baos);
            bos.writeObject(obj);
            bos.close();
            byte[] buf = baos.toByteArray();
            Util.setBytes(pstmt, pos, buf);
        }
    }

    public static void setBytes(PreparedStatement pstmt, int pos, byte[] data) throws SQLException {
        if (data == null) {
            pstmt.setNull(pos, -4);
        } else {
            pstmt.setBytes(pos, data);
        }
    }

    static void setBytesAsBinaryStream(PreparedStatement pstmt, int pos, byte[] data) throws IOException, SQLException {
        if (data == null) {
            pstmt.setNull(pos, -4);
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            pstmt.setBinaryStream(pos, (InputStream)bais, data.length);
            bais.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object readObject(ResultSet rs, int pos) throws IOException, SQLException, ClassNotFoundException {
        InputStream is = rs.getBinaryStream(pos);
        if (is == null) {
            return null;
        }
        try (MQObjectInputStream ois = null;){
            Object obj;
            ois = new MQObjectInputStream(is);
            Object object = obj = ois.readObject();
            return object;
        }
    }

    public static byte[] readBytes(ResultSet rs, int pos) throws IOException, SQLException {
        InputStream is = rs.getBinaryStream(pos);
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[1024];
        try {
            int cnt;
            while ((cnt = is.read(buf, 0, 256)) > 0) {
                bos.write(buf, 0, cnt);
            }
        }
        catch (EOFException e) {
        }
        return bos.toByteArray();
    }

    public static void close(ResultSet rset, Statement stmt, Connection conn, Throwable ex) throws BrokerException {
        Util.close(rset, stmt, conn, ex, null);
    }

    public static void close(ResultSet rset, Statement stmt, Connection conn, Throwable ex, CommDBManager mgrArg) throws BrokerException {
        try {
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", e));
        }
        finally {
            if (conn != null) {
                if (mgrArg == null) {
                    DBManager.getDBManager().freeConnection(conn, ex);
                } else {
                    mgrArg.freeConnection(conn, ex);
                }
            }
        }
    }

    public static boolean isAlphanumericString(String str) {
        boolean isValid = false;
        if (str != null && str.length() > 0) {
            char c;
            int len = str.length();
            for (int i = 0; i < len && ((isValid = Character.isLetterOrDigit(c = str.charAt(i))) || c == '_'); ++i) {
            }
        }
        return isValid;
    }

    static void OracleBLOB_init() throws BrokerException {
        if (!OracleBLOB_initialized) {
            try {
                Class<?> BLOBCls = Class.forName("oracle.sql.BLOB");
                OracleBLOB_empty_lob_method = BLOBCls.getMethod("empty_lob", null);
                OracleBLOB_getBinaryOutputStream_method = BLOBCls.getMethod("getBinaryOutputStream", null);
                Class<?> OraclePreparedStatementCls = Class.forName("oracle.jdbc.OraclePreparedStatement");
                Class[] paramTypes = new Class[]{Integer.TYPE, BLOBCls};
                OraclePreparedStatement_setBLOB_method = OraclePreparedStatementCls.getMethod("setBLOB", paramTypes);
                OracleBLOB_initialized = true;
            }
            catch (Exception e) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Oracle LOB extension APIs not found"), e);
            }
        }
    }

    static Blob OracleBLOB_empty_lob() throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        Blob blob = (Blob)OracleBLOB_empty_lob_method.invoke(null, (Object[])null);
        return blob;
    }

    static OutputStream OracleBLOB_getBinaryOutputStream(Blob blob) throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        OutputStream out = (OutputStream)OracleBLOB_getBinaryOutputStream_method.invoke((Object)blob, (Object[])null);
        return out;
    }

    static void OraclePreparedStatement_setBLOB(PreparedStatement pstmt, int pos, Blob blob) throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        Object[] arglist = new Object[]{pos, blob};
        OraclePreparedStatement_setBLOB_method.invoke((Object)pstmt, arglist);
    }

    static Blob setOracleBLOB(PreparedStatement pstmt, int pos) throws Exception {
        Blob blob = Util.OracleBLOB_empty_lob();
        Util.OraclePreparedStatement_setBLOB(pstmt, pos, blob);
        return blob;
    }

    public static List getChunkDelimiters(ResultSet rs, int tsColumnIndex, int chunkSize) throws SQLException {
        ArrayList<Long> list = new ArrayList<Long>(10);
        int rowCount = 0;
        while (rs.next()) {
            if (++rowCount != chunkSize) continue;
            rowCount = 0;
            list.add(rs.getLong(tsColumnIndex));
        }
        list.add(System.currentTimeMillis() + 60000L);
        return list;
    }

    public static boolean isConnectionError(Throwable t, CommDBManager mgr) {
        return Util.isConnectionError(t, mgr, true);
    }

    public static boolean isConnectionError(Throwable t, CommDBManager mgr, boolean aggressiveOnNPDS) {
        Throwable cause = t;
        if (t instanceof DestinationNotFoundException || t instanceof TakeoverLockException || t instanceof StoreBeingTakenOverException || t instanceof TransactionAckExistException || t instanceof DupKeyException || t instanceof KeyNotFoundException) {
            return false;
        }
        if (t instanceof BrokerException) {
            cause = t.getCause();
        }
        if (cause instanceof MQSQLException) {
            cause = ((MQSQLException)cause).getNextException();
        }
        if (!(cause instanceof SQLException) && !(cause instanceof IOException)) {
            return false;
        }
        if (aggressiveOnNPDS && !mgr.isPoolDataSource()) {
            return true;
        }
        int eCode = 0;
        String eSQLState = null;
        String eMessage = cause.getMessage();
        if (cause instanceof SQLException) {
            eCode = ((SQLException)cause).getErrorCode();
            eSQLState = ((SQLException)cause).getSQLState();
        }
        if (CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS != null) {
            if (CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS.isInstance(cause)) {
                return true;
            }
        }
        if (CommDBManager.RECOVERABLE_SQLEX_CLASS != null) {
            if (CommDBManager.RECOVERABLE_SQLEX_CLASS.isInstance(cause)) {
                return true;
            }
        }
        if (mgr.isMysql()) {
            if (eMessage.contains("Communication link failure")) {
                return true;
            }
            if (eMessage.contains("No operations allowed after connection closed")) {
                return true;
            }
            if (eMessage.startsWith("Got temporary error") && eMessage.endsWith("from NDB")) {
                return true;
            }
            if (eCode == 1205 || eMessage.contains("Lock wait timeout exceeded")) {
                return true;
            }
        } else if (mgr.isOracle()) {
            if (eMessage.toLowerCase().contains("connection timed out")) {
                return true;
            }
            if (eCode == 30006 || eCode == 54 || eCode == 28 || eCode == 12514 || eCode == 12505 || eCode == 1089 || eCode == 1033 || eCode == 12528) {
                return true;
            }
        }
        if (eSQLState != null) {
            if (mgr.getSQLStateType() == 2) {
                return eSQLState.startsWith("08") || eSQLState.equals("01002") || eSQLState.equals("04501") || eSQLState.equals("HYT00") || eSQLState.equals("HYT01") || eSQLState.equals("S1T00");
            }
            if (mgr.getSQLStateType() == 1) {
                return eSQLState.startsWith("08");
            }
        }
        return false;
    }

    public static String brokerNotTakenOverClause(DBManager dbMgr) throws BrokerException {
        return Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dbMgr.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
    }

    public static void checkBeingTakenOver(Connection conn, DBManager dbMgr, Logger logger, java.util.logging.Logger logger_) throws BrokerException {
        if (!Globals.getHAEnabled()) {
            return;
        }
        String brokerID = dbMgr.getBrokerID();
        BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
        if (dao.isBeingTakenOver(conn, brokerID)) {
            StoreBeingTakenOverException be = new StoreBeingTakenOverException(Globals.getBrokerResources().getKString("B3223"));
            try {
                HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                String emsg = be.getMessage() + "[" + (String)(bkrInfo == null ? brokerID : bkrInfo.toString()) + "]";
                logger.logStack(32, emsg, be);
                Util.logExt(logger_, Level.SEVERE, emsg, be);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw be;
        }
    }

    public static void logExt(java.util.logging.Logger logger_, Level level, String emsg, Throwable t) {
        if (logger_ == null) {
            return;
        }
        if (t != null) {
            logger_.log(level, emsg, t);
        } else {
            logger_.log(level, emsg);
        }
    }

    public static class RetryStrategy {
        CommDBManager dbMgr = null;
        Exception originalException = null;
        int retryCount = 0;
        int retryMax;
        long delayTime;
        boolean retryConnect = false;
        boolean retryConnectRequestOnly = false;

        public RetryStrategy() throws BrokerException {
            this(DBManager.getDBManager());
        }

        public RetryStrategy(CommDBManager mgr) {
            this(mgr, mgr.txnRetryDelay, mgr.txnRetryMax, false, false);
        }

        public RetryStrategy(CommDBManager mgr, long retryDelay, int max, boolean retryConnect) {
            this(mgr, retryDelay, max, retryConnect, false);
        }

        public RetryStrategy(CommDBManager mgr, long retryDelay, int max, boolean retryConnect, boolean retryConnectRequestOnly) {
            this.dbMgr = mgr;
            this.delayTime = retryDelay;
            this.retryMax = max;
            this.retryConnect = retryConnect;
            this.retryConnectRequestOnly = retryConnectRequestOnly;
        }

        public boolean assertShouldRetry(Exception e) throws BrokerException {
            return this.assertShouldRetry(e, null);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean assertShouldRetry(Exception e, Connection conn) throws BrokerException {
            long remain;
            boolean retry;
            Throwable cause;
            boolean matchretry;
            boolean recoverableretry;
            boolean transientretry;
            boolean replaycheck;
            block53: {
                String sqlState;
                int errorCode;
                SQLException ex;
                block54: {
                    block57: {
                        block56: {
                            block55: {
                                block44: {
                                    String p;
                                    Iterator<String> itr;
                                    block52: {
                                        block42: {
                                            block51: {
                                                block50: {
                                                    block49: {
                                                        block48: {
                                                            block47: {
                                                                block46: {
                                                                    block45: {
                                                                        block43: {
                                                                            Throwable throwable;
                                                                            void var8_10;
                                                                            replaycheck = false;
                                                                            transientretry = false;
                                                                            recoverableretry = false;
                                                                            matchretry = false;
                                                                            if (this.originalException == null) {
                                                                                this.originalException = e;
                                                                            }
                                                                            if (e instanceof StoreBeingTakenOverException && Globals.getHAEnabled()) {
                                                                                String msg = Globals.getBrokerResources().getKString("B3203");
                                                                                Globals.getLogger().logStack(32, msg, e);
                                                                                Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), msg, BrokerEvent.Type.RESTART, e, true, false, true);
                                                                                throw (StoreBeingTakenOverException)e;
                                                                            }
                                                                            if (this.dbMgr.getIsClosing()) {
                                                                                if (this.originalException instanceof BrokerException) {
                                                                                    throw (BrokerException)this.originalException;
                                                                                }
                                                                                throw new BrokerException(Globals.getBrokerResources().getKString("B1341"), this.originalException);
                                                                            }
                                                                            cause = e;
                                                                            Exception exception = e;
                                                                            while (var8_10 instanceof BrokerException && (throwable = var8_10.getCause()) != null) {
                                                                                if (!(throwable instanceof SQLException) && !(throwable instanceof IOException)) continue;
                                                                                cause = throwable;
                                                                                break;
                                                                            }
                                                                            if (cause instanceof MQSQLException) {
                                                                                cause = ((SQLException)cause).getNextException();
                                                                            } else if (cause instanceof IOException && Util.isConnectionError(cause, this.dbMgr, false)) {
                                                                                cause = new SQLException(cause.getMessage(), cause);
                                                                            }
                                                                            retry = false;
                                                                            if (!(cause instanceof SQLException)) break block42;
                                                                            ex = (SQLException)cause;
                                                                            errorCode = ex.getErrorCode();
                                                                            sqlState = ex.getSQLState();
                                                                            if (this.retryConnect) break block43;
                                                                            if (!this.retryConnectRequestOnly || !(e instanceof BrokerException) || !((BrokerException)e).getSQLReconnect()) break block44;
                                                                        }
                                                                        if (CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS == null) break block45;
                                                                        if (!CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS.isInstance(ex)) break block45;
                                                                        retry = true;
                                                                        transientretry = true;
                                                                        break block44;
                                                                    }
                                                                    if (CommDBManager.TRANSIENT_SQLEX_CLASS == null) break block46;
                                                                    if (CommDBManager.TRANSIENT_SQLEX_CLASS.isInstance(ex)) break block47;
                                                                }
                                                                if (sqlState == null || !sqlState.startsWith("08") && !sqlState.startsWith("40")) break block48;
                                                            }
                                                            retry = true;
                                                            transientretry = true;
                                                            break block44;
                                                        }
                                                        if (CommDBManager.TIMEOUT_SQLEX_CLASS == null) break block49;
                                                        if (!CommDBManager.TIMEOUT_SQLEX_CLASS.isInstance(ex)) break block49;
                                                        retry = true;
                                                        break block44;
                                                    }
                                                    if (CommDBManager.TRANSACTION_ROLLBACK_SQLEX_CLASS == null) break block50;
                                                    if (!CommDBManager.TRANSACTION_ROLLBACK_SQLEX_CLASS.isInstance(ex)) break block50;
                                                    retry = true;
                                                    break block44;
                                                }
                                                if (CommDBManager.RECOVERABLE_SQLEX_CLASS == null) break block51;
                                                if (!CommDBManager.RECOVERABLE_SQLEX_CLASS.isInstance(ex)) break block51;
                                                retry = true;
                                                recoverableretry = true;
                                                break block44;
                                            }
                                            List<String> paterns = this.dbMgr.getReconnectPatterns();
                                            itr = paterns.iterator();
                                            p = null;
                                            break block52;
                                        }
                                        if (cause instanceof PacketReadEOFException) {
                                            retry = true;
                                        }
                                        break block53;
                                    }
                                    while (itr.hasNext()) {
                                        try {
                                            p = itr.next();
                                            if (!ex.getMessage().matches(p)) continue;
                                            matchretry = true;
                                            retry = true;
                                            break;
                                        }
                                        catch (Exception ee) {
                                            Globals.getLogger().logStack(16, ee.getMessage(), ee);
                                        }
                                    }
                                }
                                if (retry) break block54;
                                if (CommDBManager.TRANSIENT_SQLEX_CLASS == null) break block55;
                                if (!CommDBManager.TRANSIENT_SQLEX_CLASS.isInstance(ex)) break block55;
                                retry = true;
                                transientretry = true;
                                break block54;
                            }
                            if (CommDBManager.RECOVERABLE_SQLEX_CLASS == null) break block56;
                            if (!CommDBManager.RECOVERABLE_SQLEX_CLASS.isInstance(ex)) break block56;
                            if (e instanceof BrokerException) {
                                if (((BrokerException)e).getSQLRecoverable()) {
                                    retry = true;
                                    recoverableretry = true;
                                }
                                if (((BrokerException)e).getSQLReplayCheck()) {
                                    replaycheck = true;
                                }
                            }
                            break block54;
                        }
                        if (sqlState == null) break block57;
                        if ((sqlState.startsWith("40") || sqlState.startsWith("08")) && e instanceof BrokerException) {
                            if (((BrokerException)e).getSQLRecoverable()) {
                                retry = true;
                                recoverableretry = true;
                            }
                            if (((BrokerException)e).getSQLReplayCheck()) {
                                replaycheck = true;
                            }
                        }
                        break block54;
                    }
                    if (Util.isConnectionError(ex, this.dbMgr, false) && e instanceof BrokerException) {
                        if (((BrokerException)e).getSQLRecoverable()) {
                            retry = true;
                            recoverableretry = true;
                        }
                        if (((BrokerException)e).getSQLReplayCheck()) {
                            replaycheck = true;
                        }
                    }
                }
                if (!retry && e instanceof BrokerException && ((BrokerException)e).getSQLRecoverable()) {
                    if (this.dbMgr.isOracle() && (errorCode == 30006 || errorCode == 28)) {
                        retry = true;
                        recoverableretry = true;
                    }
                    if (!retry && this.dbMgr.isRetriableSQLErrorCode(errorCode)) {
                        retry = true;
                        recoverableretry = true;
                    }
                    if (((BrokerException)e).getSQLReplayCheck()) {
                        replaycheck = true;
                    }
                }
                if (!retry) {
                    if (this.dbMgr.isOracle()) {
                        retry = errorCode == 20 || errorCode == 54 || errorCode == 17008 || errorCode == 17009 || errorCode == 17016 || errorCode == 12535;
                    } else if (this.dbMgr.isMysql()) {
                        String emsg = ex.getMessage();
                        retry = errorCode == 1205 || errorCode == 1213 || emsg.trim().toLowerCase().contains("got temporary error") && emsg.trim().toLowerCase().contains("from ndb") || emsg.trim().toLowerCase().contains("no operations allowed after connection closed") || emsg.trim().toLowerCase().contains("lock wait timeout exceeded");
                    } else if (this.dbMgr.isDerby()) {
                        retry = sqlState.equals("40001");
                    } else {
                        String msg = ex.getMessage();
                        boolean bl = retry = msg != null && (msg.toLowerCase().indexOf("timed out") >= 0 || msg.toLowerCase().indexOf("rerun the transaction") >= 0);
                    }
                }
            }
            if (retry && this.retryCount < this.retryMax) {
                ++this.retryCount;
                Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1339", this.retryCount + "," + this.delayTime, cause.getMessage() + (String)(cause instanceof SQLException ? "[" + ((SQLException)cause).getErrorCode() + "][" + ((SQLException)cause).getSQLState() + "]" : "")) + "(" + transientretry + "," + recoverableretry + "[" + replaycheck + "]," + matchretry + ")");
                remain = this.delayTime;
            } else {
                if (!(this.originalException instanceof BrokerException)) {
                    this.originalException = new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to retry database operation"), this.originalException);
                }
                throw (BrokerException)this.originalException;
            }
            while (remain > 0L && !this.dbMgr.getIsClosing()) {
                try {
                    Thread.sleep(1000L);
                    remain -= 1000L;
                }
                catch (Exception sqlState) {}
            }
            if (this.dbMgr.getIsClosing()) {
                if (this.originalException instanceof BrokerException) {
                    throw (BrokerException)this.originalException;
                }
                throw new BrokerException(Globals.getBrokerResources().getKString("B1341"), this.originalException);
            }
            Globals.getLogger().logStack(4, "Attempt to retry database operation due to unexpected error [retryCount=" + this.retryCount + ", delayTime=" + this.delayTime + "]", e);
            if (!this.retryConnect || this.retryConnectRequestOnly) {
                this.delayTime *= 2L;
            }
            if (recoverableretry && conn != null) {
                RetrySQLRecoverableException be = new RetrySQLRecoverableException("SQLRecoverableException", cause);
                be.setSQLReplayCheck(replaycheck);
                throw be;
            }
            return replaycheck;
        }
    }
}

