/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;

class ExecutorServiceWrapper
implements ExecutorService {
    static final ThreadLocal<List<AsyncInvocationInterceptor>> asyncInterceptors = new ThreadLocal();
    private final ExecutorService wrapped;

    ExecutorServiceWrapper(ExecutorService wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void shutdown() {
        this.wrapped.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.wrapped.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.wrapped.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.wrapped.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrapped.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.wrapped.submit(ExecutorServiceWrapper.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.wrapped.submit(ExecutorServiceWrapper.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.wrapped.submit(ExecutorServiceWrapper.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.wrapped.invokeAll(ExecutorServiceWrapper.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrapped.invokeAll(ExecutorServiceWrapper.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.wrapped.invokeAny(ExecutorServiceWrapper.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.wrapped.invokeAny(ExecutorServiceWrapper.wrap(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.wrapped.execute(ExecutorServiceWrapper.wrap(command));
    }

    private static <T> Callable<T> wrap(Callable<T> task) {
        List<AsyncInvocationInterceptor> asyncInvocationInterceptors = asyncInterceptors.get();
        asyncInterceptors.remove();
        return () -> {
            ExecutorServiceWrapper.applyContextOnInterceptors(asyncInvocationInterceptors);
            return task.call();
        };
    }

    private static Runnable wrap(Runnable task) {
        List<AsyncInvocationInterceptor> asyncInvocationInterceptors = asyncInterceptors.get();
        asyncInterceptors.remove();
        return () -> {
            ExecutorServiceWrapper.applyContextOnInterceptors(asyncInvocationInterceptors);
            task.run();
        };
    }

    private static void applyContextOnInterceptors(List<AsyncInvocationInterceptor> asyncInvocationInterceptors) {
        if (asyncInvocationInterceptors != null) {
            int i = asyncInvocationInterceptors.size();
            while (i-- > 0) {
                asyncInvocationInterceptors.get(i).applyContext();
            }
        }
    }

    private static <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(ExecutorServiceWrapper::wrap).collect(Collectors.toList());
    }
}

