/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.webservices.oracle_internal_api.rm;

import jakarta.xml.ws.WebServiceFeature;

public class ReliableMessagingFeature
extends WebServiceFeature {
    private long sequenceManagerMaintenancePeriod = 60000L;
    private int maxConcurrentSession = 100;
    private int userTransactionTimeout = 0;
    public static final String ID = "com.oracle.webservices.oracle_internal_api.rm.ReliableMessagingFeature";
    protected static final long serialVersionUID = 1523241975L;

    private void setEnabled(boolean x) {
        this.enabled = x;
    }

    public long getSequenceManagerMaintenancePeriod() {
        return this.sequenceManagerMaintenancePeriod;
    }

    private void setSequenceManagerMaintenancePeriod(long x) {
        this.sequenceManagerMaintenancePeriod = x;
    }

    public int getMaxConcurrentSession() {
        return this.maxConcurrentSession;
    }

    private void setMaxConcurrentSession(int x) {
        this.maxConcurrentSession = x;
    }

    public int getUserTransactionTimeout() {
        return this.userTransactionTimeout;
    }

    private void setUserTransactionTimeout(int x) {
        this.userTransactionTimeout = x;
    }

    public String getID() {
        return ID;
    }

    public static String getSeedPolicyName() {
        return "oracle/reliable_messaging_internal_api_policy";
    }

    private ReliableMessagingFeature() {
        this.enabled = true;
    }

    public static Builder builder() {
        return new Builder(new ReliableMessagingFeature());
    }

    public String toString() {
        return "[" + this.getID() + ", enabled=" + this.enabled + ", sequenceManagerMaintenancePeriod=" + this.sequenceManagerMaintenancePeriod + ", maxConcurrentSession=" + this.maxConcurrentSession + ", userTransactionTimeout=" + this.userTransactionTimeout + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReliableMessagingFeature that = (ReliableMessagingFeature)((Object)o);
        if (!this.getID().equals(that.getID())) {
            return false;
        }
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.sequenceManagerMaintenancePeriod != that.sequenceManagerMaintenancePeriod) {
            return false;
        }
        if (this.maxConcurrentSession != that.maxConcurrentSession) {
            return false;
        }
        return this.userTransactionTimeout == that.userTransactionTimeout;
    }

    public int hashCode() {
        int result = 3;
        result = 31 * result + this.getID().hashCode();
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (int)(this.sequenceManagerMaintenancePeriod ^ this.sequenceManagerMaintenancePeriod >>> 32);
        result = 31 * result + this.maxConcurrentSession;
        result = 31 * result + this.userTransactionTimeout;
        return result;
    }

    public static final class Builder {
        private final ReliableMessagingFeature o;

        Builder(ReliableMessagingFeature x) {
            this.o = x;
        }

        public ReliableMessagingFeature build() {
            return this.o;
        }

        public Builder enabled(boolean x) {
            this.o.setEnabled(x);
            return this;
        }

        public Builder sequenceManagerMaintenancePeriod(long x) {
            this.o.setSequenceManagerMaintenancePeriod(x);
            return this;
        }

        public Builder maxConcurrentSession(int x) {
            this.o.setMaxConcurrentSession(x);
            return this;
        }

        public Builder userTransactionTimeout(int x) {
            this.o.setUserTransactionTimeout(x);
            return this;
        }
    }
}

