/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.AssocWithThreadResourcePool;
import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.UnpooledResource;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ResourcePoolFactoryImpl {
    private static final String SWITCH_OFF_ACC_CONNECTION_POOLING = "com.sun.enterprise.connectors.SwitchoffACCConnectionPooling";
    private static String switchOffACCConnectionPoolingProperty = System.getProperty("com.sun.enterprise.connectors.SwitchoffACCConnectionPooling");
    private static Logger _logger = LogDomains.getLogger(ResourcePoolFactoryImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");

    public static ResourcePool newInstance(PoolInfo poolInfo, ConnectorConstants.PoolType poolType, Hashtable env) throws PoolingException {
        if (ConnectorRuntime.getRuntime().isACCRuntime() && "TRUE".equalsIgnoreCase(switchOffACCConnectionPoolingProperty)) {
            return new UnpooledResource(poolInfo, env);
        }
        if (poolType == ConnectorConstants.PoolType.POOLING_DISABLED) {
            return new UnpooledResource(poolInfo, env);
        }
        ConnectionPool pool = poolType == ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL ? new AssocWithThreadResourcePool(poolInfo, env) : new ConnectionPool(poolInfo, env);
        _logger.log(Level.FINE, "Created a pool of type: {0}", poolType);
        return pool;
    }
}

