/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.util.Map;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

class MapDeserializer
implements ModelDeserializer<JsonParser> {
    private final ModelDeserializer<JsonParser> keyDelegate;
    private final ModelDeserializer<JsonParser> valueDelegate;

    MapDeserializer(ModelDeserializer<JsonParser> keyDelegate, ModelDeserializer<JsonParser> valueDelegate) {
        this.keyDelegate = keyDelegate;
        this.valueDelegate = valueDelegate;
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContextImpl context) {
        Map map = (Map)context.getInstance();
        Object key = null;
        Object keyValue = null;
        String keyName = null;
        Mode mode = Mode.NONE;
        State state = State.NEXT;
        while (parser.hasNext()) {
            JsonParser.Event next = parser.next();
            context.setLastValueEvent(next);
            switch (next) {
                case KEY_NAME: {
                    Mode mode2 = mode = mode == Mode.NONE ? Mode.NORMAL : mode;
                    if (mode == Mode.NORMAL) {
                        keyValue = this.deserializeValue(parser, context, this.keyDelegate);
                    }
                    keyName = parser.getString();
                    break;
                }
                case START_OBJECT: {
                    mode = mode == Mode.NONE ? Mode.OBJECT : mode;
                }
                case START_ARRAY: 
                case VALUE_STRING: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER: 
                case VALUE_NULL: {
                    Object value;
                    if (mode == Mode.OBJECT) {
                        if (state == State.NEXT) {
                            state = State.KEY;
                            break;
                        }
                        if (state == State.KEY) {
                            this.validateKeyName(keyName, state);
                            key = this.deserializeValue(parser, context, this.keyDelegate);
                            state = State.VALUE;
                            break;
                        }
                        if (state == State.VALUE) {
                            this.validateKeyName(keyName, state);
                            value = this.deserializeValue(parser, context, this.valueDelegate);
                            map.put(key, value);
                            state = State.DONE;
                            break;
                        }
                        throw new JsonbException("Only attributes 'key' and 'value' allowed!");
                    }
                    value = this.deserializeValue(parser, context, this.valueDelegate);
                    map.put(keyValue, value);
                    break;
                }
                case END_OBJECT: {
                    state = State.NEXT;
                    if (mode == Mode.OBJECT) break;
                }
                case END_ARRAY: {
                    return map;
                }
                default: {
                    throw new JsonbException("Unexpected state: " + next);
                }
            }
        }
        return map;
    }

    private void validateKeyName(String keyName, State state) {
        if (state == State.KEY && !keyName.equals("key")) {
            throw new JsonbException("Attribute name has to be 'key' when representing map entry key. Got: " + keyName);
        }
        if (state == State.VALUE && !keyName.equals("value")) {
            throw new JsonbException("Attribute name has to be 'value' when representing map entry value. Got: " + keyName);
        }
    }

    private Object deserializeValue(JsonParser parser, DeserializationContextImpl context, ModelDeserializer<JsonParser> deserializer) {
        DeserializationContextImpl keyContext = new DeserializationContextImpl(context);
        return deserializer.deserialize(parser, keyContext);
    }

    private static enum Mode {
        NONE,
        NORMAL,
        OBJECT;

    }

    private static enum State {
        NEXT,
        VALUE,
        KEY,
        DONE;

    }
}

