/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.IOException;

public class NavigationHandlers {
    public void getUIViewRoot(HandlerContext context) {
        Object pageName = (String)context.getInputValue("id");
        FacesContext ctx = context.getFacesContext();
        UIViewRoot root = null;
        if (pageName == null) {
            root = ctx.getViewRoot();
        } else {
            if (((String)pageName).charAt(0) != '/') {
                pageName = "/" + (String)pageName;
            }
            root = ctx.getApplication().getViewHandler().createView(ctx, (String)pageName);
        }
        context.setOutputValue("viewRoot", root);
    }

    public static void getActionURL(HandlerContext handlerCtx) {
        String url = (String)handlerCtx.getInputValue("url");
        FacesContext ctx = handlerCtx.getFacesContext();
        handlerCtx.setOutputValue("result", ctx.getApplication().getViewHandler().getActionURL(ctx, url));
    }

    public static void getResourceURL(HandlerContext handlerCtx) {
        String url = (String)handlerCtx.getInputValue("url");
        FacesContext ctx = handlerCtx.getFacesContext();
        handlerCtx.setOutputValue("result", ctx.getApplication().getViewHandler().getResourceURL(ctx, url));
    }

    public static void navigate(HandlerContext context) {
        Object page = context.getInputValue("page");
        UIViewRoot root = null;
        FacesContext ctx = context.getFacesContext();
        if (page instanceof String) {
            Object strPage = (String)page;
            if (((String)strPage).charAt(0) != '/') {
                strPage = "/" + (String)strPage;
            }
            root = ctx.getApplication().getViewHandler().createView(ctx, (String)strPage);
        } else if (page instanceof UIViewRoot) {
            root = (UIViewRoot)page;
        } else {
            throw new IllegalArgumentException("Type '" + page.getClass().getName() + "' is not valid.  It must be a String or UIViewRoot.");
        }
        ctx.setViewRoot(root);
    }

    public static void redirect(HandlerContext context) {
        String page = (String)context.getInputValue("page");
        FacesContext ctx = context.getFacesContext();
        try {
            ctx.getExternalContext().redirect(page);
            ctx.responseComplete();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to navigate to page '" + page + "'!", ex);
        }
    }

    public static void dispatch(HandlerContext context) {
        String path = (String)context.getInputValue("path");
        FacesContext ctx = context.getFacesContext();
        try {
            ctx.getExternalContext().dispatch(path);
            ctx.responseComplete();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to navigate to path '" + path + "'!", ex);
        }
    }
}

