/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class PluginRebuilder
implements IStateDeltaListener,
IResourceChangeListener {
    private final Set<String> fProjectNames = new HashSet<String>();
    private boolean fTouchWorkspace = false;

    public void start() {
        PDECore.getDefault().getModelManager().addStateDeltaListener(this);
        JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)this, (int)8);
    }

    public void stop() {
        PDECore.getDefault().getModelManager().removeStateDeltaListener(this);
        JavaCore.removePreProcessingResourceChangedListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 8) {
            IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
            if (this.fTouchWorkspace) {
                IProject[] projects;
                IProject[] iProjectArray = projects = root.getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    this.touchProject(project);
                    ++n2;
                }
            } else {
                Iterator<String> iter = this.fProjectNames.iterator();
                while (iter.hasNext()) {
                    this.touchProject(root.getProject(iter.next()));
                }
            }
            this.fTouchWorkspace = false;
            this.fProjectNames.clear();
        }
    }

    private void touchProject(IProject project) {
        if (WorkspaceModelManager.isPluginProject(project) && !WorkspaceModelManager.isBinaryProject(project)) {
            try {
                project.setSessionProperty(PDECore.TOUCH_PROJECT, (Object)Boolean.TRUE);
                project.touch((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
        }
    }

    @Override
    public void stateChanged(State newState) {
        this.fTouchWorkspace = true;
        this.fProjectNames.clear();
    }

    @Override
    public void stateResolved(StateDelta delta) {
        if (delta == null) {
            this.fTouchWorkspace = true;
            this.fProjectNames.clear();
        } else {
            BundleDelta[] deltas;
            BundleDelta[] bundleDeltaArray = deltas = delta.getChanges();
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDelta bundleDelta = bundleDeltaArray[n2];
                int type = bundleDelta.getType();
                if ((type & 4) != 4 && (type & 1) != 1 && (type & 2) != 2) {
                    IResource resource;
                    IPluginModelBase model = PluginRegistry.findModel(bundleDelta.getBundle());
                    IResource iResource = resource = model == null ? null : model.getUnderlyingResource();
                    if (resource != null) {
                        this.fProjectNames.add(resource.getProject().getName());
                    }
                }
                ++n2;
            }
        }
    }
}

