/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClasspathUtil {
    public static IClasspathEntry findProjectSourcePath(IJavaProject jp, IFolder folder) throws JavaModelException {
        IClasspathEntry[] cp = jp.getRawClasspath();
        IClasspathEntry searchingFor = JavaCore.newSourceEntry((IPath)folder.getFullPath());
        IPath searchingForPath = searchingFor.getPath();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getPath().equals((Object)searchingForPath)) {
                return cp[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean doesClasspathContainEntry(IJavaProject jp, IClasspathEntry[] cp, IPath path, IProgressMonitor progressMonitor) throws JavaModelException {
        if (cp == null) {
            cp = jp.getRawClasspath();
        }
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void removeFromProjectClasspath(IJavaProject jp, IFolder folder, IProgressMonitor progressMonitor) throws JavaModelException {
        IPath workspaceRelativePath;
        IClasspathEntry[] cp = jp.getRawClasspath();
        boolean found = ClasspathUtil.doesClasspathContainEntry(jp, cp, workspaceRelativePath = folder.getFullPath(), progressMonitor);
        if (found) {
            IPath projectRelativePath = folder.getProjectRelativePath().addTrailingSeparator();
            int j = 0;
            int i = 0;
            while (i < cp.length) {
                if (!cp[i].getPath().equals((Object)workspaceRelativePath)) {
                    IPath[] oldExclusions = cp[i].getExclusionPatterns();
                    int m = 0;
                    int k = 0;
                    while (k < oldExclusions.length) {
                        if (!oldExclusions[k].equals((Object)projectRelativePath)) {
                            oldExclusions[m] = oldExclusions[k];
                            ++m;
                        }
                        ++k;
                    }
                    if (oldExclusions.length == m) {
                        cp[j] = cp[i];
                    } else {
                        IPath[] newExclusions = new IPath[m];
                        System.arraycopy(oldExclusions, 0, newExclusions, 0, m);
                        cp[j] = JavaCore.newSourceEntry((IPath)cp[i].getPath(), (IPath[])cp[i].getInclusionPatterns(), (IPath[])newExclusions, (IPath)cp[i].getOutputLocation(), (IClasspathAttribute[])cp[i].getExtraAttributes());
                    }
                    ++j;
                }
                ++i;
            }
            IClasspathEntry[] newCp = new IClasspathEntry[j];
            System.arraycopy(cp, 0, newCp, 0, j);
            jp.setRawClasspath(newCp, progressMonitor);
            if (AptPlugin.DEBUG) {
                AptPlugin.trace("removed " + workspaceRelativePath + " from classpath");
            }
        }
    }

    public static boolean updateProjectClasspath(IJavaProject jp, IFolder folder, IProgressMonitor progressMonitor, boolean isTestCode, IPath specificOutputLocation) throws JavaModelException {
        IPath path;
        IClasspathEntry[] cp = jp.getRawClasspath();
        boolean found = ClasspathUtil.doesClasspathContainEntry(jp, cp, path = folder.getFullPath(), progressMonitor);
        if (!found) {
            ArrayList<IPath> exclusions = new ArrayList<IPath>();
            int i = 0;
            while (i < cp.length) {
                if (cp[i].getPath().isPrefixOf(path)) {
                    IPath projectRelativePath = folder.getProjectRelativePath().addTrailingSeparator();
                    IPath[] oldExclusions = cp[i].getExclusionPatterns();
                    boolean add = true;
                    int j = 0;
                    while (j < oldExclusions.length) {
                        if (oldExclusions[j].equals((Object)projectRelativePath)) {
                            add = false;
                        }
                        ++j;
                    }
                    if (add) {
                        IPath[] newExclusions;
                        if (cp[i].getExclusionPatterns() == null) {
                            newExclusions = new IPath[1];
                        } else {
                            newExclusions = new IPath[oldExclusions.length + 1];
                            System.arraycopy(oldExclusions, 0, newExclusions, 0, oldExclusions.length);
                        }
                        newExclusions[newExclusions.length - 1] = projectRelativePath;
                        cp[i] = JavaCore.newSourceEntry((IPath)cp[i].getPath(), (IPath[])cp[i].getInclusionPatterns(), (IPath[])newExclusions, (IPath)cp[i].getOutputLocation(), (IClasspathAttribute[])cp[i].getExtraAttributes());
                    }
                } else if (path.isPrefixOf(cp[i].getPath())) {
                    exclusions.add(cp[i].getPath().addTrailingSeparator());
                }
                ++i;
            }
            IPath[] exclusionPatterns = exclusions.toArray(new IPath[exclusions.size()]);
            IClasspathAttribute[] attrs = new IClasspathAttribute[isTestCode ? 2 : 1];
            attrs[0] = JavaCore.newClasspathAttribute((String)"optional", (String)Boolean.toString(true));
            if (isTestCode) {
                attrs[1] = JavaCore.newClasspathAttribute((String)"test", (String)Boolean.toString(true));
            }
            IClasspathEntry generatedSourceClasspathEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath(), (IPath[])new IPath[0], (IPath[])exclusionPatterns, (IPath)specificOutputLocation, (IClasspathAttribute[])attrs);
            IClasspathEntry[] newCp = new IClasspathEntry[cp.length + 1];
            System.arraycopy(cp, 0, newCp, 0, cp.length);
            newCp[newCp.length - 1] = generatedSourceClasspathEntry;
            jp.setRawClasspath(newCp, progressMonitor);
        }
        return !found;
    }

    public static IPath findTestOutputLocation(IClasspathEntry[] cp) {
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IPath outputLocation;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.isTest() && (outputLocation = entry.getOutputLocation()) != null) {
                return outputLocation;
            }
            ++n2;
        }
        return null;
    }

    private ClasspathUtil() {
    }
}

