/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.ecore2xtext;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.wizard.Ecore2XtextConfiguration;
import org.eclipse.xtext.xtext.wizard.ecore2xtext.UniqueNameUtil;

public class Ecore2XtextExtensions {
    public static Iterable<EClassifier> allConcreteRuleClassifiers(Ecore2XtextConfiguration it) {
        if (it.getRootElementClass() == null) {
            return Iterables.filter((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)Iterables.transform(it.getEPackageInfos(), p -> Ecore2XtextExtensions.allReferencedClassifiers(p.getEPackage(), false)))), c -> Ecore2XtextExtensions.needsConcreteRule(c));
        }
        ArrayList c2 = Lists.newArrayList((Object[])new EClassifier[]{(EClassifier)EClassifier.class.cast(it.getRootElementClass())});
        Ecore2XtextExtensions.allAssignedClassifiers(it.getRootElementClass(), c2);
        return IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)c2, cl -> Ecore2XtextExtensions.needsConcreteRule(cl)));
    }

    public static Collection<EClass> allDispatcherRuleClasses(Ecore2XtextConfiguration it) {
        if (it.getRootElementClass() == null) {
            return IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)Iterables.transform(it.getEPackageInfos(), p -> Ecore2XtextExtensions.allReferencedClassifiers(p.getEPackage(), false)))), c -> Ecore2XtextExtensions.needsDispatcherRule(c)), EClass.class));
        }
        Function toTypes = c -> Iterables.transform((Iterable)Iterables.filter((Iterable)c.getEAllReferences(), r -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)r)), ETypedElement::getEType);
        return IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter(Ecore2XtextExtensions.allConcreteRuleClassifiers(it), EClass.class), (Function)toTypes)), EClass.class));
    }

    public static Collection<EPackage> allReferencedEPackages(Ecore2XtextConfiguration prjInfo) {
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)Iterables.transform(prjInfo.getEPackageInfos(), it -> Ecore2XtextExtensions.allReferencedEPackages(it.getEPackage(), true))));
    }

    public static Set<EPackage> allReferencedEPackages(EPackage ePack, boolean includeCrossRefs) {
        return IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)Iterables.transform(Ecore2XtextExtensions.allReferencedClassifiers(ePack, includeCrossRefs), EClassifier::getEPackage)));
    }

    public static Set<EClassifier> allReferencedClassifiers(EPackage ePack, boolean includeCrossRefs) {
        Iterable strFeatures = Iterables.transform((Iterable)Iterables.filter((Iterable)ePack.getEClassifiers(), EClass.class), it -> Iterables.filter((Iterable)it.getEAllStructuralFeatures(), f -> Ecore2XtextExtensions.needsAssignment(f) && (includeCrossRefs || Ecore2XtextExtensions.isContainment(f))));
        Set refTypes = IterableExtensions.toSet((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)strFeatures), it -> it.getEType()));
        Set retVal = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ePack.getEClassifiers(), (Iterable)refTypes));
        retVal.add(UniqueNameUtil.eString());
        return retVal;
    }

    private static void allAssignedClassifiers(EClass eClazz, Collection<EClassifier> acceptor) {
        List classifiers = IterableExtensions.toList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)eClazz.getEAllStructuralFeatures(), f -> Ecore2XtextExtensions.needsAssignment(f)), it -> it.getEType()));
        Iterables.addAll((Collection)classifiers, Ecore2XtextExtensions.subClasses(eClazz));
        classifiers.removeAll(acceptor);
        if (classifiers.isEmpty()) {
            return;
        }
        Iterables.addAll(acceptor, (Iterable)classifiers);
        Iterables.filter((Iterable)classifiers, EClass.class).forEach(c -> Ecore2XtextExtensions.allAssignedClassifiers(c, acceptor));
    }

    public static String fqn(EClassifier it) {
        EPackage ePackage = it.getEPackage();
        String uniqueName = null;
        if (ePackage != null) {
            uniqueName = UniqueNameUtil.uniqueName((ENamedElement)ePackage);
        }
        if (uniqueName == null) {
            return Ecore2XtextExtensions.quoteIfNeccesary(it.getName());
        }
        return UniqueNameUtil.uniqueName((ENamedElement)it.getEPackage()) + "::" + Ecore2XtextExtensions.quoteIfNeccesary(it.getName());
    }

    public static Iterable<EStructuralFeature> prefixFeatures(EClass it) {
        return Iterables.filter((Iterable)it.getEAllStructuralFeatures(), f -> Ecore2XtextExtensions.needsAssignment(f) && Ecore2XtextExtensions.isPrefixBooleanFeature(f));
    }

    public static Iterable<EStructuralFeature> inlinedFeatures(EClass it) {
        List features = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)it.getEAllStructuralFeatures(), f -> Ecore2XtextExtensions.needsAssignment(f)));
        features.remove(Ecore2XtextExtensions.idAttribute(it));
        features.removeAll(IterableExtensions.toList(Ecore2XtextExtensions.prefixFeatures(it)));
        return features;
    }

    public static boolean onlyOptionalFeatures(EClass it) {
        Iterable features = Iterables.concat(Ecore2XtextExtensions.prefixFeatures(it), Ecore2XtextExtensions.inlinedFeatures(it));
        return Iterables.isEmpty((Iterable)Iterables.filter((Iterable)features, f -> f.isRequired()));
    }

    public static String assignedRuleCall(EAttribute it) {
        if (Ecore2XtextExtensions.isPrefixBooleanFeature((EStructuralFeature)it)) {
            return "'" + it.getName() + "'";
        }
        return UniqueNameUtil.uniqueName((ENamedElement)it.getEType());
    }

    public static String concreteRuleName(EClass it) {
        if (Ecore2XtextExtensions.needsDispatcherRule((EClassifier)it)) {
            return UniqueNameUtil.uniqueImplName((ENamedElement)it);
        }
        return UniqueNameUtil.uniqueName((ENamedElement)it);
    }

    public static String dataTypeRuleBody(EDataType it) {
        String name = it.getName();
        if (name != null) {
            switch (name) {
                case "EBigDecimal": {
                    return "INT? '.' INT";
                }
                case "EBigInteger": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EBoolean": {
                    return Ecore2XtextExtensions.booleanRuleBody();
                }
                case "EBooleanObject": {
                    return Ecore2XtextExtensions.booleanRuleBody();
                }
                case "EByte": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EByteObject": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EChar": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "ECharObject": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EDouble": {
                    return Ecore2XtextExtensions.decimalRuleBody();
                }
                case "EDoubleObject": {
                    return Ecore2XtextExtensions.decimalRuleBody();
                }
                case "EFloat": {
                    return Ecore2XtextExtensions.decimalRuleBody();
                }
                case "EFloatObject": {
                    return Ecore2XtextExtensions.decimalRuleBody();
                }
                case "EInt": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EIntegerObject": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "ELong": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "ELongObject": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EShort": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EShortObject": {
                    return Ecore2XtextExtensions.intRuleBody();
                }
                case "EString": {
                    return "STRING | ID";
                }
            }
            return "'" + it.getName() + "' /* TODO: implement this rule and an appropriate IValueConverter */";
        }
        return "'" + it.getName() + "' /* TODO: implement this rule and an appropriate IValueConverter */";
    }

    public static String intRuleBody() {
        return "'-'? INT";
    }

    public static String decimalRuleBody() {
        return "'-'? INT? '.' INT (('E'|'e') '-'? INT)?";
    }

    public static String booleanRuleBody() {
        return "'true' | 'false'";
    }

    public static String assignmentKeyword(EStructuralFeature it) {
        if (Ecore2XtextExtensions.isPrefixBooleanFeature(it)) {
            return "";
        }
        return "'" + it.getName() + "' ";
    }

    public static String quoteIfNeccesary(String str) {
        if (Ecore2XtextExtensions.isXtextKeyword(str)) {
            return "^" + str;
        }
        return str;
    }

    public static boolean isXtextKeyword(String str) {
        return Lists.newArrayList((Object[])new String[]{"returns", "generate", "terminal", "with", "hidden", "enum", "grammar", "import", "as", "current", "fragment", "EOF"}).contains(str);
    }

    public static EAttribute idAttribute(EClass it) {
        EAttribute idAttr = Ecore2XtextExtensions.idAttributeInternal(it);
        if (idAttr != null) {
            return idAttr;
        }
        return (EAttribute)IterableExtensions.findFirst((Iterable)it.getEAllAttributes(), a -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a) && "name".equals(a.getName()) && "EString".equals(a.getEType().getName()) && !a.isMany());
    }

    private static EAttribute idAttributeInternal(EClass it) {
        return (EAttribute)IterableExtensions.findFirst((Iterable)it.getEAllAttributes(), a -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a) && a.isID());
    }

    public static boolean isBoolean(EClassifier it) {
        return it instanceof EDataType && Lists.newArrayList((Object[])new String[]{"EBoolean", "EBooleanObject"}).contains(it.getName()) && Ecore2XtextExtensions.isEcoreType(it);
    }

    public static boolean isPrefixBooleanFeature(EStructuralFeature it) {
        return Ecore2XtextExtensions.isBoolean(it.getEType()) && !it.isMany() && !Objects.equal((Object)it.getDefaultValueLiteral(), (Object)"true");
    }

    public static boolean isString(EClassifier it) {
        return it instanceof EDataType && Objects.equal((Object)it.getName(), (Object)"EString") && Ecore2XtextExtensions.isEcoreType(it);
    }

    public static boolean isEcoreType(EClassifier it) {
        EPackage ePackage = it.getEPackage();
        String nsURI = null;
        if (ePackage != null) {
            nsURI = ePackage.getNsURI();
        }
        return "http://www.eclipse.org/emf/2002/Ecore".equals(nsURI);
    }

    public static boolean isID(EStructuralFeature it) {
        return it instanceof EAttribute && ((EAttribute)EAttribute.class.cast(it)).isID();
    }

    public static boolean needsAssignment(EStructuralFeature it) {
        return !(!it.isChangeable() || it.isDerived() || it.isTransient() || it instanceof EReference && ((EReference)EReference.class.cast(it)).isContainer() || it.getEType() instanceof EDataType && !((EDataType)EDataType.class.cast(it.getEType())).isSerializable());
    }

    public static boolean needsConcreteRule(EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            return !eClass.isAbstract() && !eClass.isInterface();
        }
        return true;
    }

    public static boolean needsDispatcherRule(EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            return !Iterables.isEmpty((Iterable)Iterables.filter(Ecore2XtextExtensions.subClasses((EClass)eClassifier), c -> Ecore2XtextExtensions.needsConcreteRule((EClassifier)c)));
        }
        return false;
    }

    public static boolean isContainment(EStructuralFeature eStrFeat) {
        if (eStrFeat instanceof EAttribute) {
            return true;
        }
        if (eStrFeat instanceof EReference) {
            return ((EReference)eStrFeat).isContainment();
        }
        return false;
    }

    public static Iterable<EClass> subClasses(EClass it) {
        if (it.getEPackage() == null) {
            return Collections.emptyList();
        }
        return Iterables.filter((Iterable)Iterables.filter((Iterable)it.getEPackage().getEClassifiers(), EClass.class), c -> c.getEAllSuperTypes().contains((Object)it));
    }

    public static Iterable<EAttribute> allAttributes(EClass it) {
        return Iterables.filter(Ecore2XtextExtensions.inlinedFeatures(it), EAttribute.class);
    }

    public static Iterable<EReference> allCrossReferences(EClass it) {
        return Iterables.filter((Iterable)Iterables.filter(Ecore2XtextExtensions.inlinedFeatures(it), EReference.class), f -> !f.isContainment());
    }

    public static Iterable<EReference> allContainmentReferences(EClass it) {
        return Iterables.filter((Iterable)Iterables.filter(Ecore2XtextExtensions.inlinedFeatures(it), EReference.class), f -> f.isContainment());
    }
}

