/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertNull {
    private AssertNull() {
    }

    static void assertNull(Object actual) {
        AssertNull.assertNull(actual, (String)null);
    }

    static void assertNull(Object actual, String message) {
        if (actual != null) {
            AssertNull.failNotNull(actual, message);
        }
    }

    static void assertNull(Object actual, Supplier<String> messageSupplier) {
        if (actual != null) {
            AssertNull.failNotNull(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    private static void failNotNull(Object actual, String message) {
        String stringRepresentation = actual.toString();
        if (stringRepresentation == null || stringRepresentation.equals("null")) {
            AssertionUtils.fail(AssertionUtils.format(null, actual, message), null, actual);
        } else {
            AssertionUtils.fail(AssertionUtils.buildPrefix(message) + "expected: <null> but was: <" + actual + ">", null, actual);
        }
    }
}

