/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.UnknownProjectConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class WorkspaceConfig
implements IWorkspaceConfig {
    private final UnknownProjectConfig unknown = new UnknownProjectConfig(this);
    private final Map<String, IProjectConfig> projects = new LinkedHashMap<String, IProjectConfig>();

    public WorkspaceConfig(IProjectConfig ... initialProjects) {
        this.addProject(this.unknown);
        for (IProjectConfig p : initialProjects) {
            this.addProject(p);
        }
    }

    @Override
    public Set<? extends IProjectConfig> getProjects() {
        return IterableExtensions.toSet(this.projects.values());
    }

    public void addProject(IProjectConfig project) {
        this.projects.put(project.getName(), project);
    }

    @Override
    public IProjectConfig findProjectByName(String name) {
        return this.projects.get(name);
    }

    @Override
    public IProjectConfig findProjectContaining(URI member) {
        return this.projects.values().stream().filter(projectCfg -> projectCfg.findSourceFolderContaining(member) != null).max((cfg1, cfg2) -> cfg1.getPath().segmentCount() - cfg2.getPath().segmentCount()).orElse(this.unknown);
    }
}

