/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;

public class FileBufferOperationAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Set<Object> fResources;
    private IPath fLocation;
    private IWorkbenchWindow fWindow;
    protected IFileBufferOperation fFileBufferOperation;

    protected FileBufferOperationAction(IFileBufferOperation fileBufferOperation) {
        Assert.isNotNull((Object)fileBufferOperation);
        this.fFileBufferOperation = fileBufferOperation;
    }

    public void dispose() {
        this.fResources = null;
        this.fWindow = null;
        this.fFileBufferOperation = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IWorkbenchPart workbenchPart;
        IWorkbenchWindow window;
        Object adapter;
        this.fResources = new HashSet<Object>();
        this.fLocation = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                IAdaptable adaptable;
                if (element instanceof IResource) {
                    this.fResources.add(element);
                    continue;
                }
                if (!(element instanceof IAdaptable) || !((adapter = (adaptable = (IAdaptable)element).getAdapter(IResource.class)) instanceof IResource)) continue;
                this.fResources.add(adapter);
            }
        }
        if (selection instanceof ITextSelection && (window = this.getWorkbenchWindow()) != null && (workbenchPart = window.getPartService().getActivePart()) instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)workbenchPart;
            IEditorInput input = editorPart.getEditorInput();
            adapter = input.getAdapter(IResource.class);
            if (adapter instanceof IResource) {
                this.fResources.add(adapter);
            } else {
                adapter = input.getAdapter(ILocationProvider.class);
                if (adapter instanceof ILocationProvider) {
                    ILocationProvider provider = (ILocationProvider)adapter;
                    this.fLocation = provider.getPath(input);
                }
            }
        }
        action.setText(this.getText());
        action.setEnabled(!this.fResources.isEmpty() || this.fLocation != null);
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    protected final Shell getShell() {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        return window == null ? null : window.getShell();
    }

    public void run(IAction action) {
        if (this.fResources != null && !this.fResources.isEmpty()) {
            IFile[] files = this.collectFiles(this.fResources.toArray(new IResource[this.fResources.size()]));
            if (files != null && files.length > 0) {
                this.doRun(files, null, this.fFileBufferOperation);
            }
        } else if (this.isAcceptableLocation(this.fLocation)) {
            this.doRun(null, this.fLocation, this.fFileBufferOperation);
        }
    }

    protected IFile[] collectFiles(IResource[] resources) {
        HashSet<IResource> files = new HashSet<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if ((1 & resource.getType()) > 0) {
                files.add(resource);
            }
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    protected final void doRun(final IFile[] files, final IPath location, final IFileBufferOperation fileBufferOperation) {
        Job job = new Job(fileBufferOperation.getOperationName()){

            protected IStatus run(IProgressMonitor monitor) {
                Status status;
                try {
                    IPath[] locations;
                    int ticks = 100;
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)FileBufferOperationAction.this.fFileBufferOperation.getOperationName(), (int)ticks);
                    if (files != null) {
                        ticks -= 30;
                        locations = FileBufferOperationAction.this.generateLocations(files, (IProgressMonitor)subMonitor.split(30));
                    } else {
                        locations = new IPath[]{location};
                    }
                    if (locations != null && locations.length > 0) {
                        FileBufferOperationRunner runner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), (Object)FileBufferOperationAction.this.getShell());
                        runner.execute(locations, fileBufferOperation, (IProgressMonitor)subMonitor.split(ticks));
                    }
                    status = Status.OK_STATUS;
                }
                catch (OperationCanceledException operationCanceledException) {
                    status = new Status(8, "org.eclipse.ui.editors", 0, "", null);
                }
                catch (CoreException e) {
                    status = new Status(4, "org.eclipse.ui.editors", 0, "", (Throwable)e);
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected final IPath[] generateLocations(IFile[] files, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(TextEditorMessages.FileBufferOperationAction_collectionFiles_label, files.length);
        try {
            HashSet<IPath> locations = new HashSet<IPath>();
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                IPath fullPath = file.getFullPath();
                if (this.isAcceptableLocation(fullPath)) {
                    locations.add(fullPath);
                }
                progressMonitor.worked(1);
                ++n2;
            }
            IPath[] iPathArray = locations.toArray(new IPath[locations.size()]);
            return iPathArray;
        }
        finally {
            progressMonitor.done();
        }
    }

    protected boolean isAcceptableLocation(IPath location) {
        return true;
    }
}

