/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;
import org.eclipse.pde.internal.ui.correction.Messages;

public class ReplaceExecEnvironment
extends AbstractManifestMarkerResolution {
    String fRequiredEE;

    public ReplaceExecEnvironment(int type, IMarker marker) {
        super(type, marker);
        this.fRequiredEE = this.marker.getAttribute("executionEnvironment.key", "JavaSE-1.8");
    }

    public String getLabel() {
        return NLS.bind((String)Messages.ReplaceExecEnvironment_Marker_Label, (Object)this.fRequiredEE);
    }

    @Override
    protected void createChange(BundleModel model) {
        IManifestHeader header = model.getBundle().getManifestHeader("Bundle-RequiredExecutionEnvironment");
        if (header instanceof RequiredExecutionEnvironmentHeader) {
            IExecutionEnvironment[] systemEnvs;
            RequiredExecutionEnvironmentHeader reqHeader = (RequiredExecutionEnvironmentHeader)header;
            ExecutionEnvironment[] bundleEnvs = reqHeader.getEnvironments();
            IExecutionEnvironment[] iExecutionEnvironmentArray = systemEnvs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            int n = systemEnvs.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment systemEnv = iExecutionEnvironmentArray[n2];
                if (systemEnv.getId().equals(this.fRequiredEE)) {
                    ExecutionEnvironment[] executionEnvironmentArray = bundleEnvs;
                    int n3 = bundleEnvs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExecutionEnvironment bundleEnv = executionEnvironmentArray[n4];
                        reqHeader.removeExecutionEnvironment(bundleEnv);
                        ++n4;
                    }
                    reqHeader.addExecutionEnvironment(systemEnv);
                }
                ++n2;
            }
        }
    }
}

