/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.ui.dialogs.SearchPattern;

public class PaletteFilter {
    private final TypeLibrary typeLib;
    private final FBNetwork hostNetwork;
    private final SearchPattern matcher = new SearchPattern();

    public PaletteFilter(TypeLibrary typeLib, FBNetwork hostNetwork) {
        this.typeLib = typeLib;
        this.hostNetwork = hostNetwork;
    }

    public List<TypeEntry> findFBAndSubappTypes(String searchString) {
        return this.sortResultsByBestMatch(searchString, this.findTypes(searchString, this.getTypeStream())).toList();
    }

    private Stream<TypeEntry> getTypeStream() {
        if (this.hostNetwork == null) {
            return Stream.concat(this.typeLib.getFbTypes().stream(), this.typeLib.getSubAppTypes().stream());
        }
        EObject host = this.hostNetwork.eContainer();
        Stream<SubAppTypeEntry> stream = host instanceof CompositeFBType && !(host instanceof SubAppType) ? this.typeLib.getFbTypes().stream().map(TypeEntry.class::cast) : Stream.concat(this.typeLib.getFbTypes().stream(), this.typeLib.getSubAppTypes().stream());
        TypeEntry selfEntry = ((LibraryElement)host).getTypeEntry();
        return stream.filter(te -> te != selfEntry);
    }

    private Stream<TypeEntry> findTypes(String searchString, Stream<TypeEntry> stream) {
        this.setSearchPattern(searchString);
        return stream.filter(entry -> this.matcher.matches(entry.getFullTypeName())).filter(entry -> entry.getType() != null);
    }

    private void setSearchPattern(String searchString) {
        Object searchPattern = searchString;
        if (!searchString.endsWith(" ")) {
            searchPattern = (String)searchPattern + "*";
        }
        searchPattern = "*" + (String)searchPattern;
        this.matcher.setPattern((String)searchPattern);
    }

    private Stream<TypeEntry> sortResultsByBestMatch(String searchString, Stream<TypeEntry> results) {
        String searchPattern = searchString;
        List<TypeEntry> sortedResults = results.sorted(Comparator.comparing(TypeEntry::getTypeName)).toList();
        ArrayList<TypeEntry> exact = new ArrayList<TypeEntry>();
        ArrayList<TypeEntry> right = new ArrayList<TypeEntry>();
        ArrayList<TypeEntry> rest = new ArrayList<TypeEntry>();
        for (TypeEntry entry : sortedResults) {
            this.matcher.setPattern(searchPattern);
            if (this.matcher.matches(entry.getTypeName())) {
                exact.add(entry);
                continue;
            }
            this.matcher.setPattern(searchPattern + "*");
            if (this.matcher.matches(entry.getTypeName())) {
                right.add(entry);
                continue;
            }
            rest.add(entry);
        }
        return Stream.of(exact, right, rest).flatMap(Collection::stream);
    }
}

