/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.StructDataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;
import org.eclipse.gef.commands.Command;

public abstract class AbstractConnectionCreateCommand
extends Command
implements ConnectionLayoutTagger,
ScopedCommand {
    private final ConnectionRoutingData routingData;
    private FBNetwork parent;
    private Connection connection;
    private IInterfaceElement source;
    private IInterfaceElement destination;
    private boolean performMappingCheck;
    private AbstractConnectionCreateCommand mirroredConnection;
    private boolean visible = true;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private int elementIndex = -1;

    protected AbstractConnectionCreateCommand(FBNetwork parent) {
        this.parent = parent;
        this.performMappingCheck = true;
        this.routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
    }

    public void setArrangementConstraints(ConnectionRoutingData routingData) {
        this.routingData.setDx1(routingData.getDx1());
        this.routingData.setDx2(routingData.getDx1());
        this.routingData.setDy(routingData.getDy());
    }

    public void setSource(IInterfaceElement source) {
        this.source = source;
    }

    public IInterfaceElement getSource() {
        return this.source;
    }

    public void setDestination(IInterfaceElement target) {
        this.destination = target;
    }

    public IInterfaceElement getDestination() {
        return this.destination;
    }

    public void setParent(FBNetwork parent) {
        this.parent = parent;
    }

    public FBNetwork getParent() {
        return this.parent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean canExecute() {
        return this.parent != null && this.source != null && this.destination != null && this.source != this.destination && this.canExecuteConType();
    }

    public void execute() {
        this.checkSourceAndTarget();
        this.connection = this.createConnectionElement();
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.connection.setRoutingData(this.routingData);
        this.parent.addConnectionWithIndex(this.connection, this.elementIndex);
        this.connection.setVisible(this.visible);
        this.connection.getAttributes().addAll(EcoreUtil.copyAll(this.attributes));
        if (this.performMappingCheck) {
            this.mirroredConnection = this.checkAndCreateMirroredConnection();
            if (this.mirroredConnection != null) {
                this.mirroredConnection.execute();
            }
        }
    }

    public void undo() {
        if (this.mirroredConnection != null) {
            this.mirroredConnection.undo();
        }
        this.connection.setSource(null);
        this.connection.setDestination(null);
        this.parent.removeConnection(this.connection);
    }

    public void redo() {
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        this.parent.addConnectionWithIndex(this.connection, this.elementIndex);
        if (this.mirroredConnection != null) {
            this.mirroredConnection.redo();
        }
    }

    private void checkSourceAndTarget() {
        if (LinkConstraints.isSwapNeeded((IInterfaceElement)this.source, (FBNetwork)this.parent)) {
            IInterfaceElement buf = this.destination;
            this.destination = this.source;
            this.source = buf;
        }
    }

    protected abstract Connection createConnectionElement();

    private AbstractConnectionCreateCommand checkAndCreateMirroredConnection() {
        if (this.source.getBlockFBNetworkElement() != null && this.destination.getBlockFBNetworkElement() != null) {
            BlockFBNetworkElement opSource = this.source.getBlockFBNetworkElement().getOpposite();
            BlockFBNetworkElement opDestination = this.destination.getBlockFBNetworkElement().getOpposite();
            if (opSource != null && opDestination != null) {
                VarDeclaration varDeclaration;
                IInterfaceElement opDstIE;
                VarDeclaration varDeclaration2;
                IInterfaceElement opSrcIE = opSource.getInterface().getInterfaceElement(this.source);
                if (opSrcIE instanceof VarDeclaration && (varDeclaration2 = (VarDeclaration)opSrcIE).isInOutVar() && varDeclaration2.isIsInput()) {
                    opSrcIE = varDeclaration2.getInOutVarOpposite();
                }
                if ((opDstIE = opDestination.getInterface().getInterfaceElement(this.destination)) instanceof VarDeclaration && (varDeclaration = (VarDeclaration)opDstIE).isInOutVar() && !varDeclaration.isIsInput()) {
                    opDstIE = varDeclaration.getInOutVarOpposite();
                }
                if (this.requiresOppositeConnection((FBNetworkElement)opSource, (FBNetworkElement)opDestination, opSrcIE, opDstIE)) {
                    AbstractConnectionCreateCommand cmd = this.createMirroredConnectionCommand(opSource.getFbNetwork());
                    cmd.setPerformMappingCheck(false);
                    cmd.setSource(opSrcIE);
                    cmd.setDestination(opDstIE);
                    cmd.setVisible(this.visible);
                    cmd.setAttributes(this.attributes);
                    return cmd;
                }
            }
        }
        return null;
    }

    private boolean requiresOppositeConnection(FBNetworkElement opSource, FBNetworkElement opDestination, IInterfaceElement opSrcIE, IInterfaceElement opDstIE) {
        SubApp subApp;
        if (opSrcIE == null || opDstIE == null) {
            return false;
        }
        if (opSource.getFbNetwork() != opDestination.getFbNetwork()) {
            return false;
        }
        if (opSource == opDestination && opSource instanceof SubApp && (subApp = (SubApp)opSource).getSubAppNetwork() == this.getParent()) {
            return false;
        }
        return !LinkConstraints.duplicateConnection((IInterfaceElement)opSrcIE, (IInterfaceElement)opDstIE);
    }

    protected abstract AbstractConnectionCreateCommand createMirroredConnectionCommand(FBNetwork var1);

    protected abstract boolean canExecuteConType();

    public void setPerformMappingCheck(boolean performMappingCheck) {
        this.performMappingCheck = performMappingCheck;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes.addAll(attributes);
    }

    public static AbstractConnectionCreateCommand createCommand(FBNetwork network, IInterfaceElement connSrc, IInterfaceElement connDest) {
        if (AbstractConnectionCreateCommand.shouldStructDataConnCreationBeUsed(connSrc, connDest) || AbstractConnectionCreateCommand.shouldStructDataConnCreationBeUsed(connDest, connSrc)) {
            return new StructDataConnectionCreateCommand(network);
        }
        return AbstractConnectionCreateCommand.createCommand(connSrc, network);
    }

    public static boolean isStructManipulatorDefPin(IInterfaceElement pin) {
        if (!(pin instanceof VarDeclaration)) {
            return false;
        }
        BlockFBNetworkElement fbNE = pin.getBlockFBNetworkElement();
        return fbNE instanceof Demultiplexer && pin.isIsInput() || fbNE instanceof Multiplexer && !pin.isIsInput() || fbNE instanceof ConfigurableMoveFB;
    }

    public static boolean shouldStructDataConnCreationBeUsed(IInterfaceElement pin, IInterfaceElement other) {
        return AbstractConnectionCreateCommand.isStructManipulatorDefPin(pin) && other != null && AbstractConnectionCreateCommand.isSimpleStructPin(other);
    }

    public static boolean isSimpleStructPin(IInterfaceElement pin) {
        return pin.getType() instanceof StructuredType && !((VarDeclaration)pin).isArray();
    }

    private static AbstractConnectionCreateCommand createCommand(IInterfaceElement ie, FBNetwork network) {
        if (ie instanceof Event) {
            return new EventConnectionCreateCommand(network);
        }
        if (ie instanceof VarDeclaration) {
            return new DataConnectionCreateCommand(network);
        }
        return new AdapterConnectionCreateCommand(network);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Stream.of(this.parent, this.connection, this.source, this.destination).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    public void setElementIndex(int elementIndex) {
        this.elementIndex = elementIndex;
    }
}

