/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.zoom.IZoomScrollPolicy;
import org.eclipse.draw2d.zoom.MouseLocationZoomScrollPolicy;
import org.eclipse.fordiac.ide.gef.DiagramOutlinePage;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationModelEventDispatcher;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalViewerAnnotationModelEventDispatcher;
import org.eclipse.fordiac.ide.gef.dnd.ParameterDropTargetListener;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.handlers.AdvancedGraphicalViewerKeyHandler;
import org.eclipse.fordiac.ide.gef.preferences.GefPreferenceConstantsCache;
import org.eclipse.fordiac.ide.gef.print.PrintPreviewAction;
import org.eclipse.fordiac.ide.gef.ruler.FordiacRulerComposite;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.model.ui.editors.IContentEditorInput;
import org.eclipse.fordiac.ide.model.ui.preferences.IGraphicalPreferencesCache;
import org.eclipse.fordiac.ide.ui.editors.I4diacModelEditor;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class DiagramEditor
extends GraphicalEditor
implements ITabbedPropertySheetPageContributor,
I4diacModelEditor,
IReusableEditor {
    public static final int INITIAL_SCROLL_OFFSET = 5;
    public static final String PROPERTY_CONTRIBUTOR_ID = "org.eclipse.fordiac.ide.application.editors.DiagramEditor";
    private KeyHandler sharedKeyHandler;
    private DiagramOutlinePage outlinePage;
    private GraphicalAnnotationModel annotationModel;
    private GraphicalViewerAnnotationModelEventDispatcher annotationModelEventDispatcher;

    protected DiagramEditor() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IContextService cs = (IContextService)site.getService(IContextService.class);
        cs.activateContext(this.getContextId());
    }

    protected String getContextId() {
        return "org.eclipse.fordiac.ide.gef";
    }

    public void setFocus() {
        super.setFocus();
        this.getGraphicalViewer().getRootEditPart().getChildren().forEach(EditPart::refresh);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer.getControl() instanceof FigureCanvas) {
            this.performInitialsationScroll(viewer);
        }
    }

    public void performInitialsationScroll(AdvancedScrollingGraphicalViewer viewer) {
        FigureCanvas canvas = (FigureCanvas)viewer.getControl();
        if (canvas != null && !canvas.isDisposed()) {
            viewer.flush();
            if (viewer.getSelectedEditParts().isEmpty()) {
                this.performUnselectedInitialisationScroll(viewer);
            } else {
                viewer.revealEditPart((EditPart)viewer.getSelectedEditParts().get(0));
            }
        }
    }

    private void performUnselectedInitialisationScroll(final AdvancedScrollingGraphicalViewer viewer) {
        final FigureCanvas canvas = (FigureCanvas)viewer.getControl();
        final GraphicalEditPart rootEditPart = (GraphicalEditPart)viewer.getRootEditPart();
        final IFigure figure = rootEditPart.getFigure();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (canvas != null && !canvas.isDisposed()) {
                    viewer.flush();
                    if (figure.isShowing() && !figure.getBounds().isEmpty()) {
                        Point scrollPos = DiagramEditor.this.getInitialScrollPos(rootEditPart);
                        canvas.scrollTo(scrollPos.x, scrollPos.y);
                    } else {
                        Display.getDefault().timerExec(50, (Runnable)this);
                    }
                }
            }
        });
    }

    protected Point getInitialScrollPos(GraphicalEditPart rootEditPart) {
        Rectangle drawingAreaBounds = rootEditPart.getContentPane().getBounds();
        return new Point(drawingAreaBounds.x - 5, drawingAreaBounds.y - 5);
    }

    protected void createGraphicalViewer(Composite parent) {
        FordiacRulerComposite rulerComp = new FordiacRulerComposite(parent, 0);
        GefPreferenceConstantsCache prefCache = this.getPreferenceConstantsCache();
        AdvancedScrollingGraphicalViewer viewer = new AdvancedScrollingGraphicalViewer((IGraphicalPreferencesCache)prefCache);
        viewer.createControl((Composite)rulerComp);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    private GefPreferenceConstantsCache getPreferenceConstantsCache() {
        IProject project = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IContentEditorInput) {
            IContentEditorInput contentInput = (IContentEditorInput)input;
            project = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(contentInput.getContent()).getProject();
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            project = fileInput.getFile().getProject();
        }
        return new GefPreferenceConstantsCache(project);
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = this.createRootEditPart();
        ContextMenuProvider cmp = this.getContextMenuProvider((ScrollingGraphicalViewer)viewer, root.getZoomManager());
        if (cmp != null) {
            viewer.setContextMenu((MenuManager)cmp);
            this.getSite().registerContextMenu("org.eclipse.fordiac.ide.gef.contextmenu", (MenuManager)cmp, (ISelectionProvider)viewer);
        }
        root.getZoomManager().setScrollPolicy((IZoomScrollPolicy)new MouseLocationZoomScrollPolicy(viewer.getControl()));
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.getEditPartFactory());
        AdvancedGraphicalViewerKeyHandler keyHandler = new AdvancedGraphicalViewerKeyHandler(viewer);
        keyHandler.setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler((KeyHandler)keyHandler);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    public ZoomManager getZoomManger() {
        return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
    }

    protected abstract EditPartFactory getEditPartFactory();

    protected abstract ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer var1, ZoomManager var2);

    protected abstract org.eclipse.jface.util.TransferDropTargetListener createTransferDropTargetListener();

    protected void initializeGraphicalViewer() {
        AdvancedScrollingGraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents(this.getModel());
        org.eclipse.jface.util.TransferDropTargetListener listener = this.createTransferDropTargetListener();
        if (listener != null) {
            viewer.addDropTargetListener(this.createTransferDropTargetListener());
        }
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        viewer.addDropTargetListener((TransferDropTargetListener)new ParameterDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        this.addAnnotationModelDispatcher();
    }

    protected void addAnnotationModelDispatcher() {
        if (this.annotationModel != null && this.getGraphicalViewer() != null) {
            this.annotationModelEventDispatcher = new FordiacAnnotationModelEventDispatcher(this.getPartName(), (GraphicalViewer)this.getGraphicalViewer(), this.annotationModel);
        }
    }

    protected void removeAnnotationModelDispatcher() {
        if (this.annotationModelEventDispatcher != null) {
            this.annotationModelEventDispatcher.dispose();
            this.annotationModelEventDispatcher = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(IEditorInput input) {
        IWorkbenchPartSite iWorkbenchPartSite;
        void contentEI;
        if (!(input instanceof IContentEditorInput)) {
            throw new IllegalArgumentException("Diagram editors only accept IContentEditorInput as valid inputs!");
        }
        IContentEditorInput iContentEditorInput = (IContentEditorInput)input;
        IContentEditorInput currentEditorInput = (IContentEditorInput)this.getEditorInput();
        if (currentEditorInput != null && currentEditorInput.getContent() != contentEI.getContent()) {
            throw new IllegalArgumentException("Editor input with new content given to diagram editor. This is currently not supported!");
        }
        if (this.getEditorInput() == null) {
            this.setupEditDomain();
        }
        if ((iWorkbenchPartSite = this.getSite()) instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            this.removeAnnotationModelDispatcher();
            this.annotationModel = (GraphicalAnnotationModel)multiPageEditorSite.getMultiPageEditor().getAdapter(GraphicalAnnotationModel.class);
            this.addAnnotationModelDispatcher();
        }
        super.setInputWithNotify(input);
    }

    private void setupEditDomain() {
        CommandStack commandStack;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            commandStack = (CommandStack)multiPageEditorSite.getMultiPageEditor().getAdapter(CommandStack.class);
        } else {
            commandStack = new CommandStack();
        }
        CommandStack commandStack2 = commandStack;
        DefaultEditDomain editDomain = this.createEditDomain();
        editDomain.setCommandStack(commandStack2);
        editDomain.setDefaultTool((Tool)this.createDefaultTool());
        editDomain.setActiveTool(editDomain.getDefaultTool());
        this.setEditDomain(editDomain);
    }

    protected DefaultEditDomain createEditDomain() {
        return new DefaultEditDomain((IEditorPart)this);
    }

    protected AdvancedPanningSelectionTool createDefaultTool() {
        return new AdvancedPanningSelectionTool();
    }

    public abstract AutomationSystem getSystem();

    public abstract String getFileName();

    public abstract void doSave(IProgressMonitor var1);

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public <T> T getAdapter(Class<T> type) {
        if (type == ZoomManager.class) {
            return type.cast(this.getGraphicalViewer().getProperty(ZoomManager.class.toString()));
        }
        if (type == IContentOutlinePage.class) {
            this.outlinePage = new DiagramOutlinePage((GraphicalViewer)this.getGraphicalViewer());
            return type.cast((Object)this.outlinePage);
        }
        if (type == IPropertySheetPage.class) {
            return type.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (type == GraphicalAnnotationModel.class) {
            return type.cast(this.annotationModel);
        }
        return (T)super.getAdapter(type);
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        super.createActions();
        registry.removeAction(registry.getAction((Object)ActionFactory.PRINT.getId()));
        action = new PrintPreviewAction((GraphicalViewer)this.getGraphicalViewer());
        registry.registerAction((IAction)action);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)action);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
    }

    public void dispose() {
        this.outlinePage = null;
        this.removeAnnotationModelDispatcher();
        super.dispose();
    }

    public GraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    public String getContributorId() {
        return PROPERTY_CONTRIBUTOR_ID;
    }

    protected AdvancedScrollingGraphicalViewer getGraphicalViewer() {
        return (AdvancedScrollingGraphicalViewer)super.getGraphicalViewer();
    }
}

