/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.opcua.helpers;

import java.util.AbstractMap;
import java.util.Map;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class Constants {
    public static final NodeId MGMT_NODE = new NodeId(1, "IEC61499Mgmt");
    public static final NodeId CREATE_RESOURCE_NODE = new NodeId(1, "createResource");
    public static final NodeId CREATE_FB_NODE = new NodeId(1, "createFB");
    public static final NodeId CREATE_CONNECTION_NODE = new NodeId(1, "createConnection");
    public static final NodeId WRITE_DEVICE_NODE = new NodeId(1, "writeDevice");
    public static final NodeId WRITE_RESOURCE_NODE = new NodeId(1, "writeResource");
    public static final NodeId WRITE_FB_NODE = new NodeId(1, "writeFB");
    public static final NodeId START_DEVICE_NODE = new NodeId(1, "startDevice");
    public static final NodeId START_RESOURCE_NODE = new NodeId(1, "startResource");
    public static final NodeId START_FB_NODE = new NodeId(1, "startFB");
    public static final NodeId KILL_DEVICE_NODE = new NodeId(1, "killDevice");
    public static final NodeId KILL_RESOURCE_NODE = new NodeId(1, "killResource");
    public static final NodeId DELETE_RESOURCE_NODE = new NodeId(1, "deleteResource");
    public static final NodeId DELETE_FB_NODE = new NodeId(1, "deleteFB");
    public static final NodeId DELETE_CONNECTION_NODE = new NodeId(1, "deleteConnection");
    public static final NodeId ADD_WATCH_NODE = new NodeId(1, "addWatch");
    public static final NodeId READ_WATCHES_NODE = new NodeId(1, "readWatches");
    public static final NodeId REMOVE_WATCH_NODE = new NodeId(1, "removeWatch");
    public static final NodeId TRIGGER_EVENT_NODE = new NodeId(1, "triggerEvent");
    public static final NodeId FORCE_VALUE_NODE = new NodeId(1, "forceValue");
    public static final NodeId CLEAR_FORCE_NODE = new NodeId(1, "clearForce");
    public static final NodeId QUERY_RESOURCES_NODE = new NodeId(1, "queryResources");
    public static final NodeId QUERY_FB_TYPE_NODE = new NodeId(1, "queryFBType");
    public static final NodeId QUERY_DATA_TYPE_NODE = new NodeId(1, "queryDataType");
    public static final NodeId QUERY_GLOBAL_CONST_TYPE_NODE = new NodeId(1, "queryGlobalConstType");
    public static final NodeId READ_TRACES_NODE = new NodeId(1, "Read Traces");
    public static final NodeId REPLAY_NEXT_EVENT_NODE = new NodeId(1, "Replay Next Event");
    public static final String CREATE_RESOURCE_INSTANCE = "<Request Action=\"CREATE RESOURCE\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>";
    public static final String CREATE_FB_INSTANCE = "<Request Action=\"CREATE FB\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>";
    public static final String CREATE_CONNECTION = "<Request Action=\"CREATE CONNECTION\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>";
    public static final String WRITE_DEVICE_PARAMETER = "<Request Action=\"WRITE DEVICE\"><Name=\"{0}\" Value=\"{1}\" /></Request>";
    public static final String WRITE_RESOURCE_PARAMETER = "<Request Action=\"WRITE RESOURCE\"><Name=\"{0}\" Value=\"{1}\" /></Request>";
    public static final String WRITE_FB_PARAMETER = "<Request Action=\"WRITE FB\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>";
    public static final String START_DEVICE = "<Request Action=\"START DEVICE\"/>";
    public static final String START_RESOURCE = "<Request Action=\"START RESOURCE\"/>";
    public static final String START_FB = "<Request Action=\"START FB\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>";
    public static final String KILL_DEVICE = "<Request Action=\"KILL DEVICE\"/>";
    public static final String KILL_RESOURCE = "<Request Action=\"KILL RESOURCE\"/>";
    public static final String DELETE_RESOURCE = "<Request Action=\"DELETE RESOURCE\"><FB Name=\"{0}\" Type=\"{1}\" /></Request>";
    public static final String DELETE_FB_INSTANCE = "<Request Action=\"DELETE FB\"><FB Name=\"{0}\" /></Request>";
    public static final String DELETE_CONNECTION = "<Request Action=\"DELETE CONNECTION\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>";
    public static final String ADD_WATCH = "<Request Action=\"ADD WATCH\"><Connection Destination=\"{0}\" /></Request>";
    public static final String READ_WATCHES = "<Request Action=\"READ\"><Watches/></Request>";
    public static final String REMOVE_WATCH = "<Request Action=\"REMOVE WATCH\"><Connection Destination=\"{0}\" /></Request>";
    public static final String TRIGGER_EVENT = "<Request Action=\"WRITE\"><Connection Destination=\"{0}\" /></Request>";
    public static final String FORCE_VALUE = "<Request Action=\"WRITE\"><Connection Destination=\"{0}\" Value=\"{1}\" /></Request>";
    public static final String CLEAR_FORCE = "<Request Action=\"WRITE\"><Connection Destination=\"{0}\" /></Request>";
    public static final String QUERY_RESOURCES = "<Request Action=\"QUERY\"></Request>";
    public static final String QUERY_FB_TYPE = "<Request Action=\"QUERY\"><FBType Name=\"{0}\" /></Request>";
    public static final String QUERY_DATA_TYPE = "<Request Action=\"QUERY\"><DataType Name=\"{0}\" /></Request>";
    public static final String QUERY_GLOBAL_CONST_TYPE = "<Request Action=\"QUERY\"><GlobalConstType Name=\"{0}\" /></Request>";
    public static final String READ_TRACES = "<Request Action=\"READ TRACES\"><Connection Destination=\"{0}\" Source=\"{1}\" /></Request>";
    public static final String REPLAY_NEXT_EVENT = "<Request Action=\"REPLAY NEXT EVENT\"><Connection Destination=\"{0}\"/></Request>";
    public static final String RESPONSE = "<Response Reason=\"{0}\"/>";
    public static final String RESPONSE_WITH_ARGUMENT = "<Response Reason=\"{0}\">{1}</Response>";
    public static final String WATCHES_RESPONSE = "<Response>\n  <Watches>\n    {0}\n  </Watches>\n</Response>";
    public static final String QUERY_RESPONSE = "<Response>\n  <FBList>\n    {0}\n  </FBList>\n</Response>";
    public static final String QUERY_TYPE_RESPONSE = "<Response>\n  {0}\n</Response>";
    public static final Response EMPTY_RESPONSE;
    public static final String FB_NAME_FORMAT = "{0}{1}";
    public static final String FB_PORT_NAME_FORMAT = "{0}{1}.{2}{3}";
    public static final String MGM_RESPONSE_READY = "Ready";
    public static final String MGM_RESPONSE_BAD_PARAMS = "BadParams";
    public static final String MGM_RESPONSE_LOCAL_TERMINATION = "LocalTermination";
    public static final String MGM_RESPONSE_SYSTEM_TERMINATION = "SystemTermination";
    public static final String MGM_RESPONSE_NOT_READY = "NotReady";
    public static final String MGM_RESPONSE_UNSUPPORTED_CMD = "UnsupportedCmd";
    public static final String MGM_RESPONSE_UNSUPPORTED_TYPE = "UnsupportedType";
    public static final String MGM_RESPONSE_NO_SUCH_OBJECT = "NoSuchObject";
    public static final String MGM_RESPONSE_INVALID_OBJECT = "InvalidObject";
    public static final String MGM_RESPONSE_INVALID_OPERATION = "InvalidOperation";
    public static final String MGM_RESPONSE_INVALID_STATE = "InvalidState";
    public static final String MGM_RESPONSE_OVERFLOW = "Overflow";
    public static final String MGM_RESPONSE_UNKNOWN = "Unknown";
    public static final Map<Long, String> RESPONSE_MAP;

    static {
        RESPONSE_MAP = Map.ofEntries(new AbstractMap.SimpleEntry<Long, String>(StatusCode.GOOD.getValue(), MGM_RESPONSE_READY), new AbstractMap.SimpleEntry<Long, String>(2158690304L, MGM_RESPONSE_BAD_PARAMS), new AbstractMap.SimpleEntry<Long, String>(0x800C0000L, MGM_RESPONSE_LOCAL_TERMINATION), new AbstractMap.SimpleEntry<Long, String>(0x80040000L, MGM_RESPONSE_SYSTEM_TERMINATION), new AbstractMap.SimpleEntry<Long, String>(2160001024L, MGM_RESPONSE_NOT_READY), new AbstractMap.SimpleEntry<Long, String>(0x80400000L, MGM_RESPONSE_UNSUPPORTED_CMD), new AbstractMap.SimpleEntry<Long, String>(0x80110000L, MGM_RESPONSE_UNSUPPORTED_TYPE), new AbstractMap.SimpleEntry<Long, String>(2151546880L, MGM_RESPONSE_NO_SUCH_OBJECT), new AbstractMap.SimpleEntry<Long, String>(2151481344L, MGM_RESPONSE_INVALID_OBJECT), new AbstractMap.SimpleEntry<Long, String>(2162425856L, MGM_RESPONSE_INVALID_OPERATION), new AbstractMap.SimpleEntry<Long, String>(2158952448L, MGM_RESPONSE_INVALID_STATE), new AbstractMap.SimpleEntry<Long, String>(0x80810000L, MGM_RESPONSE_OVERFLOW));
        EMPTY_RESPONSE = DevResponseFactory.eINSTANCE.createResponse();
        EMPTY_RESPONSE.setFblist(DevResponseFactory.eINSTANCE.createFBList());
        EMPTY_RESPONSE.setID("0");
        EMPTY_RESPONSE.setWatches(DevResponseFactory.eINSTANCE.createWatches());
    }

    private Constants() {
    }
}

