/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval.fb;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.devResponse.Watches;
import org.eclipse.fordiac.ide.deployment.eval.Messages;
import org.eclipse.fordiac.ide.deployment.eval.fb.DeploymentFBNetworkElementEvaluator;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class DeploymentSubAppEvaluator
extends DeploymentFBNetworkElementEvaluator<SubAppType, TypedSubApp> {
    private final Map<IInterfaceElement, Set<DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?>>> connectionEndpoints = ((TypedSubApp)this.getInstance()).getInterface().getAllInterfaceElements().collect(Collectors.toUnmodifiableMap(Function.identity(), DeploymentSubAppEvaluator::resolveSubappInterfaceEndpoints));
    private ResourceDeploymentData deploymentData;

    public DeploymentSubAppEvaluator(SubAppType type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, LibraryElementFactory.eINSTANCE.createTypedSubApp(), context, variables, parent);
    }

    private static Set<DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?>> resolveSubappInterfaceEndpoints(IInterfaceElement element) {
        return DeploymentDebugWatchUtils.resolveSubappInterfaceEndpoints((IInterfaceElement)element).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    protected void deployInstance() throws DeploymentException {
        this.deploymentData = new ResourceDeploymentData(this.getSharedState().getResource());
        this.getSharedState().deploy(this.deploymentData);
    }

    @Override
    protected void deleteInstance() throws DeploymentException {
        this.getSharedState().delete(this.deploymentData);
        this.deploymentData = null;
    }

    @Override
    protected void addWatch(IInterfaceElement element) throws EvaluatorException {
        for (DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?> endpoint : this.connectionEndpoints.get(element)) {
            try {
                this.getSharedState().addWatch(this.getResourceRelativeName((INamedElement)endpoint.element()));
            }
            catch (DeploymentException e) {
                throw new EvaluatorException(MessageFormat.format(Messages.DeploymentSubAppEvaluator_CannotAddWatch, endpoint.element().getQualifiedName(), element.getQualifiedName()), (Throwable)e, (Evaluator)this);
            }
        }
    }

    @Override
    protected void removeWatch(IInterfaceElement element) throws EvaluatorException {
        for (DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?> endpoint : this.connectionEndpoints.get(element)) {
            try {
                this.getSharedState().removeWatch(this.getResourceRelativeName((INamedElement)endpoint.element()));
            }
            catch (DeploymentException e) {
                throw new EvaluatorException(MessageFormat.format(Messages.DeploymentSubAppEvaluator_CannotRemoveWatch, endpoint.element().getQualifiedName(), element.getQualifiedName()), (Throwable)e, (Evaluator)this);
            }
        }
    }

    @Override
    protected boolean triggerEvent(Event event) throws EvaluatorException {
        Set<DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?>> endpoints = this.connectionEndpoints.get(event);
        if (endpoints.isEmpty()) {
            return false;
        }
        for (DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?> endpoint : endpoints) {
            try {
                this.getSharedState().triggerEvent(this.getResourceRelativeName((INamedElement)endpoint.element()));
            }
            catch (DeploymentException e) {
                throw new EvaluatorException(MessageFormat.format(Messages.DeploymentSubAppEvaluator_CannotTriggerEvent, endpoint.element().getQualifiedName(), event.getQualifiedName()), (Throwable)e, (Evaluator)this);
            }
        }
        return true;
    }

    @Override
    protected void writeVariable(VarDeclaration varDeclaration) throws EvaluatorException {
        Value value = ((Variable)this.getVariables().get(varDeclaration.getName())).getValue();
        for (DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?> endpoint : this.connectionEndpoints.get(varDeclaration)) {
            Value endpointValue = DeploymentSubAppEvaluator.convertWatchValue(endpoint, value);
            Variable endpointVariable = VariableOperations.newVariable((VarDeclaration)((VarDeclaration)endpoint.element()), (Value)endpointValue);
            try {
                this.getSharedState().writeFBParameter(this.getResourceRelativeName((INamedElement)endpoint.element()), endpointVariable.toString(false));
            }
            catch (DeploymentException e) {
                throw new EvaluatorException(MessageFormat.format(Messages.DeploymentSubAppEvaluator_CannotWriteValue, endpoint.element().getQualifiedName(), varDeclaration.getQualifiedName()), (Throwable)e, (Evaluator)this);
            }
        }
    }

    @Override
    protected void updateWatch(Event event, Watches watches) throws EvaluatorException {
        this.connectionEndpoints.get(event).stream().mapToInt(endpoint -> this.parseWatchValue((Event)endpoint.element(), this.getWatchValue(watches, endpoint.element()))).reduce(Integer::sum).ifPresent(value -> this.updateWatch(event, value));
    }

    @Override
    protected void updateWatch(VarDeclaration varDeclaration, Watches watches) throws EvaluatorException {
        this.connectionEndpoints.get(varDeclaration).stream().findAny().map(endpoint -> DeploymentSubAppEvaluator.convertWatchValue(endpoint, this.parseWatchValue((VarDeclaration)endpoint.element(), this.getWatchValue(watches, endpoint.element())))).ifPresent(value -> this.updateWatch(varDeclaration, (Value)value));
    }

    private static Value convertWatchValue(DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?> endpoint, Value value) throws EvaluatorException {
        if (endpoint.negate()) {
            return ValueOperations.bitwiseNot((Value)value);
        }
        return value;
    }

    protected ResourceDeploymentData getDeploymentData() {
        return this.deploymentData;
    }
}

