/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.impl.CFBInstanceImpl;
import org.eclipse.fordiac.ide.model.libraryElement.impl.SubAppImpl;

public class Utils {
    private static final Set<String> SIFB_IN_FORTE_NOT_IN_IDE = Set.of("E_CYCLE");

    private Utils() {
    }

    public static Map<String, Set<String>> collectAllValueHolders(Device device) {
        return Utils.transformToNames(Utils.collectAllValueHolderElements(device));
    }

    public static Map<String, Set<IInterfaceElement>> collectAllValueHolderElements(Device device) {
        HashMap<String, Set<IInterfaceElement>> result = new HashMap<String, Set<IInterfaceElement>>();
        for (Resource resource : device.getResource()) {
            result.put(resource.getName(), new HashSet());
            Utils.collectAllValueHolderElements(resource, result);
        }
        return result;
    }

    public static Map<String, Set<String>> transformToNames(Map<String, Set<IInterfaceElement>> elements) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<IInterfaceElement>> entry : elements.entrySet()) {
            HashSet<String> names = new HashSet<String>();
            for (IInterfaceElement interfaceElement : entry.getValue()) {
                names.add(Utils.getWatchName(interfaceElement));
            }
            result.put(entry.getKey(), names);
        }
        return result;
    }

    public static String getWatchName(IInterfaceElement interfaceElement) {
        String deviceName = interfaceElement.getBlockFBNetworkElement().getResource().getDevice().getName();
        String resourceName = interfaceElement.getBlockFBNetworkElement().getResource().getName();
        String prefix = deviceName + "." + resourceName + ".";
        String toAdd = interfaceElement.getQualifiedName();
        if (toAdd.startsWith(prefix)) {
            return toAdd.substring(prefix.length());
        }
        return toAdd;
    }

    public static boolean isSIFB(FBType fbType) {
        if (SIFB_IN_FORTE_NOT_IN_IDE.contains(fbType.getName())) {
            return true;
        }
        return fbType instanceof ServiceInterfaceFBType;
    }

    public static FB getInstanceFB(Resource resource, String fbName) {
        FB fb = resource.getFBNetwork().getFBNamed(fbName);
        if (fb != null) {
            return fb;
        }
        if (!fbName.contains(".")) {
            return null;
        }
        String prefix = fbName.substring(0, fbName.indexOf(46));
        Optional<Application> application = resource.getAutomationSystem().getApplication().stream().filter(app -> app.getName().equals(prefix)).findFirst();
        if (!application.isPresent()) {
            System.err.println("Application name " + prefix + " does not exist");
            return null;
        }
        String suffix = fbName.substring(fbName.indexOf(46) + 1);
        return Utils.getInstanceFB(resource.getFBNetwork(), suffix);
    }

    private static FB getInstanceFB(FBNetwork network, String name) {
        if (network == null) {
            return null;
        }
        if (!name.contains(".")) {
            return network.getFBNamed(name);
        }
        String prefix = name.substring(0, name.indexOf(46));
        String suffix = name.substring(name.indexOf(46) + 1);
        for (FBNetworkElement networkElement : network.getNetworkElements()) {
            if (!networkElement.getName().equals(prefix)) continue;
            if (networkElement instanceof CFBInstance) {
                CFBInstance cfb = (CFBInstance)networkElement;
                return Utils.getInstanceFB(cfb.loadCFBNetwork(), suffix);
            }
            if (networkElement instanceof SubApp) {
                SubApp subApp = (SubApp)networkElement;
                FBNetwork internalNetwork = subApp.loadSubAppNetwork();
                if (internalNetwork == null) {
                    internalNetwork = ((SubApp)subApp.getOpposite()).loadSubAppNetwork();
                }
                return Utils.getInstanceFB(internalNetwork, suffix);
            }
            System.err.println("Element with name " + prefix + " has not internal network");
        }
        return null;
    }

    private static void collectAllValueHolderElements(Resource resource, Map<String, Set<IInterfaceElement>> result) {
        Utils.collectAllValueHolderElements(resource.getFBNetwork(), result);
    }

    private static void collectAllValueHolderElements(FBNetwork network, Map<String, Set<IInterfaceElement>> result) {
        if (network == null) {
            return;
        }
        TreeIterator it = network.eAllContents();
        while (it.hasNext()) {
            IInterfaceElement varDecl;
            EObject obj = (EObject)it.next();
            if (!(obj instanceof IInterfaceElement) || (varDecl = (IInterfaceElement)obj).getBlockFBNetworkElement() instanceof SubAppImpl) continue;
            result.get(varDecl.getBlockFBNetworkElement().getResource().getName()).add(varDecl);
        }
        for (FBNetworkElement networkElement : network.getNetworkElements()) {
            if (networkElement instanceof CFBInstanceImpl) {
                CFBInstanceImpl composite = (CFBInstanceImpl)networkElement;
                Utils.collectAllValueHolderElements(composite.loadCFBNetwork(), result);
                continue;
            }
            if (!(networkElement instanceof SubAppImpl)) continue;
            SubAppImpl subApp = (SubAppImpl)networkElement;
            FBNetwork internalNetwork = subApp.loadSubAppNetwork();
            if (internalNetwork == null) {
                internalNetwork = ((SubApp)subApp.getOpposite()).loadSubAppNetwork();
            }
            Utils.collectAllValueHolderElements(internalNetwork, result);
        }
    }
}

