/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.DataPointChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.EventChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.ReplayNavigatorManager;
import org.eclipse.fordiac.ide.debug.replaydebugging.simulator.IDeviceSimulator;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ReplayDebuggingResource
implements ReplayNavigator.StateListener {
    private ReplayNavigator replayNavigator;
    private final ReplayNavigator.Identifier replayNavigatorIdentifier;
    private final Resource resource;
    private final UpdateListener updateListener;
    private final IDeviceSimulator simulator;
    org.eclipse.fordiac.ide.deployment.devResponse.Resource resourceResponse = DevResponseFactory.eINSTANCE.createResource();
    private final Map<String, Data> dataValues = new HashMap<String, Data>();

    public ReplayDebuggingResource(Resource resource, ReplayNavigator.Identifier reaplayNavigatorIdentifier, IDeviceSimulator simulator, UpdateListener updateListener) {
        this.replayNavigatorIdentifier = reaplayNavigatorIdentifier;
        this.resource = resource;
        this.updateListener = updateListener;
        this.simulator = simulator;
    }

    public org.eclipse.fordiac.ide.deployment.devResponse.Resource getResourceResponse() {
        return this.resourceResponse;
    }

    public EventChange getCurrentEventChange() {
        return this.replayNavigator.getCurrentEventChange();
    }

    public void load() {
        this.createReplayNavigator();
    }

    public void unload() {
        this.replayNavigator.removeStateChangeListener(this);
        ReplayNavigatorManager.getDefault().unregisterNavigator(this.replayNavigator);
    }

    private void createReplayNavigator() {
        ReplayNavigator.DatapointsState initialState = this.simulator.getCurrentState(this.resource);
        this.createResourceResponse(initialState);
        List<EventChange> eventChanges = this.iterateOverAllEvents(initialState);
        this.replayNavigator = new ReplayNavigator(this.replayNavigatorIdentifier, initialState, eventChanges);
        this.replayNavigator.addStateChangeListener(this);
        ReplayNavigatorManager.getDefault().registerNavigator(this.replayNavigator);
    }

    private void createResourceResponse(ReplayNavigator.DatapointsState initialState) {
        this.resourceResponse.setName(this.resource.getName());
        EList responseFBs = this.resourceResponse.getFbs();
        HashMap<String, FB> existingResponseFBs = new HashMap<String, FB>();
        for (Map.Entry entry : initialState.entrySet()) {
            FB responseFB;
            String datapoint = (String)entry.getKey();
            String value = (String)entry.getValue();
            int lastDot = datapoint.lastIndexOf(46);
            String fbName = datapoint.substring(0, lastDot);
            String portName = datapoint.substring(lastDot + 1);
            if (!existingResponseFBs.containsKey(fbName)) {
                responseFB = DevResponseFactory.eINSTANCE.createFB();
                responseFB.setName(fbName);
                responseFBs.add((Object)responseFB);
                existingResponseFBs.put(fbName, responseFB);
            } else {
                responseFB = (FB)existingResponseFBs.get(fbName);
            }
            EList responseFBPorts = responseFB.getPorts();
            Port responsePort = DevResponseFactory.eINSTANCE.createPort();
            responsePort.setName(portName);
            responseFBPorts.add((Object)responsePort);
            EList responsePortDataValues = responsePort.getDataValues();
            Data dataValuesValue = DevResponseFactory.eINSTANCE.createData();
            dataValuesValue.setValue(value);
            responsePortDataValues.add((Object)dataValuesValue);
            this.dataValues.put(datapoint, dataValuesValue);
        }
    }

    private List<EventChange> iterateOverAllEvents(ReplayNavigator.DatapointsState initialState) {
        int eventCounter = 0;
        ArrayList<EventChange> eventChanges = new ArrayList<EventChange>();
        HashMap<String, String> previousState = new HashMap<String, String>(initialState);
        Optional<String> lastEvent = this.simulator.replayNextEvent(this.resource);
        while (lastEvent.isPresent()) {
            ReplayNavigator.DatapointsState currentState = this.simulator.getCurrentState(this.resource);
            ArrayList<DataPointChange> dataPointChanges = new ArrayList<DataPointChange>();
            for (Map.Entry entry : currentState.entrySet()) {
                String key = (String)entry.getKey();
                String currentStateValue = (String)entry.getValue();
                if (((String)previousState.get(key)).equals(currentStateValue)) continue;
                dataPointChanges.add(new DataPointChange(key, (String)previousState.get(key), currentStateValue));
            }
            eventChanges.add(new EventChange(++eventCounter, lastEvent.get(), dataPointChanges));
            previousState = new HashMap<String, String>(currentState);
            String toLog = "\nEvent triggered " + lastEvent.get() + " with the following data changes:";
            for (DataPointChange change : dataPointChanges) {
                toLog = toLog + "  " + change.datapoint() + ": " + change.newValue();
            }
            FordiacLogHelper.logInfo((String)toLog);
            lastEvent = this.simulator.replayNextEvent(this.resource);
        }
        return eventChanges;
    }

    @Override
    public void update(ReplayNavigator replayNavigator, ReplayNavigator.DatapointsState changedValues) {
        for (Map.Entry entry : changedValues.entrySet()) {
            String datapoint = (String)entry.getKey();
            String value = (String)entry.getValue();
            Data dataValue = this.dataValues.get(datapoint);
            dataValue.setValue(value);
        }
        this.updateListener.onUpdate(this);
    }

    @FunctionalInterface
    public static interface UpdateListener {
        public void onUpdate(ReplayDebuggingResource var1);
    }
}

