/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.equi;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class DefaultEquiEngine
implements IEquiEngine {
    @Override
    public void computeEquivalences(Comparison comparison, Monitor monitor) {
        monitor.subTask(EMFCompareMessages.getString("DefaultEquiEngine.monitor.eq"));
        for (Diff difference : comparison.getDifferences()) {
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            this.checkForEquivalences(comparison, difference);
        }
    }

    protected void checkForEquivalences(Comparison comparison, Diff difference) {
        if (difference instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)difference;
            EReference reference = referenceChange.getReference();
            EReference eOpposite = reference.getEOpposite();
            if (eOpposite != null && !eOpposite.isContainer() && !eOpposite.isDerived()) {
                this.checkForEquivalences(comparison, referenceChange);
            }
        } else if (difference instanceof FeatureMapChange) {
            FeatureMapChange featureMapChange = (FeatureMapChange)difference;
            this.checkForEquivalences(comparison, featureMapChange);
        }
    }

    protected void checkForEquivalences(final Comparison comparison, final ReferenceChange referenceChange) {
        Equivalence equivalence = referenceChange.getEquivalence();
        if (equivalence == null) {
            EObject referenceValue;
            boolean valueIsContainer;
            equivalence = CompareFactory.eINSTANCE.createEquivalence();
            Match valueMatch = comparison.getMatch(referenceChange.getValue());
            final EReference eOpposite = referenceChange.getReference().getEOpposite();
            EObject referenceContainer = ComparisonUtil.getExpectedSide(referenceChange.getMatch(), referenceChange.getSource(), false);
            boolean bl = valueIsContainer = referenceContainer == (referenceValue = ComparisonUtil.getExpectedSide(valueMatch, referenceChange.getSource(), false)) && referenceContainer != null;
            if (eOpposite != null && valueMatch != null) {
                Predicate<Diff> candidateFilter = new Predicate<Diff>(){

                    @Override
                    public boolean test(Diff input) {
                        if (input instanceof ReferenceChange && ((ReferenceChange)input).getReference() == eOpposite) {
                            boolean oneIsMany;
                            Match candidateMatch = comparison.getMatch(((ReferenceChange)input).getValue());
                            boolean sameMatch = candidateMatch == referenceChange.getMatch();
                            boolean bl = oneIsMany = referenceChange.getReference().isMany() || eOpposite.isMany();
                            return sameMatch && (oneIsMany || !valueIsContainer);
                        }
                        return false;
                    }
                };
                Iterable candidates = valueMatch.getDifferences().stream().filter(candidateFilter)::iterator;
                for (Diff candidate : candidates) {
                    equivalence.getDifferences().add((Object)candidate);
                }
                this.addChangesFromOrigin(comparison, referenceChange, equivalence);
            }
            if (!equivalence.getDifferences().isEmpty()) {
                comparison.getEquivalences().add((Object)equivalence);
                equivalence.getDifferences().add((Object)referenceChange);
            }
        }
    }

    private void addChangesFromOrigin(Comparison comparison, ReferenceChange diff, Equivalence equivalence) {
        if (!diff.getReference().isMany()) {
            EObject originContainer = ComparisonUtil.getExpectedSide(diff.getMatch(), diff.getSource(), false);
            Match valueMatch = comparison.getMatch(diff.getValue());
            if (originContainer != null) {
                for (Diff candidate : comparison.getDifferences(originContainer)) {
                    boolean containerIsValue;
                    if (!(candidate instanceof ReferenceChange)) continue;
                    ReferenceChange candidateRC = (ReferenceChange)candidate;
                    boolean sameReference = diff.getReference().equals(candidateRC.getReference().getEOpposite());
                    boolean sameContainer = originContainer == ComparisonUtil.getExpectedSide(candidate.getMatch(), candidate.getSource(), false);
                    boolean bl = containerIsValue = originContainer == ComparisonUtil.getExpectedSide(valueMatch, candidate.getSource(), false);
                    if (!sameReference || !candidateRC.getReference().isMany() && sameContainer && containerIsValue) continue;
                    equivalence.getDifferences().add((Object)candidate);
                }
            }
        }
    }

    protected void checkForEquivalences(Comparison comparison, FeatureMapChange featureMapChange) {
        Equivalence equivalence = featureMapChange.getEquivalence();
        if (equivalence == null) {
            LinkedHashSet<Diff> differences = new LinkedHashSet<Diff>();
            differences.addAll((Collection<Diff>)featureMapChange.getMatch().getDifferences());
            Object featureMapEntry = featureMapChange.getValue();
            Object entryValue = ((FeatureMap.Entry)featureMapEntry).getValue();
            if (entryValue instanceof EObject) {
                this.addMatchDifferences(comparison.getMatch((EObject)entryValue), comparison, differences);
            }
            EStructuralFeature entryKey = ((FeatureMap.Entry)featureMapEntry).getEStructuralFeature();
            LinkedHashSet<ReferenceChange> equivalentDiffs = new LinkedHashSet<ReferenceChange>();
            IEqualityHelper equalityHelper = comparison.getEqualityHelper();
            Iterable refChanges = differences.stream().filter(ReferenceChange.class::isInstance).map(ReferenceChange.class::cast)::iterator;
            for (ReferenceChange refChange : refChanges) {
                boolean sameMove;
                boolean sameValue = equalityHelper.matchingValues(refChange.getValue(), entryValue);
                boolean sameSource = featureMapChange.getSource() == refChange.getSource();
                boolean sameReference = refChange.getReference() == entryKey;
                boolean bl = sameMove = refChange.getKind() == DifferenceKind.MOVE && featureMapChange.getKind() == DifferenceKind.MOVE;
                if (!sameSource || !sameValue || !sameReference && !sameMove) continue;
                equivalentDiffs.add(refChange);
                if (equivalence != null || refChange.getEquivalence() == null) continue;
                equivalence = refChange.getEquivalence();
            }
            if (!equivalentDiffs.isEmpty()) {
                if (equivalence == null) {
                    equivalence = CompareFactory.eINSTANCE.createEquivalence();
                    comparison.getEquivalences().add((Object)equivalence);
                }
                equivalence.getDifferences().add((Object)featureMapChange);
                equivalence.getDifferences().addAll(equivalentDiffs);
            }
        }
    }

    private void addMatchDifferences(Match match, Comparison comparison, Set<Diff> differences) {
        if (match != null) {
            Match rightParentMatch;
            Match leftParentMatch;
            differences.addAll((Collection<Diff>)match.getDifferences());
            if (match.getLeft() != null && (leftParentMatch = comparison.getMatch(match.getLeft().eContainer())) != null) {
                differences.addAll((Collection<Diff>)leftParentMatch.getDifferences());
            }
            if (match.getRight() != null && (rightParentMatch = comparison.getMatch(match.getRight().eContainer())) != null) {
                differences.addAll((Collection<Diff>)rightParentMatch.getDifferences());
            }
        }
    }
}

