/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableLongSetFactory;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableLongSetFactory.class)
public class MutableLongSetFactoryImpl
implements MutableLongSetFactory {
    public static final MutableLongSetFactory INSTANCE = new MutableLongSetFactoryImpl();

    public MutableLongSet empty() {
        return new LongHashSet();
    }

    public MutableLongSet of() {
        return this.empty();
    }

    public MutableLongSet with() {
        return this.empty();
    }

    public MutableLongSet withInitialCapacity(int capacity) {
        return new LongHashSet(capacity);
    }

    public MutableLongSet of(long ... items) {
        return this.with(items);
    }

    public MutableLongSet with(long ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return LongHashSet.newSetWith(items);
    }

    public MutableLongSet ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public MutableLongSet withAll(LongIterable items) {
        return LongHashSet.newSet(items);
    }

    public MutableLongSet ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    public MutableLongSet withAll(Iterable<Long> iterable) {
        return Iterate.collectLong(iterable, Long::longValue, LongSets.mutable.empty());
    }

    public MutableLongSet ofAll(LongStream items) {
        return this.withAll(items);
    }

    public MutableLongSet withAll(LongStream items) {
        MutableLongSet newSet = this.empty();
        items.forEach(arg_0 -> ((MutableLongSet)newSet).add(arg_0));
        return newSet;
    }
}

