/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit;

import java.text.MessageFormat;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.model.edit.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTypeEntryAdapter
extends AdapterImpl {
    private final IEditorPart editor;
    private ActivationListener activationListener;
    private boolean reloadPending;

    protected abstract void reloadEditorType();

    public void dispose() {
        if (this.activationListener != null) {
            this.activationListener.dispose();
            this.activationListener = null;
        }
    }

    protected IEditorPart getEditor() {
        return this.editor;
    }

    protected AbstractTypeEntryAdapter(IEditorPart editor, IPartService partService) {
        this.editor = editor;
        this.activationListener = new ActivationListener(partService);
    }

    protected void checkEditorActivated() {
        if (this.reloadPending) {
            this.performReload();
        }
    }

    protected void handleFileContentChange() {
        if (this.isActiveEditor()) {
            this.performReload();
        } else {
            this.reloadPending = true;
        }
    }

    protected boolean isActiveEditor() {
        return !this.editorClosed() && this.getEditor().equals(this.getEditor().getSite().getPage().getActiveEditor());
    }

    protected boolean editorClosed() {
        return this.getEditor().getSite().getPage() == null;
    }

    private void performReload() {
        Display.getDefault().execute(() -> {
            if (!(this.editorClosed() || this.getEditor().isDirty() && this.openFileChangedDialog() != 0)) {
                this.reloadEditorType();
            }
        });
        this.reloadPending = false;
    }

    protected int openFileChangedDialog() {
        String message = MessageFormat.format(Messages.TypeEntryEditor_FileChanged_message, this.getEditor().getEditorInput().getName());
        MessageDialog dialog = new MessageDialog(this.getEditor().getSite().getShell(), Messages.TypeEntryEditor_FileChangedTitle, null, message, 3, new String[]{Messages.TypeEntryEditor_replace_button_label, Messages.TypeEntryEditor_dontreplace_button_label}, 0);
        return dialog.open();
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IPartService partService;
        private boolean ignoreUpdates;

        public ActivationListener(IPartService partService) {
            this.partService = partService;
            partService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.partService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.partService = null;
        }

        public void windowActivated(IWorkbenchWindow window) {
            window.getShell().getDisplay().asyncExec(() -> {
                IWorkbenchPage activePage = window.getActivePage();
                if (activePage != null) {
                    this.handleActivation(activePage.getActivePart());
                }
            });
        }

        public void partActivated(IWorkbenchPart part) {
            this.handleActivation(part);
        }

        private void handleActivation(IWorkbenchPart part) {
            if (AbstractTypeEntryAdapter.this.getEditor() == part && !this.ignoreUpdates) {
                this.ignoreUpdates = true;
                AbstractTypeEntryAdapter.this.checkEditorActivated();
                this.ignoreUpdates = false;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

