/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor;

import java.util.Objects;
import org.eclipse.fordiac.ide.typeeditor.XtextTypeEditorPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;

public class XtextTypeEditorPageNavigationLocation
extends TextSelectionNavigationLocation {
    private final IWorkbenchPage page;
    private final IEditorInput multiPageEditorInput;
    private final String multiPageEditorId;

    public XtextTypeEditorPageNavigationLocation(XtextTypeEditorPage part, boolean initialize) {
        super((ITextEditor)part, initialize);
        this.page = part.getSite().getPage();
        IEditorSite iEditorSite = part.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
            MultiPageEditorPart multiPageEditor = multiPageEditorSite.getMultiPageEditor();
            this.multiPageEditorInput = multiPageEditor.getEditorInput();
            this.multiPageEditorId = multiPageEditor.getEditorSite().getId();
        } else {
            this.multiPageEditorInput = null;
            this.multiPageEditorId = null;
        }
    }

    public IEditorInput getInput() {
        return (IEditorInput)super.getInput();
    }

    protected IEditorPart getEditorPart() {
        IEditorPart iEditorPart;
        IEditorPart editorPart = super.getEditorPart();
        if (editorPart == null && (iEditorPart = this.getMultiPageEditorPart()) instanceof MultiPageEditorPart) {
            MultiPageEditorPart multiPageEditorPart = (MultiPageEditorPart)iEditorPart;
            IEditorPart[] iEditorPartArray = multiPageEditorPart.findEditors(this.getInput());
            int n = iEditorPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart subEditor = iEditorPartArray[n2];
                if (Objects.equals(subEditor.getEditorSite().getId(), this.getId())) {
                    return subEditor;
                }
                ++n2;
            }
        }
        return editorPart;
    }

    protected IEditorPart getMultiPageEditorPart() {
        IEditorReference[] editorReferences = this.page.findEditors(this.multiPageEditorInput, this.multiPageEditorId, (this.multiPageEditorInput != null ? 1 : 0) | (this.multiPageEditorId != null ? 1 : 0));
        if (editorReferences.length > 0) {
            return editorReferences[0].getEditor(false);
        }
        return null;
    }
}

