/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HorizontalAlignmentPicker
extends Composite {
    private final Combo combo;

    public HorizontalAlignmentPicker(Composite parent, HorizontalAlignmentEnum alignment) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout());
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(new String[]{Messages.getString("HorizontalAlignmentPicker.center"), Messages.getString("HorizontalAlignmentPicker.left"), Messages.getString("HorizontalAlignmentPicker.right")});
        this.update(alignment);
    }

    private void update(HorizontalAlignmentEnum alignment) {
        if (alignment.equals((Object)HorizontalAlignmentEnum.CENTER)) {
            this.combo.select(0);
        } else if (alignment.equals((Object)HorizontalAlignmentEnum.LEFT)) {
            this.combo.select(1);
        } else if (alignment.equals((Object)HorizontalAlignmentEnum.RIGHT)) {
            this.combo.select(2);
        } else {
            throw new IllegalArgumentException("bad alignment: " + String.valueOf((Object)alignment));
        }
    }

    public HorizontalAlignmentEnum getSelectedAlignment() {
        int idx = this.combo.getSelectionIndex();
        if (idx == 0) {
            return HorizontalAlignmentEnum.CENTER;
        }
        if (idx == 1) {
            return HorizontalAlignmentEnum.LEFT;
        }
        if (idx == 2) {
            return HorizontalAlignmentEnum.RIGHT;
        }
        throw new IllegalStateException("shouldn't happen");
    }

    public void setSelectedAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(horizontalAlignment);
    }
}

