/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.command;

import java.math.BigDecimal;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.FormulaDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class FormulaFillHandlePasteCommandHandler
extends FillHandlePasteCommandHandler {
    protected FormulaDataProvider dataProvider;

    public FormulaFillHandlePasteCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard, FormulaDataProvider dataProvider) {
        super(selectionLayer, clipboard);
        this.dataProvider = dataProvider;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, FillHandlePasteCommand command) {
        if (this.clipboard.getCopiedCells() != null) {
            this.selectionLayer.doCommand(new DisableFormulaEvaluationCommand());
            super.doCommand(targetLayer, command);
            this.selectionLayer.doCommand(new EnableFormulaEvaluationCommand());
        }
        return true;
    }

    @Override
    protected Object getPasteValue(ILayerCell cell, FillHandlePasteCommand command, int toColumn, int toRow) {
        Object cellValue;
        Object object = cellValue = cell != null ? cell.getDataValue() : null;
        if (cellValue != null && this.dataProvider.getFormulaParser().isFunction(cellValue.toString())) {
            try {
                cellValue = this.dataProvider.getFormulaParser().updateReferences(cellValue.toString(), cell.getColumnPosition(), cell.getRowPosition(), toColumn, toRow);
            }
            catch (FunctionException e) {
                if (this.dataProvider.getErrorReporter() != null) {
                    this.dataProvider.getErrorReporter().addFormulaError(toColumn, toRow, e.getLocalizedMessage());
                }
                cellValue = e.getErrorMarkup();
            }
        } else if (cellValue instanceof String && this.dataProvider.getFormulaParser().isNumber((String)cellValue)) {
            final BigDecimal converted = this.dataProvider.getFormulaParser().convertToBigDecimal((String)cellValue);
            LayerCell temp = new LayerCell(cell.getLayer(), cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnPosition(), cell.getRowPosition(), cell.getColumnSpan(), cell.getRowSpan()){

                @Override
                public Object getDataValue() {
                    return converted;
                }
            };
            Object calculated = super.getPasteValue(temp, command, toColumn, toRow);
            cellValue = calculated != null ? calculated.toString() : calculated;
        } else {
            cellValue = super.getPasteValue(cell, command, toColumn, toRow);
        }
        return cellValue;
    }

    @Override
    protected BigDecimal calculateBigDecimalDiff(ILayerCell c1, ILayerCell c2) {
        BigDecimal result = null;
        if (c1 != null && c2 != null && c1.getDataValue() != null && c2.getDataValue() != null) {
            BigDecimal v1 = null;
            if (c1.getDataValue() instanceof BigDecimal) {
                v1 = (BigDecimal)c1.getDataValue();
            } else if (c1.getDataValue() instanceof String && this.dataProvider.getFormulaParser().isNumber((String)c1.getDataValue())) {
                v1 = this.dataProvider.getFormulaParser().convertToBigDecimal((String)c1.getDataValue());
            }
            BigDecimal v2 = null;
            if (c2.getDataValue() instanceof BigDecimal) {
                v2 = (BigDecimal)c2.getDataValue();
            } else if (c2.getDataValue() instanceof String && this.dataProvider.getFormulaParser().isNumber((String)c2.getDataValue())) {
                v2 = this.dataProvider.getFormulaParser().convertToBigDecimal((String)c2.getDataValue());
            }
            if (v1 != null && v2 != null) {
                result = v1.subtract(v2);
            }
        }
        return result;
    }
}

