/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public abstract class AbstractUntypedEditorInputFactory
implements IElementFactory {
    private static final String TAG_AUTOMATION_SYSTEM = "SYSTEM";
    private static final String TAG_PROJECT = "PROJECT";

    protected AbstractUntypedEditorInputFactory() {
    }

    protected static void saveAutomationSystem(IMemento memento, AutomationSystem system) {
        if (system != null) {
            memento.putString(TAG_AUTOMATION_SYSTEM, system.getTypeEntry().getFile().getProjectRelativePath().toString());
            memento.putString(TAG_PROJECT, system.getTypeEntry().getFile().getProject().getName());
        }
    }

    protected static AutomationSystem loadAutomationSystemName(IMemento memento) {
        String projectName = memento.getString(TAG_PROJECT);
        String systemPath = memento.getString(TAG_AUTOMATION_SYSTEM);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null) {
            IFile file = project.getFile(systemPath);
            return SystemManager.INSTANCE.getSystem(file);
        }
        return null;
    }
}

