/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ComboBoxWidgetFactory {
    public static ComboBoxCellEditor createComboBoxCellEditor(Composite parent, String[] items, int style) {
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor(parent, items, style);
        cellEditor.setActivationStyle(15);
        ComboBoxWidgetFactory.configureTypeaheadHandling((CCombo)cellEditor.getControl());
        return cellEditor;
    }

    public static void configureTypeaheadHandling(CCombo combo) {
        combo.addKeyListener((KeyListener)new ComboTypeaheadKeyListener(combo));
    }

    public static CCombo createCombo(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        CCombo combo = factory.createCCombo(parent, 12);
        ComboBoxWidgetFactory.configureTypeaheadHandling(combo);
        return combo;
    }

    public static CCombo createCombo(Composite parent) {
        CCombo combo = new CCombo(parent, 12);
        ComboBoxWidgetFactory.configureTypeaheadHandling(combo);
        return combo;
    }

    public static ComboBoxCellEditor createComboBoxCellEditor(Composite parent, String[] items) {
        return ComboBoxWidgetFactory.createComboBoxCellEditor(parent, items, 0);
    }

    private ComboBoxWidgetFactory() {
        throw new UnsupportedOperationException("Combobox Widget Factory should not be instantiated");
    }

    private static final class ComboTypeaheadKeyListener
    implements KeyListener {
        private static final int SEQUENCE_CLEAR_TIME_OUT = 1000;
        private final CCombo combo;
        private final StringBuilder keySequence = new StringBuilder();
        private long lastKeyTimeStamp = 0L;

        private ComboTypeaheadKeyListener(CCombo combo) {
            this.combo = combo;
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (Character.isLetterOrDigit(keyEvent.character)) {
                this.checkTime();
                this.keySequence.append(Character.toLowerCase(keyEvent.character));
                this.findMatchingEntry(this.keySequence.toString(), keyEvent);
            }
        }

        public void findMatchingEntry(String currentSequence, KeyEvent keyEvent) {
            int index = 0;
            String[] stringArray = this.combo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.toLowerCase().startsWith(currentSequence)) {
                    keyEvent.doit = false;
                    int oldIndex = this.combo.getSelectionIndex();
                    if (oldIndex == index) break;
                    this.combo.select(index);
                    Event e = new Event();
                    e.time = keyEvent.time;
                    e.stateMask = keyEvent.stateMask;
                    this.combo.notifyListeners(13, e);
                    break;
                }
                ++index;
                ++n2;
            }
        }

        public void checkTime() {
            long now = System.currentTimeMillis();
            if (now - this.lastKeyTimeStamp > 1000L) {
                this.keySequence.setLength(0);
            }
            this.lastKeyTimeStamp = now;
        }
    }
}

