/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.systemconfiguration.CommunicationConfigurationDetails;
import org.eclipse.fordiac.ide.systemconfiguration.Messages;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SegmentSection
extends AbstractDoubleColumnSection {
    private Text nameText;
    private Text commentText;
    private Group commConfigGroup;
    private Composite commConfigContents;

    protected Segment getInputType(Object input) {
        if (input instanceof EditPart) {
            EditPart ep = (EditPart)input;
            input = ep.getModel();
        }
        if (input instanceof Segment) {
            Segment segment = (Segment)input;
            return segment;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createSegmentInfoGroup(this.getLeftComposite());
        this.createCommunicationInfoGroup(this.getRightComposite());
    }

    private void createCommunicationInfoGroup(Composite parent) {
        this.commConfigGroup = this.getWidgetFactory().createGroup(parent, "Communication Details");
        this.commConfigGroup.setLayout((Layout)new GridLayout(2, false));
        this.commConfigGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.commConfigContents = new Composite((Composite)this.commConfigGroup, 2048);
    }

    protected void createSegmentInfoGroup(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, "Instance Name:");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)ChangeNameCommand.forName((INamedElement)this.getType(), (String)this.nameText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, "Instance Comment:");
        this.commentText = this.createGroupText(composite, true);
        GridData gridData = new GridData(4, 0, true, false);
        this.commentText.setLayoutData((Object)gridData);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
    }

    private CommandExecutor getSection() {
        return this;
    }

    protected Segment getType() {
        Object object = this.type;
        if (object instanceof Segment) {
            Segment segment = (Segment)object;
            return segment;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }

    protected void performRefresh() {
        this.nameText.setText(this.getType().getName());
        this.commentText.setText(this.getType().getComment());
        this.getRightComposite().setVisible(!"Ethernet".equals(this.getCommunicationType()));
        CommunicationConfigurationDetails commConfig = CommunicationConfigurationDetails.getCommConfigUiFromExtensionPoint((String)this.getCommunicationType(), (String)"id");
        if (commConfig == null) {
            ErrorMessenger.popUpErrorMessage((String)Messages.Segment_NoConfigErrorMessage);
            return;
        }
        this.commConfigContents.dispose();
        this.commConfigContents = commConfig.createUi((Composite)this.commConfigGroup, this.getType().getCommunication(), this.getSection(), this.getWidgetFactory());
        this.commConfigContents.pack();
    }

    private String getCommunicationType() {
        return this.getType().getTypeName();
    }
}

