/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.properties.VarConfigurationFilter;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationDataLayer;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarConfigInstance;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CheckBoxConfigurationNebula;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnEditableRule;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class VarConfigurationSection
extends AbstractSection {
    private static final String SEPARATION_POINT = ".";
    private NatTable inputTable;
    private IChangeableRowDataProvider<VarDeclaration> inputDataProvider;
    private EObject selectionRoot;
    private final LinkedHashMap<VarDeclaration, VDInfo> varConfigInfoMap = new LinkedHashMap();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTableSection(parent);
    }

    private void createTableSection(Composite parent) {
        Composite tableSectionComposite = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(tableSectionComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableSectionComposite);
        Group inputComposite = this.getWidgetFactory().createGroup(tableSectionComposite, Messages.VarConfigurationSection_VarConfigs);
        GridLayoutFactory.fillDefaults().applyTo((Composite)inputComposite);
        this.inputDataProvider = new ChangeableListDataProvider((IColumnAccessor)new VarConfigDeclarationColumnAccessor(this));
        VarDeclarationDataLayer inputDataLayer = new VarDeclarationDataLayer(this.inputDataProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG);
        inputDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new VarDeclarationConfigLabelAccumulator(this.inputDataProvider, () -> ((VarConfigurationSection)this).getAnnotationModel(), VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG));
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG);
        this.inputTable = NatTableWidgetFactory.createNatTable((Composite)inputComposite, (DataLayer)inputDataLayer, (IDataProvider)columnProvider, (IEditableRule)new NatTableColumnEditableRule((IEditableRule)new VarConfigEditableRule(), VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG, VarDeclarationTableColumn.DEFAULT_EDITABLE));
        this.inputTable.addConfiguration((IConfiguration)new CheckBoxConfigurationNebula());
        this.inputTable.addConfiguration((IConfiguration)new InitialValueEditorConfiguration(this.inputDataProvider));
        this.inputTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, (CommandExecutor)this));
        this.inputTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)inputComposite);
        tableSectionComposite.layout();
    }

    protected INamedElement getInputType(Object input) {
        return VarConfigurationFilter.getModel(input);
    }

    protected INamedElement getType() {
        Object object = this.type;
        if (object instanceof INamedElement) {
            INamedElement namedElement = (INamedElement)object;
            return namedElement;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
        this.inputDataProvider.setInput(this.collectVarConfigs());
        this.inputTable.refresh();
    }

    protected void performRefresh() {
        this.inputTable.refresh();
    }

    protected void performRefreshAnnotations() {
        this.inputTable.refresh(false);
    }

    private List<VarDeclaration> collectVarConfigs() {
        this.varConfigInfoMap.clear();
        this.selectionRoot = EcoreUtil.getRootContainer((EObject)this.getType());
        this.collectVarConfigsRecursive(this.getType(), "", null);
        ArrayList<VarDeclaration> varDeclList = new ArrayList<VarDeclaration>(this.varConfigInfoMap.keySet());
        varDeclList.sort((decl1, decl2) -> this.varConfigInfoMap.get(decl2).displayName().compareTo(this.varConfigInfoMap.get(decl1).displayName()));
        return varDeclList;
    }

    private void collectVarConfigsRecursive(INamedElement type, String currentPrefix, TypedSubApp currentSubappInstance) {
        INamedElement iNamedElement = type;
        Objects.requireNonNull(iNamedElement);
        INamedElement iNamedElement2 = iNamedElement;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Application.class, SubAppType.class, TypedSubApp.class, UntypedSubApp.class, BlockFBNetworkElement.class}, (Object)iNamedElement2, 0)) {
            case 0: {
                Application app = (Application)iNamedElement2;
                this.traverseFBNetwork(app.getFBNetwork(), currentPrefix, null);
                break;
            }
            case 1: {
                SubAppType subappType = (SubAppType)iNamedElement2;
                this.traverseFBNetwork(subappType.getFBNetwork(), currentPrefix, null);
                subappType.getInterfaceList().getInputVars().stream().filter(VarDeclaration::isVarConfig).forEach(varDecl -> {
                    String qualifiedName = currentPrefix + varDecl.getName();
                    this.varConfigInfoMap.put((VarDeclaration)varDecl, new VDInfo(qualifiedName, null, null));
                });
                break;
            }
            case 2: {
                TypedSubApp tsa = (TypedSubApp)iNamedElement2;
                boolean copy = EcoreUtil.getRootContainer((EObject)tsa) != this.selectionRoot;
                TypedSubApp newSubappInstance = copy ? currentSubappInstance : tsa;
                this.traverseFBNetwork(tsa.getType().getFBNetwork(), currentPrefix, newSubappInstance);
                this.traverseInterfaceElements((BlockFBNetworkElement)tsa, currentPrefix, copy, newSubappInstance);
                this.overrideParams(tsa, currentPrefix, copy);
                break;
            }
            case 3: {
                UntypedSubApp utsa = (UntypedSubApp)iNamedElement2;
                this.traverseFBNetwork(utsa.getSubAppNetwork(), currentPrefix, currentSubappInstance);
                this.traverseInterfaceElements((BlockFBNetworkElement)utsa, currentPrefix, EcoreUtil.getRootContainer((EObject)utsa) != this.selectionRoot, currentSubappInstance);
                break;
            }
            case 4: {
                BlockFBNetworkElement bfbne = (BlockFBNetworkElement)iNamedElement2;
                this.traverseInterfaceElements(bfbne, currentPrefix, EcoreUtil.getRootContainer((EObject)bfbne) != this.selectionRoot, currentSubappInstance);
                break;
            }
        }
    }

    private void overrideParams(TypedSubApp typedSubApp, String currentPrefix, boolean needCopy) {
        typedSubApp.getVarConfigParams().forEach(varConfigParameter -> {
            String qualifiedName = currentPrefix + varConfigParameter.getName();
            VarDeclaration toReplaceVarConfig = this.varConfigInfoMap.entrySet().stream().filter(e -> ((VDInfo)e.getValue()).displayName.equals(qualifiedName)).map(Map.Entry::getKey).findFirst().orElse(null);
            if (toReplaceVarConfig == null) {
                return;
            }
            VDInfo info = (VDInfo)this.varConfigInfoMap.remove(toReplaceVarConfig);
            if (info != null) {
                if (needCopy) {
                    VDInfo newInfo = new VDInfo(info.displayName(), (VarDeclaration)varConfigParameter, info.typedSubApp());
                    this.varConfigInfoMap.put((VarDeclaration)EcoreUtil.copy((EObject)varConfigParameter), newInfo);
                } else {
                    this.varConfigInfoMap.put((VarDeclaration)varConfigParameter, info);
                }
            }
        });
    }

    private void traverseInterfaceElements(BlockFBNetworkElement fbne, String currentPrefix, boolean isParamsCandidate, TypedSubApp currentSubappInstance) {
        fbne.getInterface().getInputVars().stream().filter(VarDeclaration::isVarConfig).forEach(varConfig -> {
            String qualifiedName = currentPrefix + varConfig.getName();
            if (isParamsCandidate) {
                VDInfo info = new VDInfo(qualifiedName, (VarDeclaration)varConfig, currentSubappInstance);
                String relativePath = info.getSubAppRelativePath(this.getType());
                this.varConfigInfoMap.put((VarDeclaration)InterfaceListCopier.copyVarConfigInstance((VarDeclaration)varConfig, (String)relativePath), info);
            } else {
                this.varConfigInfoMap.put((VarDeclaration)varConfig, new VDInfo(qualifiedName, null, null));
            }
        });
    }

    private void traverseFBNetwork(FBNetwork network, String currentPrefix, TypedSubApp currentSubappInstance) {
        network.getBlockFBNetworkElements().forEach(bfbne -> {
            String prefix = currentPrefix + bfbne.getName() + SEPARATION_POINT;
            this.collectVarConfigsRecursive((INamedElement)bfbne, prefix, currentSubappInstance);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void executeCommand(Command cmd) {
        super.executeCommand(cmd);
        if (cmd instanceof ChangeValueCommand) {
            ChangeValueCommand valueCmd = (ChangeValueCommand)cmd;
            VarDeclaration decl = valueCmd.getInterfaceElement();
            this.processVarConfigChange(decl, InitialValueHelper::getInitialOrDefaultValue);
        }
        if (cmd instanceof ChangeCommentCommand) {
            void decl;
            Object object;
            ChangeCommentCommand commentCmd = (ChangeCommentCommand)cmd;
            Object[] affected = commentCmd.getAffectedObjects().toArray();
            if (affected.length == 0 || !((object = affected[0]) instanceof VarConfigInstance)) {
                return;
            }
            VarConfigInstance varConfigInstance = (VarConfigInstance)object;
            this.processVarConfigChange((VarDeclaration)decl, INamedElement::getComment);
        }
    }

    private void processVarConfigChange(VarDeclaration varConfig, Function<VarDeclaration, String> varConfigMapper) {
        VarConfigInstance vci;
        VDInfo info = this.varConfigInfoMap.get(varConfig);
        if (info == null || info.varDeclType() == null || info.typedSubApp() == null) {
            return;
        }
        EList varConfigParameter = info.typedSubApp().getVarConfigParams();
        boolean matchesTyp = varConfigMapper.apply(varConfig).equals(varConfigMapper.apply(info.varDeclType()));
        if (matchesTyp) {
            String subAppRelativePath = info.getSubAppRelativePath(this.getType());
            varConfigParameter.removeIf(param -> param.getName().equals(subAppRelativePath));
        } else if (varConfig instanceof VarConfigInstance && !varConfigParameter.contains(vci = (VarConfigInstance)varConfig)) {
            varConfigParameter.add(vci);
        }
    }

    record VDInfo(String displayName, VarDeclaration varDeclType, TypedSubApp typedSubApp) {
        private String getSubAppRelativePath(INamedElement selectedElement) {
            String selectedElementName = selectedElement.getQualifiedName();
            String typedSubappName = this.typedSubApp().getQualifiedName();
            String cutTypedSubappName = typedSubappName.startsWith(selectedElementName + VarConfigurationSection.SEPARATION_POINT) ? typedSubappName.substring(selectedElementName.length() + 1) : typedSubappName;
            return this.displayName().startsWith(cutTypedSubappName + VarConfigurationSection.SEPARATION_POINT) ? this.displayName().substring(cutTypedSubappName.length() + 1) : this.displayName();
        }
    }

    private class VarConfigDeclarationColumnAccessor
    extends VarDeclarationColumnAccessor {
        private VarConfigDeclarationColumnAccessor(VarConfigurationSection section) {
            super((CommandExecutor)section, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG);
        }

        public Object getDataValue(VarDeclaration rowObject, VarDeclarationTableColumn column) {
            if (column == VarDeclarationTableColumn.NAME) {
                return VarConfigurationSection.this.varConfigInfoMap.get((Object)rowObject).displayName;
            }
            return super.getDataValue(rowObject, column);
        }
    }

    private class VarConfigEditableRule
    implements IEditableRule {
        private VarConfigEditableRule() {
        }

        public boolean isEditable(ILayerCell cell, IConfigRegistry configRegistry) {
            return this.isEditable(cell.getColumnIndex(), cell.getRowIndex());
        }

        public boolean isEditable(int columnIndex, int rowIndex) {
            VarDeclaration rowObject = (VarDeclaration)VarConfigurationSection.this.inputDataProvider.getRowObject(rowIndex);
            return this.checkEditable(columnIndex, rowObject);
        }

        private boolean checkEditable(int columnIndex, VarDeclaration rowObject) {
            VarDeclarationTableColumn column = (VarDeclarationTableColumn)VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_VISIBLE_AND_VAR_CONFIG.get(columnIndex);
            if (column == VarDeclarationTableColumn.VISIBLE || column == VarDeclarationTableColumn.VAR_CONFIG) {
                return !(rowObject instanceof VarConfigInstance);
            }
            return true;
        }
    }
}

