/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerDataType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;

public final class ConfigurableFBAnnotations {
    public static boolean validateDataType(ConfigurableFB element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (element.getDataType() == null) {
            if (diagnostics != null) {
                diagnostics.add(ConfigurableFBAnnotations.createTypeValidationDiagnostic(Messages.TypedElementAnnotations_TypeNotSet, element));
            }
            return false;
        }
        if (element.getDataType() instanceof ErrorMarkerDataType) {
            if (diagnostics != null) {
                diagnostics.add(ConfigurableFBAnnotations.createTypeValidationDiagnostic(MessageFormat.format(Messages.TypedElementAnnotations_TypeNotFound, ConfigurableFBAnnotations.getFullTypeName(element)), element));
            }
            return false;
        }
        return true;
    }

    private static Diagnostic createTypeValidationDiagnostic(String message, ConfigurableFB element) {
        return new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 4, message, FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.CONFIGURABLE_FB__DATA_TYPE, ConfigurableFBAnnotations.getFullTypeName(element)));
    }

    private static String getFullTypeName(ConfigurableFB element) {
        return PackageNameHelper.getFullTypeName(element.getDataType());
    }

    private ConfigurableFBAnnotations() {
        throw new UnsupportedOperationException();
    }
}

