/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class ChangeValueCommand
extends AbstractChangeInterfaceElementCommand {
    private VarDeclaration mirroredVar;
    private final String newValue;
    private String oldValue;

    public ChangeValueCommand(VarDeclaration variable, String value) {
        super((IInterfaceElement)variable);
        this.newValue = value == null ? "" : value;
    }

    public boolean canExecute() {
        return this.getInterfaceElement() != null && this.getInterfaceElement().getType() != null;
    }

    @Override
    protected void doExecute() {
        VarDeclaration variable = this.getInterfaceElement();
        this.mirroredVar = this.getMirroredVariable();
        if (variable.getValue() == null) {
            variable.setValue(LibraryElementFactory.eINSTANCE.createValue());
            if (this.mirroredVar != null) {
                this.mirroredVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            }
            this.oldValue = "";
        } else {
            this.oldValue = variable.getValue().getValue();
        }
        variable.getValue().setValue(this.newValue);
        this.setMirroredVar(this.newValue);
    }

    @Override
    protected void doUndo() {
        VarDeclaration variable = this.getInterfaceElement();
        variable.getValue().setValue(this.oldValue);
        this.setMirroredVar(this.oldValue);
    }

    @Override
    protected void doRedo() {
        VarDeclaration variable = this.getInterfaceElement();
        variable.getValue().setValue(this.newValue);
        this.setMirroredVar(this.newValue);
    }

    private VarDeclaration getMirroredVariable() {
        IInterfaceElement element;
        BlockFBNetworkElement opposite;
        VarDeclaration variable = this.getInterfaceElement();
        if (variable.getBlockFBNetworkElement() != null && variable.getBlockFBNetworkElement().isMapped() && (opposite = variable.getBlockFBNetworkElement().getOpposite()) != null && (element = opposite.getInterfaceElement(variable.getName())) instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)element;
            return varDecl;
        }
        return null;
    }

    private void setMirroredVar(String val) {
        if (this.mirroredVar != null) {
            this.mirroredVar.getValue().setValue(val);
        }
    }

    public VarDeclaration getInterfaceElement() {
        return (VarDeclaration)super.getInterfaceElement();
    }
}

